#ifndef _RHEOLEF_BASIS_FEM_PK_LAGRANGE_H
#define _RHEOLEF_BASIS_FEM_PK_LAGRANGE_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
/*Class:sherwin
NAME: @code{Pk} - Lagrange polynomial basis
@cindex  polynomial basis
@clindex space
@clindex basis
@clindex reference_element
SYNOPSIS:
  space Vh(omega,"P1");
DESCRIPTION:
  @noindent
  This is the most popular polynomial @code{basis} for the finite element method.
  It is indicated in the @code{space} (see @ref{space class})
  by a string starting with
  the letter @code{"P"},
  followed by digits indicating the polynomial order.

OPTIONS:
  This basis recognizes the equispaced/warburton node option
  and the raw polynomial option.
  See @ref{basis_option class}.

AUTHOR: Pierre.Saramito@imag.fr
DATE:   11 september 2017
End:
*/
#include "rheolef/basis.h"
namespace rheolef {

template<class T>
class basis_fem_Pk_lagrange: public basis_rep<T> {
public:

// typedefs:

  typedef basis_rep<T>              base;
  typedef reference_element::size_type size_type;
  typedef T                            value_type;

// allocators:

  basis_fem_Pk_lagrange (
    std::string              name,
    const basis_option& sopt);

  ~basis_fem_Pk_lagrange();

// accessors:

  std::string family_name() const { return "P"; }
  size_type degree() const { return _raw_basis.degree(); }
  bool is_nodal() const;
  void get_local_idof_on_side (
        reference_element            hat_K,
        const side_information_type& sid,
        arma::Col<size_type>&        loc_idof) const;

// evaluation of all basis functions at hat_x:

  void eval(
    reference_element                 hat_K,
    const point_basic<T>&             hat_x,
    arma::Col<T>&                     value) const;

// evaluate the gradient:

  void grad_eval(
    reference_element           hat_K,
    const point_basic<T>&       hat_x,
    std::vector<point_basic<T> >& value) const;

  void _initialize (reference_element hat_K) const;
  void _compute_dofs (
    reference_element     hat_K, 
    const arma::Col<T>&   f_xnod, // scalar-valued case
          arma::Col<T>&   dof) const;

protected:
// data:
  basis_raw_basic<T>                                _raw_basis;
};

} // namespace rheolef
#endif // _RHEOLEF_BASIS_FEM_PK_LAGRANGE_H
