% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weight.R, R/wtd_chisqtest.R, R/wtd_ttest.R
\name{wtd_sd}
\alias{wtd_sd}
\alias{wtd_mean}
\alias{wtd_se}
\alias{wtd_median}
\alias{svy_md}
\alias{wtd_chisqtest}
\alias{wtd_chisqtest.default}
\alias{wtd_chisqtest.formula}
\alias{wtd_ttest}
\alias{wtd_ttest.default}
\alias{wtd_ttest.formula}
\alias{wtd_mwu}
\alias{wtd_mwu.default}
\alias{wtd_mwu.formula}
\alias{wtd_cor}
\alias{wtd_cor.default}
\alias{wtd_cor.formula}
\title{Weighted statistics for tests and variables}
\usage{
wtd_sd(x, weights = NULL)

wtd_mean(x, weights = NULL)

wtd_se(x, weights = NULL)

wtd_median(x, weights = NULL)

svy_md(x, design)

wtd_chisqtest(data, ...)

\method{wtd_chisqtest}{default}(data, x, y, weights, ...)

\method{wtd_chisqtest}{formula}(formula, data, ...)

wtd_ttest(data, ...)

\method{wtd_ttest}{default}(data, x, y = NULL, weights, mu = 0,
  paired = FALSE, ci.lvl = 0.95, alternative = c("two.sided", "less",
  "greater"), ...)

\method{wtd_ttest}{formula}(formula, data, mu = 0, paired = FALSE,
  ci.lvl = 0.95, alternative = c("two.sided", "less", "greater"), ...)

wtd_mwu(data, ...)

\method{wtd_mwu}{default}(data, x, grp, weights, ...)

\method{wtd_mwu}{formula}(formula, data, ...)

wtd_cor(data, ...)

\method{wtd_cor}{default}(data, x, y, weights, ci.lvl = 0.95, ...)

\method{wtd_cor}{formula}(formula, data, ci.lvl = 0.95, ...)
}
\arguments{
\item{x}{(Numeric) vector or a data frame. For \code{svy_md()}, \code{wtd_ttest()},
\code{wtd_mwu()} and \code{wtd_chisqtest()} the bare (unquoted) variable
name, or a character vector with the variable name.}

\item{weights}{Bare (unquoted) variable name, or a character vector with
the variable name of the numeric vector of weights. If \code{weights = NULL},
unweighted statistic is reported.}

\item{design}{An object of class \code{\link[survey]{svydesign}}, providing
a specification of the survey design.}

\item{data}{A data frame.}

\item{...}{For \code{wtd_ttest()} and \code{wtd_mwu()}, currently not used.
For \code{wtd_chisqtest()}, further arguments passed down to
\code{\link[stats]{chisq.test}}.}

\item{y}{Optional, bare (unquoted) variable name, or a character vector with
the variable name.}

\item{formula}{A formula of the form \code{lhs ~ rhs1 + rhs2} where \code{lhs} is a
numeric variable giving the data values and \code{rhs1} a factor with two
levels giving the corresponding groups and \code{rhs2} a variable with weights.}

\item{mu}{A number indicating the true value of the mean (or difference in
means if you are performing a two sample test).}

\item{paired}{Logical, whether to compute a paired t-test.}

\item{ci.lvl}{Confidence level of the interval.}

\item{alternative}{A character string specifying the alternative hypothesis,
must be one of \code{"two.sided"} (default), \code{"greater"} or
\code{"less"}. You can specify just the initial letter.}

\item{grp}{Bare (unquoted) name of the cross-classifying variable, where
\code{x} is grouped into the categories represented by \code{grp},
or a character vector with the variable name.}
}
\value{
The weighted (test) statistic.
}
\description{
\strong{Weighted statistics for variables}
  \cr \cr
  \code{wtd_sd()}, \code{wtd_se()}, \code{wtd_mean()} and \code{wtd_median()}
  compute weighted standard deviation, standard error, mean or median for a
  variable or for all variables of a data frame. \code{svy_md()} computes the
  median for a variable in a survey-design (see \code{\link[survey]{svydesign}}).
  \code{wtd_cor()} computes a weighted correlation for a two-sided alternative
  hypothesis.
  \cr \cr
  \strong{Weighted tests}
  \cr \cr
  \code{wtd_ttest()} computes a weighted t-test, while \code{wtd_mwu()}
  computes a weighted Mann-Whitney-U test or a Kruskal-Wallis test
  (for more than two groups). \code{wtd_chisqtest()} computes a weighted
  Chi-squared test for contigency tables.
}
\note{
\code{wtd_chisq()} is a convenient wrapper for \code{\link{xtab_statistics}}.
   For a weighted one-way Anova, use \code{grpmean()} with
   \code{weights}-argument.
   \cr \cr
   \code{wtd_ttest()} assumes unequal variance between the two groups.
}
\examples{
# weighted sd and se ----

wtd_sd(rnorm(n = 100, mean = 3), runif(n = 100))

data(efc)
wtd_sd(efc[, 1:3], runif(n = nrow(efc)))
wtd_se(efc[, 1:3], runif(n = nrow(efc)))

# svy_md ----

# median for variables from weighted survey designs
library(survey)
data(nhanes_sample)

des <- svydesign(
  id = ~SDMVPSU,
  strat = ~SDMVSTRA,
  weights = ~WTINT2YR,
  nest = TRUE,
  data = nhanes_sample
)

svy_md(total, des)
svy_md("total", des)

# weighted t-test ----

efc$weight <- abs(rnorm(nrow(efc), 1, .3))
wtd_ttest(efc, e17age, weights = weight)
wtd_ttest(efc, e17age, c160age, weights = weight)
wtd_ttest(e17age ~ e16sex + weight, efc)

# weighted Mann-Whitney-U-test ----

wtd_mwu(c12hour ~ c161sex + weight, efc)

# weighted Chi-squared-test ----

wtd_chisqtest(efc, c161sex, e16sex, weights = weight, correct = FALSE)
wtd_chisqtest(c172code ~ c161sex + weight, efc)

}
