% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.R
\name{bias}
\alias{bias}
\title{Bias}
\usage{
bias(actual, predicted)
}
\arguments{
\item{actual}{The ground truth numeric vector.}

\item{predicted}{The predicted numeric vector, where each element in the vector
is a prediction for the corresponding element in \code{actual}.}
}
\description{
\code{bias} computes the average amount by which \code{actual} is greater than
\code{predicted}.
}
\details{
If a model is unbiased \code{bias(actual, predicted)} should be close to zero.
Bias is calculated by taking the average of (\code{actual} - \code{predicted}).
}
\examples{
actual <- c(1.1, 1.9, 3.0, 4.4, 5.0, 5.6)
predicted <- c(0.9, 1.8, 2.5, 4.5, 5.0, 6.2)
bias(actual, predicted)
}
\seealso{
\code{\link{percent_bias}}
}
