% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival-survfit-tidiers.R
\name{tidy.survfit}
\alias{tidy.survfit}
\alias{survfit_tidiers}
\title{Tidy a(n) survfit object}
\usage{
\method{tidy}{survfit}(x, ...)
}
\arguments{
\item{x}{An \code{survfit} object returned from \code{\link[survival:survfit]{survival::survfit()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with one row for each time point and columns:

\item{time}{timepoint}
\item{n.risk}{number of subjects at risk at time t0}
\item{n.event}{number of events at time t}
\item{n.censor}{number of censored events}
\item{estimate}{estimate of survival or cumulative incidence rate when
multistate}
\item{std.error}{standard error of estimate}
\item{conf.high}{upper end of confidence interval}
\item{conf.low}{lower end of confidence interval}
\item{state}{state if multistate survfit object inputted}
\item{strata}{strata if stratified survfit object inputted}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies cross models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{

library(survival)
cfit <- coxph(Surv(time, status) ~ age + sex, lung)
sfit <- survfit(cfit)

tidy(sfit)
glance(sfit)

library(ggplot2)
ggplot(tidy(sfit), aes(time, estimate)) + geom_line() +
    geom_ribbon(aes(ymin=conf.low, ymax=conf.high), alpha=.25)

# multi-state
fitCI <- survfit(Surv(stop, status * as.numeric(event), type = "mstate") ~ 1,
              data = mgus1, subset = (start == 0))
td_multi <- tidy(fitCI)
td_multi

ggplot(td_multi, aes(time, estimate, group = state)) +
    geom_line(aes(color = state)) +
    geom_ribbon(aes(ymin = conf.low, ymax = conf.high), alpha = .25)

}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[survival:survfit]{survival::survfit()}}

Other survival tidiers: \code{\link{augment.coxph}},
  \code{\link{augment.survreg}},
  \code{\link{glance.aareg}}, \code{\link{glance.cch}},
  \code{\link{glance.coxph}}, \code{\link{glance.pyears}},
  \code{\link{glance.survdiff}},
  \code{\link{glance.survexp}},
  \code{\link{glance.survfit}},
  \code{\link{glance.survreg}}, \code{\link{tidy.aareg}},
  \code{\link{tidy.cch}}, \code{\link{tidy.coxph}},
  \code{\link{tidy.pyears}}, \code{\link{tidy.survdiff}},
  \code{\link{tidy.survexp}}, \code{\link{tidy.survreg}}
}
\concept{survfit tidiers}
\concept{survival tidiers}
