/*!
 * @brief     SPI Register Definition Header File, automatically generated file at 1/20/2020 6:24:30 AM.
 *
 * @copyright copyright(c) 2018 - Analog Devices Inc.All Rights Reserved.
 *            This software is proprietary to Analog Devices, Inc. and its
 *            licensor. By using this software you agree to the terms of the
 *            associated analog devices software license agreement.
 */

/*!
 * @addtogroup AD9081_BF
 * @{
 */
#ifndef __ADI_AD9081_BF_AD9081_H__
#define __ADI_AD9081_BF_AD9081_H__

/*============= I N C L U D E S ============*/
#include "adi_ad9081_config.h"

/*============= D E F I N E S ==============*/
#define REG_SPI_INTFCONFA_ADDR 0x00000000
#define BF_SOFTRESET_INFO 0x00000100
#define BF_SOFTRESET(val) (val & 0x00000001)
#define BF_SOFTRESET_GET(val) (val & 0x00000001)
#define BF_LSBFIRST_INFO 0x00000101
#define BF_LSBFIRST(val) ((val & 0x00000001) << 0x00000001)
#define BF_LSBFIRST_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_ADDRINC_INFO 0x00000102
#define BF_ADDRINC(val) ((val & 0x00000001) << 0x00000002)
#define BF_ADDRINC_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_SDOACTIVE_INFO 0x00000103
#define BF_SDOACTIVE(val) ((val & 0x00000001) << 0x00000003)
#define BF_SDOACTIVE_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_SDOACTIVE_M_INFO 0x00000104
#define BF_SDOACTIVE_M(val) ((val & 0x00000001) << 0x00000004)
#define BF_SDOACTIVE_M_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_ADDRINC_M_INFO 0x00000105
#define BF_ADDRINC_M(val) ((val & 0x00000001) << 0x00000005)
#define BF_ADDRINC_M_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_LSBFIRST_M_INFO 0x00000106
#define BF_LSBFIRST_M(val) ((val & 0x00000001) << 0x00000006)
#define BF_LSBFIRST_M_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_SOFTRESET_M_INFO 0x00000107
#define BF_SOFTRESET_M(val) ((val & 0x00000001) << 0x00000007)
#define BF_SOFTRESET_M_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_SPI_INTFCONFB_ADDR 0x00000001
#define BF_CSBSTALL_INFO 0x00000106
#define BF_CSBSTALL(val) ((val & 0x00000001) << 0x00000006)
#define BF_CSBSTALL_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_SINGLEINS_INFO 0x00000107
#define BF_SINGLEINS(val) ((val & 0x00000001) << 0x00000007)
#define BF_SINGLEINS_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_PAGEINDX_DAC_MAINDP_DAC_ADDR 0x0000001B
#define BF_DACPAGE_MSK_INFO 0x00000400
#define BF_DACPAGE_MSK(val) (val & 0x0000000F)
#define BF_DACPAGE_MSK_GET(val) (val & 0x0000000F)

#define REG_PAGEINDX_DAC_CHAN_ADDR 0x0000001C
#define BF_DACCHAN_MSK_INFO 0x00000800
#define BF_DACCHAN_MSK(val) (val & 0x000000FF)
#define BF_DACCHAN_MSK_GET(val) (val & 0x000000FF)

#define REG_PAGEINDX_DAC_JRX_ADDR 0x0000001D
#define BF_JRX_LINK_MSK_INFO 0x00000200
#define BF_JRX_LINK_MSK(val) (val & 0x00000003)
#define BF_JRX_LINK_MSK_GET(val) (val & 0x00000003)
#define BF_MODS_MSK_INFO 0x00000202
#define BF_MODS_MSK(val) ((val & 0x00000003) << 0x00000002)
#define BF_MODS_MSK_GET(val) ((val >> 0x00000002) & 0x00000003)

#define REG_IRQ_ENABLE_0_ADDR 0x00000020
#define BF_EN_PRBS_I_IRQ_INFO 0x00000100
#define BF_EN_PRBS_I_IRQ(val) (val & 0x00000001)
#define BF_EN_PRBS_I_IRQ_GET(val) (val & 0x00000001)
#define BF_EN_PRBS_Q_IRQ_INFO 0x00000101
#define BF_EN_PRBS_Q_IRQ(val) ((val & 0x00000001) << 0x00000001)
#define BF_EN_PRBS_Q_IRQ_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_EN_SYSREF_IRQ_INFO 0x00000102
#define BF_EN_SYSREF_IRQ(val) ((val & 0x00000001) << 0x00000002)
#define BF_EN_SYSREF_IRQ_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_EN_BIST_DONE_IRQ_INFO 0x00000103
#define BF_EN_BIST_DONE_IRQ(val) ((val & 0x00000001) << 0x00000003)
#define BF_EN_BIST_DONE_IRQ_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_EN_CAPTURE_DONE_INFO 0x00000104
#define BF_EN_CAPTURE_DONE(val) ((val & 0x00000001) << 0x00000004)
#define BF_EN_CAPTURE_DONE_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_EN_LANE_FIFO_INFO 0x00000105
#define BF_EN_LANE_FIFO(val) ((val & 0x00000001) << 0x00000005)
#define BF_EN_LANE_FIFO_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_EN_DATA_READY_INFO 0x00000106
#define BF_EN_DATA_READY(val) ((val & 0x00000001) << 0x00000006)
#define BF_EN_DATA_READY_GET(val) ((val >> 0x00000006) & 0x00000001)

#define REG_IRQ_ENABLE_1_ADDR 0x00000021
#define BF_EN_DAC0_MAIN_DP_BIST_DONE_IRQ_INFO 0x00000100
#define BF_EN_DAC0_MAIN_DP_BIST_DONE_IRQ(val) (val & 0x00000001)
#define BF_EN_DAC0_MAIN_DP_BIST_DONE_IRQ_GET(val) (val & 0x00000001)
#define BF_EN_DAC0_CAL_DONE_IRQ_INFO 0x00000101
#define BF_EN_DAC0_CAL_DONE_IRQ(val) ((val & 0x00000001) << 0x00000001)
#define BF_EN_DAC0_CAL_DONE_IRQ_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_EN_PAERR_0_INFO 0x00000103
#define BF_EN_PAERR_0(val) ((val & 0x00000001) << 0x00000003)
#define BF_EN_PAERR_0_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_EN_DAC1_MAIN_DP_BIST_DONE_IRQ_INFO 0x00000104
#define BF_EN_DAC1_MAIN_DP_BIST_DONE_IRQ(val) ((val & 0x00000001) << 0x00000004)
#define BF_EN_DAC1_MAIN_DP_BIST_DONE_IRQ_GET(val) \
	((val >> 0x00000004) & 0x00000001)
#define BF_EN_DAC1_CAL_DONE_IRQ_INFO 0x00000105
#define BF_EN_DAC1_CAL_DONE_IRQ(val) ((val & 0x00000001) << 0x00000005)
#define BF_EN_DAC1_CAL_DONE_IRQ_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_EN_PAERR_1_INFO 0x00000107
#define BF_EN_PAERR_1(val) ((val & 0x00000001) << 0x00000007)
#define BF_EN_PAERR_1_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_IRQ_ENABLE_2_ADDR 0x00000022
#define BF_EN_DAC2_MAIN_DP_BIST_DONE_IRQ_INFO 0x00000100
#define BF_EN_DAC2_MAIN_DP_BIST_DONE_IRQ(val) (val & 0x00000001)
#define BF_EN_DAC2_MAIN_DP_BIST_DONE_IRQ_GET(val) (val & 0x00000001)
#define BF_EN_DAC2_CAL_DONE_IRQ_INFO 0x00000101
#define BF_EN_DAC2_CAL_DONE_IRQ(val) ((val & 0x00000001) << 0x00000001)
#define BF_EN_DAC2_CAL_DONE_IRQ_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_EN_PAERR_2_INFO 0x00000103
#define BF_EN_PAERR_2(val) ((val & 0x00000001) << 0x00000003)
#define BF_EN_PAERR_2_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_EN_DAC3_MAIN_DP_BIST_DONE_IRQ_INFO 0x00000104
#define BF_EN_DAC3_MAIN_DP_BIST_DONE_IRQ(val) ((val & 0x00000001) << 0x00000004)
#define BF_EN_DAC3_MAIN_DP_BIST_DONE_IRQ_GET(val) \
	((val >> 0x00000004) & 0x00000001)
#define BF_EN_DAC3_CAL_DONE_IRQ_INFO 0x00000105
#define BF_EN_DAC3_CAL_DONE_IRQ(val) ((val & 0x00000001) << 0x00000005)
#define BF_EN_DAC3_CAL_DONE_IRQ_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_EN_PAERR_3_INFO 0x00000107
#define BF_EN_PAERR_3(val) ((val & 0x00000001) << 0x00000007)
#define BF_EN_PAERR_3_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_IRQ_ENABLE_3_ADDR 0x00000023
#define BF_EN_PLL_LOCK_FAST_IRQ_INFO 0x00000100
#define BF_EN_PLL_LOCK_FAST_IRQ(val) (val & 0x00000001)
#define BF_EN_PLL_LOCK_FAST_IRQ_GET(val) (val & 0x00000001)
#define BF_EN_PLL_LOCK_SLOW_IRQ_INFO 0x00000101
#define BF_EN_PLL_LOCK_SLOW_IRQ(val) ((val & 0x00000001) << 0x00000001)
#define BF_EN_PLL_LOCK_SLOW_IRQ_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_EN_PLL_LOST_FAST_IRQ_INFO 0x00000102
#define BF_EN_PLL_LOST_FAST_IRQ(val) ((val & 0x00000001) << 0x00000002)
#define BF_EN_PLL_LOST_FAST_IRQ_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_EN_PLL_LOST_SLOW_IRQ_INFO 0x00000103
#define BF_EN_PLL_LOST_SLOW_IRQ(val) ((val & 0x00000001) << 0x00000003)
#define BF_EN_PLL_LOST_SLOW_IRQ_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_EN_DLL_LOCK01_INFO 0x00000104
#define BF_EN_DLL_LOCK01(val) ((val & 0x00000001) << 0x00000004)
#define BF_EN_DLL_LOCK01_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_EN_DLL_LOST01_INFO 0x00000105
#define BF_EN_DLL_LOST01(val) ((val & 0x00000001) << 0x00000005)
#define BF_EN_DLL_LOST01_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_EN_DLL_LOCK23_INFO 0x00000106
#define BF_EN_DLL_LOCK23(val) ((val & 0x00000001) << 0x00000006)
#define BF_EN_DLL_LOCK23_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_EN_DLL_LOST23_INFO 0x00000107
#define BF_EN_DLL_LOST23(val) ((val & 0x00000001) << 0x00000007)
#define BF_EN_DLL_LOST23_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_IRQ_ENABLE_4_ADDR 0x00000024
#define BF_EN_DP0_DLL_VTH_FAIL_INFO 0x00000100
#define BF_EN_DP0_DLL_VTH_FAIL(val) (val & 0x00000001)
#define BF_EN_DP0_DLL_VTH_FAIL_GET(val) (val & 0x00000001)
#define BF_EN_DP1_DLL_VTH_FAIL_INFO 0x00000101
#define BF_EN_DP1_DLL_VTH_FAIL(val) ((val & 0x00000001) << 0x00000001)
#define BF_EN_DP1_DLL_VTH_FAIL_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_EN_DP2_DLL_VTH_FAIL_INFO 0x00000102
#define BF_EN_DP2_DLL_VTH_FAIL(val) ((val & 0x00000001) << 0x00000002)
#define BF_EN_DP2_DLL_VTH_FAIL_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_EN_DP3_DLL_VTH_FAIL_INFO 0x00000103
#define BF_EN_DP3_DLL_VTH_FAIL(val) ((val & 0x00000001) << 0x00000003)
#define BF_EN_DP3_DLL_VTH_FAIL_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_EN_DP0_DLL_VTH_PASS_INFO 0x00000104
#define BF_EN_DP0_DLL_VTH_PASS(val) ((val & 0x00000001) << 0x00000004)
#define BF_EN_DP0_DLL_VTH_PASS_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_EN_DP1_DLL_VTH_PASS_INFO 0x00000105
#define BF_EN_DP1_DLL_VTH_PASS(val) ((val & 0x00000001) << 0x00000005)
#define BF_EN_DP1_DLL_VTH_PASS_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_EN_DP2_DLL_VTH_PASS_INFO 0x00000106
#define BF_EN_DP2_DLL_VTH_PASS(val) ((val & 0x00000001) << 0x00000006)
#define BF_EN_DP2_DLL_VTH_PASS_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_EN_DP3_DLL_VTH_PASS_INFO 0x00000107
#define BF_EN_DP3_DLL_VTH_PASS(val) ((val & 0x00000001) << 0x00000007)
#define BF_EN_DP3_DLL_VTH_PASS_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_IRQ_ENABLE_5_ADDR 0x00000025
#define BF_EN_SRER_0_INFO 0x00000100
#define BF_EN_SRER_0(val) (val & 0x00000001)
#define BF_EN_SRER_0_GET(val) (val & 0x00000001)
#define BF_EN_SRER_1_INFO 0x00000101
#define BF_EN_SRER_1(val) ((val & 0x00000001) << 0x00000001)
#define BF_EN_SRER_1_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_EN_SRER_2_INFO 0x00000102
#define BF_EN_SRER_2(val) ((val & 0x00000001) << 0x00000002)
#define BF_EN_SRER_2_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_EN_SRER_3_INFO 0x00000103
#define BF_EN_SRER_3(val) ((val & 0x00000001) << 0x00000003)
#define BF_EN_SRER_3_GET(val) ((val >> 0x00000003) & 0x00000001)

#define REG_IRQ_STATUS0_ADDR 0x00000026
#define BF_IRQ_PRBSI_INFO 0x00000100
#define BF_IRQ_PRBSI(val) (val & 0x00000001)
#define BF_IRQ_PRBSI_GET(val) (val & 0x00000001)
#define BF_IRQ_PRBSQ_INFO 0x00000101
#define BF_IRQ_PRBSQ(val) ((val & 0x00000001) << 0x00000001)
#define BF_IRQ_PRBSQ_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_IRQ_SYSREF_JITTER_INFO 0x00000102
#define BF_IRQ_SYSREF_JITTER(val) ((val & 0x00000001) << 0x00000002)
#define BF_IRQ_SYSREF_JITTER_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_IRQ_BIST_DONE_INFO 0x00000103
#define BF_IRQ_BIST_DONE(val) ((val & 0x00000001) << 0x00000003)
#define BF_IRQ_BIST_DONE_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_IRQ_CAPTURE_DONE_INFO 0x00000104
#define BF_IRQ_CAPTURE_DONE(val) ((val & 0x00000001) << 0x00000004)
#define BF_IRQ_CAPTURE_DONE_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_IRQ_LANE_FIFO_INFO 0x00000105
#define BF_IRQ_LANE_FIFO(val) ((val & 0x00000001) << 0x00000005)
#define BF_IRQ_LANE_FIFO_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_IRQ_DATA_READY_INFO 0x00000106
#define BF_IRQ_DATA_READY(val) ((val & 0x00000001) << 0x00000006)
#define BF_IRQ_DATA_READY_GET(val) ((val >> 0x00000006) & 0x00000001)

#define REG_IRQ_STATUS1_ADDR 0x00000027
#define BF_IRQ_DAC0_MAIN_DP_BIST_DONE_INFO 0x00000100
#define BF_IRQ_DAC0_MAIN_DP_BIST_DONE(val) (val & 0x00000001)
#define BF_IRQ_DAC0_MAIN_DP_BIST_DONE_GET(val) (val & 0x00000001)
#define BF_IRQ_DAC0_CAL_DONE_INFO 0x00000101
#define BF_IRQ_DAC0_CAL_DONE(val) ((val & 0x00000001) << 0x00000001)
#define BF_IRQ_DAC0_CAL_DONE_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_IRQ_PAERR0_INFO 0x00000103
#define BF_IRQ_PAERR0(val) ((val & 0x00000001) << 0x00000003)
#define BF_IRQ_PAERR0_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_IRQ_DAC1_MAIN_DP_BIST_DONE_INFO 0x00000104
#define BF_IRQ_DAC1_MAIN_DP_BIST_DONE(val) ((val & 0x00000001) << 0x00000004)
#define BF_IRQ_DAC1_MAIN_DP_BIST_DONE_GET(val) \
	((val >> 0x00000004) & 0x00000001)
#define BF_IRQ_DAC1_CAL_DONE_INFO 0x00000105
#define BF_IRQ_DAC1_CAL_DONE(val) ((val & 0x00000001) << 0x00000005)
#define BF_IRQ_DAC1_CAL_DONE_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_IRQ_PAERR1_INFO 0x00000107
#define BF_IRQ_PAERR1(val) ((val & 0x00000001) << 0x00000007)
#define BF_IRQ_PAERR1_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_IRQ_STATUS2_ADDR 0x00000028
#define BF_IRQ_DAC2_MAIN_DP_BIST_DONE_INFO 0x00000100
#define BF_IRQ_DAC2_MAIN_DP_BIST_DONE(val) (val & 0x00000001)
#define BF_IRQ_DAC2_MAIN_DP_BIST_DONE_GET(val) (val & 0x00000001)
#define BF_IRQ_DAC2_CAL_DONE_INFO 0x00000101
#define BF_IRQ_DAC2_CAL_DONE(val) ((val & 0x00000001) << 0x00000001)
#define BF_IRQ_DAC2_CAL_DONE_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_IRQ_PAERR2_INFO 0x00000103
#define BF_IRQ_PAERR2(val) ((val & 0x00000001) << 0x00000003)
#define BF_IRQ_PAERR2_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_IRQ_DAC3_MAIN_DP_BIST_DONE_INFO 0x00000104
#define BF_IRQ_DAC3_MAIN_DP_BIST_DONE(val) ((val & 0x00000001) << 0x00000004)
#define BF_IRQ_DAC3_MAIN_DP_BIST_DONE_GET(val) \
	((val >> 0x00000004) & 0x00000001)
#define BF_IRQ_DAC3_CAL_DONE_INFO 0x00000105
#define BF_IRQ_DAC3_CAL_DONE(val) ((val & 0x00000001) << 0x00000005)
#define BF_IRQ_DAC3_CAL_DONE_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_IRQ_PAERR3_INFO 0x00000107
#define BF_IRQ_PAERR3(val) ((val & 0x00000001) << 0x00000007)
#define BF_IRQ_PAERR3_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_IRQ_STATUS3_ADDR 0x00000029
#define BF_IRQ_PLL_LOCK_FAST_INFO 0x00000100
#define BF_IRQ_PLL_LOCK_FAST(val) (val & 0x00000001)
#define BF_IRQ_PLL_LOCK_FAST_GET(val) (val & 0x00000001)
#define BF_IRQ_PLL_LOCK_SLOW_INFO 0x00000101
#define BF_IRQ_PLL_LOCK_SLOW(val) ((val & 0x00000001) << 0x00000001)
#define BF_IRQ_PLL_LOCK_SLOW_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_IRQ_PLL_LOST_FAST_INFO 0x00000102
#define BF_IRQ_PLL_LOST_FAST(val) ((val & 0x00000001) << 0x00000002)
#define BF_IRQ_PLL_LOST_FAST_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_IRQ_PLL_LOST_SLOW_INFO 0x00000103
#define BF_IRQ_PLL_LOST_SLOW(val) ((val & 0x00000001) << 0x00000003)
#define BF_IRQ_PLL_LOST_SLOW_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_IRQ_DLL_LOCK01_INFO 0x00000104
#define BF_IRQ_DLL_LOCK01(val) ((val & 0x00000001) << 0x00000004)
#define BF_IRQ_DLL_LOCK01_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_IRQ_DLL_LOST01_INFO 0x00000105
#define BF_IRQ_DLL_LOST01(val) ((val & 0x00000001) << 0x00000005)
#define BF_IRQ_DLL_LOST01_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_IRQ_DLL_LOCK23_INFO 0x00000106
#define BF_IRQ_DLL_LOCK23(val) ((val & 0x00000001) << 0x00000006)
#define BF_IRQ_DLL_LOCK23_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_IRQ_DLL_LOST23_INFO 0x00000107
#define BF_IRQ_DLL_LOST23(val) ((val & 0x00000001) << 0x00000007)
#define BF_IRQ_DLL_LOST23_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_IRQ_STATUS4_ADDR 0x0000002A
#define BF_IRQ_DP0_DLL_VTH_FAIL_INFO 0x00000100
#define BF_IRQ_DP0_DLL_VTH_FAIL(val) (val & 0x00000001)
#define BF_IRQ_DP0_DLL_VTH_FAIL_GET(val) (val & 0x00000001)
#define BF_IRQ_DP1_DLL_VTH_FAIL_INFO 0x00000101
#define BF_IRQ_DP1_DLL_VTH_FAIL(val) ((val & 0x00000001) << 0x00000001)
#define BF_IRQ_DP1_DLL_VTH_FAIL_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_IRQ_DP2_DLL_VTH_FAIL_INFO 0x00000102
#define BF_IRQ_DP2_DLL_VTH_FAIL(val) ((val & 0x00000001) << 0x00000002)
#define BF_IRQ_DP2_DLL_VTH_FAIL_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_IRQ_DP3_DLL_VTH_FAIL_INFO 0x00000103
#define BF_IRQ_DP3_DLL_VTH_FAIL(val) ((val & 0x00000001) << 0x00000003)
#define BF_IRQ_DP3_DLL_VTH_FAIL_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_IRQ_DP0_DLL_VTH_PASS_INFO 0x00000104
#define BF_IRQ_DP0_DLL_VTH_PASS(val) ((val & 0x00000001) << 0x00000004)
#define BF_IRQ_DP0_DLL_VTH_PASS_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_IRQ_DP1_DLL_VTH_PASS_INFO 0x00000105
#define BF_IRQ_DP1_DLL_VTH_PASS(val) ((val & 0x00000001) << 0x00000005)
#define BF_IRQ_DP1_DLL_VTH_PASS_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_IRQ_DP2_DLL_VTH_PASS_INFO 0x00000106
#define BF_IRQ_DP2_DLL_VTH_PASS(val) ((val & 0x00000001) << 0x00000006)
#define BF_IRQ_DP2_DLL_VTH_PASS_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_IRQ_DP3_DLL_VTH_PASS_INFO 0x00000107
#define BF_IRQ_DP3_DLL_VTH_PASS(val) ((val & 0x00000001) << 0x00000007)
#define BF_IRQ_DP3_DLL_VTH_PASS_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_IRQ_STATUS5_ADDR 0x0000002B
#define BF_IRQ_SRERR0_INFO 0x00000100
#define BF_IRQ_SRERR0(val) (val & 0x00000001)
#define BF_IRQ_SRERR0_GET(val) (val & 0x00000001)
#define BF_IRQ_SRERR1_INFO 0x00000101
#define BF_IRQ_SRERR1(val) ((val & 0x00000001) << 0x00000001)
#define BF_IRQ_SRERR1_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_IRQ_SRERR2_INFO 0x00000102
#define BF_IRQ_SRERR2(val) ((val & 0x00000001) << 0x00000002)
#define BF_IRQ_SRERR2_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_IRQ_SRERR3_INFO 0x00000103
#define BF_IRQ_SRERR3(val) ((val & 0x00000001) << 0x00000003)
#define BF_IRQ_SRERR3_GET(val) ((val >> 0x00000003) & 0x00000001)

#define REG_IRQ_OUTPUT_MUX_0_ADDR 0x0000002C
#define BF_MUX_PRBSI_INFO 0x00000100
#define BF_MUX_PRBSI(val) (val & 0x00000001)
#define BF_MUX_PRBSI_GET(val) (val & 0x00000001)
#define BF_MUX_PRBSQ_INFO 0x00000101
#define BF_MUX_PRBSQ(val) ((val & 0x00000001) << 0x00000001)
#define BF_MUX_PRBSQ_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_MUX_SYSREF_JITTER_INFO 0x00000102
#define BF_MUX_SYSREF_JITTER(val) ((val & 0x00000001) << 0x00000002)
#define BF_MUX_SYSREF_JITTER_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_MUX_BIST_DONE_INFO 0x00000103
#define BF_MUX_BIST_DONE(val) ((val & 0x00000001) << 0x00000003)
#define BF_MUX_BIST_DONE_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_MUX_CAPTURE_DONE_INFO 0x00000104
#define BF_MUX_CAPTURE_DONE(val) ((val & 0x00000001) << 0x00000004)
#define BF_MUX_CAPTURE_DONE_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_MUX_LANE_FIFO_INFO 0x00000105
#define BF_MUX_LANE_FIFO(val) ((val & 0x00000001) << 0x00000005)
#define BF_MUX_LANE_FIFO_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_MUX_DATA_READY_INFO 0x00000106
#define BF_MUX_DATA_READY(val) ((val & 0x00000001) << 0x00000006)
#define BF_MUX_DATA_READY_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_MUX_JESD_IRQ_INFO 0x00000107
#define BF_MUX_JESD_IRQ(val) ((val & 0x00000001) << 0x00000007)
#define BF_MUX_JESD_IRQ_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_IRQ_OUTPUT_MUX_1_ADDR 0x0000002D
#define BF_MUX_DAC0_MAIN_DP_BIST_DONE_INFO 0x00000100
#define BF_MUX_DAC0_MAIN_DP_BIST_DONE(val) (val & 0x00000001)
#define BF_MUX_DAC0_MAIN_DP_BIST_DONE_GET(val) (val & 0x00000001)
#define BF_MUX_DAC0_CAL_DONE_INFO 0x00000101
#define BF_MUX_DAC0_CAL_DONE(val) ((val & 0x00000001) << 0x00000001)
#define BF_MUX_DAC0_CAL_DONE_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_MUX_PAERR0_INFO 0x00000103
#define BF_MUX_PAERR0(val) ((val & 0x00000001) << 0x00000003)
#define BF_MUX_PAERR0_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_MUX_DAC1_MAIN_DP_BIST_DONE_INFO 0x00000104
#define BF_MUX_DAC1_MAIN_DP_BIST_DONE(val) ((val & 0x00000001) << 0x00000004)
#define BF_MUX_DAC1_MAIN_DP_BIST_DONE_GET(val) \
	((val >> 0x00000004) & 0x00000001)
#define BF_MUX_DAC1_CAL_DONE_INFO 0x00000105
#define BF_MUX_DAC1_CAL_DONE(val) ((val & 0x00000001) << 0x00000005)
#define BF_MUX_DAC1_CAL_DONE_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_MUX_PAERR1_INFO 0x00000107
#define BF_MUX_PAERR1(val) ((val & 0x00000001) << 0x00000007)
#define BF_MUX_PAERR1_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_IRQ_OUTPUT_MUX_2_ADDR 0x0000002E
#define BF_MUX_DAC2_MAIN_DP_BIST_DONE_INFO 0x00000100
#define BF_MUX_DAC2_MAIN_DP_BIST_DONE(val) (val & 0x00000001)
#define BF_MUX_DAC2_MAIN_DP_BIST_DONE_GET(val) (val & 0x00000001)
#define BF_MUX_DAC2_CAL_DONE_INFO 0x00000101
#define BF_MUX_DAC2_CAL_DONE(val) ((val & 0x00000001) << 0x00000001)
#define BF_MUX_DAC2_CAL_DONE_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_MUX_PAERR2_INFO 0x00000103
#define BF_MUX_PAERR2(val) ((val & 0x00000001) << 0x00000003)
#define BF_MUX_PAERR2_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_MUX_DAC3_MAIN_DP_BIST_DONE_INFO 0x00000104
#define BF_MUX_DAC3_MAIN_DP_BIST_DONE(val) ((val & 0x00000001) << 0x00000004)
#define BF_MUX_DAC3_MAIN_DP_BIST_DONE_GET(val) \
	((val >> 0x00000004) & 0x00000001)
#define BF_MUX_DAC3_CAL_DONE_INFO 0x00000105
#define BF_MUX_DAC3_CAL_DONE(val) ((val & 0x00000001) << 0x00000005)
#define BF_MUX_DAC3_CAL_DONE_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_MUX_PAERR3_INFO 0x00000107
#define BF_MUX_PAERR3(val) ((val & 0x00000001) << 0x00000007)
#define BF_MUX_PAERR3_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_IRQ_OUTPUT_MUX_3_ADDR 0x0000002F
#define BF_MUX_PLL_LOCK_FAST_INFO 0x00000100
#define BF_MUX_PLL_LOCK_FAST(val) (val & 0x00000001)
#define BF_MUX_PLL_LOCK_FAST_GET(val) (val & 0x00000001)
#define BF_MUX_PLL_LOCK_SLOW_INFO 0x00000101
#define BF_MUX_PLL_LOCK_SLOW(val) ((val & 0x00000001) << 0x00000001)
#define BF_MUX_PLL_LOCK_SLOW_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_MUX_PLL_LOST_FAST_INFO 0x00000102
#define BF_MUX_PLL_LOST_FAST(val) ((val & 0x00000001) << 0x00000002)
#define BF_MUX_PLL_LOST_FAST_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_MUX_PLL_LOST_SLOW_INFO 0x00000103
#define BF_MUX_PLL_LOST_SLOW(val) ((val & 0x00000001) << 0x00000003)
#define BF_MUX_PLL_LOST_SLOW_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_MUX_DLL_LOCK01_INFO 0x00000104
#define BF_MUX_DLL_LOCK01(val) ((val & 0x00000001) << 0x00000004)
#define BF_MUX_DLL_LOCK01_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_MUX_DLL_LOST01_INFO 0x00000105
#define BF_MUX_DLL_LOST01(val) ((val & 0x00000001) << 0x00000005)
#define BF_MUX_DLL_LOST01_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_MUX_DLL_LOCK23_INFO 0x00000106
#define BF_MUX_DLL_LOCK23(val) ((val & 0x00000001) << 0x00000006)
#define BF_MUX_DLL_LOCK23_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_MUX_DLL_LOST23_INFO 0x00000107
#define BF_MUX_DLL_LOST23(val) ((val & 0x00000001) << 0x00000007)
#define BF_MUX_DLL_LOST23_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_IRQ_OUTPUT_MUX_4_ADDR 0x00000030
#define BF_MUX_DLL_OUT_OF_RANGE_INFO 0x00000400
#define BF_MUX_DLL_OUT_OF_RANGE(val) (val & 0x0000000F)
#define BF_MUX_DLL_OUT_OF_RANGE_GET(val) (val & 0x0000000F)
#define BF_MUX_DLL_IN_RANGE_INFO 0x00000404
#define BF_MUX_DLL_IN_RANGE(val) ((val & 0x0000000F) << 0x00000004)
#define BF_MUX_DLL_IN_RANGE_GET(val) ((val >> 0x00000004) & 0x0000000F)

#define REG_IRQ_OUTPUT_MUX_5_ADDR 0x00000031
#define BF_MUX_SRERR0_INFO 0x00000100
#define BF_MUX_SRERR0(val) (val & 0x00000001)
#define BF_MUX_SRERR0_GET(val) (val & 0x00000001)
#define BF_MUX_SRERR1_INFO 0x00000101
#define BF_MUX_SRERR1(val) ((val & 0x00000001) << 0x00000001)
#define BF_MUX_SRERR1_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_MUX_SRERR2_INFO 0x00000102
#define BF_MUX_SRERR2(val) ((val & 0x00000001) << 0x00000002)
#define BF_MUX_SRERR2_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_MUX_SRERR3_INFO 0x00000103
#define BF_MUX_SRERR3(val) ((val & 0x00000001) << 0x00000003)
#define BF_MUX_SRERR3_GET(val) ((val >> 0x00000003) & 0x00000001)

#define REG_IRQ_STATUS_ALL_ADDR 0x00000032
#define BF_IRQ_STATUS_ALL_INFO 0x00000100
#define BF_IRQ_STATUS_ALL(val) (val & 0x00000001)
#define BF_IRQ_STATUS_ALL_GET(val) (val & 0x00000001)

#define REG_GPIO_STATUS0_ADDR 0x00000033
#define BF_GPIO_DAC_NCO_FFH2_IN_INFO 0x00000101
#define BF_GPIO_DAC_NCO_FFH2_IN(val) ((val & 0x00000001) << 0x00000001)
#define BF_GPIO_DAC_NCO_FFH2_IN_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_GPIO_DAC_NCO_FFH3_IN_INFO 0x00000103
#define BF_GPIO_DAC_NCO_FFH3_IN(val) ((val & 0x00000001) << 0x00000003)
#define BF_GPIO_DAC_NCO_FFH3_IN_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_GPIO_DAC_NCO_FFH4_IN_INFO 0x00000105
#define BF_GPIO_DAC_NCO_FFH4_IN(val) ((val & 0x00000001) << 0x00000005)
#define BF_GPIO_DAC_NCO_FFH4_IN_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_GPIO_DAC_NCO_FFH5_IN_INFO 0x00000106
#define BF_GPIO_DAC_NCO_FFH5_IN(val) ((val & 0x00000001) << 0x00000006)
#define BF_GPIO_DAC_NCO_FFH5_IN_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_GPIO_TXEN1_IN_INFO 0x00000107
#define BF_GPIO_TXEN1_IN(val) ((val & 0x00000001) << 0x00000007)
#define BF_GPIO_TXEN1_IN_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_GPIO_STATUS1_ADDR 0x00000034
#define BF_GPIO_DAC_NCO_FFH6_INFO 0x00000100
#define BF_GPIO_DAC_NCO_FFH6(val) (val & 0x00000001)
#define BF_GPIO_DAC_NCO_FFH6_GET(val) (val & 0x00000001)
#define BF_GPIO_TXEN3_IN_INFO 0x00000101
#define BF_GPIO_TXEN3_IN(val) ((val & 0x00000001) << 0x00000001)
#define BF_GPIO_TXEN3_IN_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_GPIO_DAC_NCO_STROBE_IN_INFO 0x00000102
#define BF_GPIO_DAC_NCO_STROBE_IN(val) ((val & 0x00000001) << 0x00000002)
#define BF_GPIO_DAC_NCO_STROBE_IN_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_GPIO_DAC_NCO_FFH0_IN_INFO 0x00000103
#define BF_GPIO_DAC_NCO_FFH0_IN(val) ((val & 0x00000001) << 0x00000003)
#define BF_GPIO_DAC_NCO_FFH0_IN_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_GPIO_DAC_NCO_FFH1_IN_INFO 0x00000104
#define BF_GPIO_DAC_NCO_FFH1_IN(val) ((val & 0x00000001) << 0x00000004)
#define BF_GPIO_DAC_NCO_FFH1_IN_GET(val) ((val >> 0x00000004) & 0x00000001)

#define REG_GPIO_CFG0_ADDR 0x00000035
#define BF_GPIO0_CFG_INFO 0x00000400
#define BF_GPIO0_CFG(val) (val & 0x0000000F)
#define BF_GPIO0_CFG_GET(val) (val & 0x0000000F)
#define BF_GPIO1_CFG_INFO 0x00000404
#define BF_GPIO1_CFG(val) ((val & 0x0000000F) << 0x00000004)
#define BF_GPIO1_CFG_GET(val) ((val >> 0x00000004) & 0x0000000F)

#define REG_GPIO_CFG1_ADDR 0x00000036
#define BF_GPIO2_CFG_INFO 0x00000400
#define BF_GPIO2_CFG(val) (val & 0x0000000F)
#define BF_GPIO2_CFG_GET(val) (val & 0x0000000F)
#define BF_GPIO3_CFG_INFO 0x00000404
#define BF_GPIO3_CFG(val) ((val & 0x0000000F) << 0x00000004)
#define BF_GPIO3_CFG_GET(val) ((val >> 0x00000004) & 0x0000000F)

#define REG_GPIO_CFG2_ADDR 0x00000037
#define BF_GPIO4_CFG_INFO 0x00000400
#define BF_GPIO4_CFG(val) (val & 0x0000000F)
#define BF_GPIO4_CFG_GET(val) (val & 0x0000000F)
#define BF_GPIO5_CFG_INFO 0x00000404
#define BF_GPIO5_CFG(val) ((val & 0x0000000F) << 0x00000004)
#define BF_GPIO5_CFG_GET(val) ((val >> 0x00000004) & 0x0000000F)

#define REG_GPIO_CFG3_ADDR 0x00000038
#define BF_SYNC1_OUTBP_CFG_INFO 0x00000400
#define BF_SYNC1_OUTBP_CFG(val) (val & 0x0000000F)
#define BF_SYNC1_OUTBP_CFG_GET(val) (val & 0x0000000F)
#define BF_SYNC1_OUTBN_CFG_INFO 0x00000404
#define BF_SYNC1_OUTBN_CFG(val) ((val & 0x0000000F) << 0x00000004)
#define BF_SYNC1_OUTBN_CFG_GET(val) ((val >> 0x00000004) & 0x0000000F)

#define REG_DELAY_LINE_PD_ADDR 0x00000060
#define BF_DELAYLINE_POWERDOWN_INFO 0x00000100
#define BF_DELAYLINE_POWERDOWN(val) (val & 0x00000001)
#define BF_DELAYLINE_POWERDOWN_GET(val) (val & 0x00000001)
#define BF_DLL_DELAYLINE_DUTY_RESET1_INFO 0x00000104
#define BF_DLL_DELAYLINE_DUTY_RESET1(val) ((val & 0x00000001) << 0x00000004)
#define BF_DLL_DELAYLINE_DUTY_RESET1_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_DLL_DELAYLINE_DUTY_RESET2_INFO 0x00000105
#define BF_DLL_DELAYLINE_DUTY_RESET2(val) ((val & 0x00000001) << 0x00000005)
#define BF_DLL_DELAYLINE_DUTY_RESET2_GET(val) ((val >> 0x00000005) & 0x00000001)

#define REG_DLL_CTRL0_ADDR 0x00000061
#define BF_DLL_ENABLE_INFO 0x00000100
#define BF_DLL_ENABLE(val) (val & 0x00000001)
#define BF_DLL_ENABLE_GET(val) (val & 0x00000001)
#define BF_DLL_SEARCH_INFO 0x00000203
#define BF_DLL_SEARCH(val) ((val & 0x00000003) << 0x00000003)
#define BF_DLL_SEARCH_GET(val) ((val >> 0x00000003) & 0x00000003)
#define BF_DLL_SLOPE_INFO 0x00000105
#define BF_DLL_SLOPE(val) ((val & 0x00000001) << 0x00000005)
#define BF_DLL_SLOPE_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_DLL_FINE_MODE_INFO 0x00000206
#define BF_DLL_FINE_MODE(val) ((val & 0x00000003) << 0x00000006)
#define BF_DLL_FINE_MODE_GET(val) ((val >> 0x00000006) & 0x00000003)

#define REG_DLL_STATUS_ADDR 0x00000063
#define BF_DLL_LOCKED_INFO 0x00000100
#define BF_DLL_LOCKED(val) (val & 0x00000001)
#define BF_DLL_LOCKED_GET(val) (val & 0x00000001)
#define BF_DLL_LOST_INFO 0x00000101
#define BF_DLL_LOST(val) ((val & 0x00000001) << 0x00000001)
#define BF_DLL_LOST_GET(val) ((val >> 0x00000001) & 0x00000001)

#define REG_DELAY_LINE_CTRL1_ADDR 0x00000079
#define BF_DLL_DELAYLINE_PN_BIAS1_INFO 0x00000400
#define BF_DLL_DELAYLINE_PN_BIAS1(val) (val & 0x0000000F)
#define BF_DLL_DELAYLINE_PN_BIAS1_GET(val) (val & 0x0000000F)

#define REG_DELAY_LINE_CTRL2_ADDR 0x0000007A
#define BF_DLL_DELAYLINE_PN_BIAS2_INFO 0x00000400
#define BF_DLL_DELAYLINE_PN_BIAS2(val) (val & 0x0000000F)
#define BF_DLL_DELAYLINE_PN_BIAS2_GET(val) (val & 0x0000000F)

#define REG_DAC_POWERDOWN_ADDR 0x00000090
#define BF_DAC_PD0_INFO 0x00000100
#define BF_DAC_PD0(val) (val & 0x00000001)
#define BF_DAC_PD0_GET(val) (val & 0x00000001)
#define BF_DAC_PD1_INFO 0x00000101
#define BF_DAC_PD1(val) ((val & 0x00000001) << 0x00000001)
#define BF_DAC_PD1_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_DAC_PD2_INFO 0x00000102
#define BF_DAC_PD2(val) ((val & 0x00000001) << 0x00000002)
#define BF_DAC_PD2_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_DAC_PD3_INFO 0x00000103
#define BF_DAC_PD3(val) ((val & 0x00000001) << 0x00000003)
#define BF_DAC_PD3_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_DAC_PD0_FORCED_INFO 0x00000104
#define BF_DAC_PD0_FORCED(val) ((val & 0x00000001) << 0x00000004)
#define BF_DAC_PD0_FORCED_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_DAC_PD1_FORCED_INFO 0x00000105
#define BF_DAC_PD1_FORCED(val) ((val & 0x00000001) << 0x00000005)
#define BF_DAC_PD1_FORCED_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_DAC_PD2_FORCED_INFO 0x00000106
#define BF_DAC_PD2_FORCED(val) ((val & 0x00000001) << 0x00000006)
#define BF_DAC_PD2_FORCED_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_DAC_PD3_FORCED_INFO 0x00000107
#define BF_DAC_PD3_FORCED(val) ((val & 0x00000001) << 0x00000007)
#define BF_DAC_PD3_FORCED_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_ACLK_CTRL_ADDR 0x00000091
#define BF_ACLK_POWERDOWN_INFO 0x00000100
#define BF_ACLK_POWERDOWN(val) (val & 0x00000001)
#define BF_ACLK_POWERDOWN_GET(val) (val & 0x00000001)
#define BF_ACLK_RCVR_LP_MODE_INFO 0x00000101
#define BF_ACLK_RCVR_LP_MODE(val) ((val & 0x00000001) << 0x00000001)
#define BF_ACLK_RCVR_LP_MODE_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_PD_TXDIGCLK_INFO 0x00000103
#define BF_PD_TXDIGCLK(val) ((val & 0x00000001) << 0x00000003)
#define BF_PD_TXDIGCLK_GET(val) ((val >> 0x00000003) & 0x00000001)

#define REG_ACLK_CTRL2_ADDR 0x00000092
#define BF_ANACENTER_ACLK_DCC_ADJ_INFO 0x00000400
#define BF_ANACENTER_ACLK_DCC_ADJ(val) (val & 0x0000000F)
#define BF_ANACENTER_ACLK_DCC_ADJ_GET(val) (val & 0x0000000F)

#define REG_PLL_CLK_DIV_ADDR 0x00000093
#define BF_PLL_DIVIDEFACTOR_INFO 0x00000200
#define BF_PLL_DIVIDEFACTOR(val) (val & 0x00000003)
#define BF_PLL_DIVIDEFACTOR_GET(val) (val & 0x00000003)
#define BF_PLL_DIVIDEFACTOR_FORCED_INFO 0x00000202
#define BF_PLL_DIVIDEFACTOR_FORCED(val) ((val & 0x00000003) << 0x00000002)
#define BF_PLL_DIVIDEFACTOR_FORCED_GET(val) ((val >> 0x00000002) & 0x00000003)
#define BF_PLLDIV_PH_RESET_INFO 0x00000104
#define BF_PLLDIV_PH_RESET(val) ((val & 0x00000001) << 0x00000004)
#define BF_PLLDIV_PH_RESET_GET(val) ((val >> 0x00000004) & 0x00000001)

#define REG_PLL_BYPASS_ADDR 0x00000094
#define BF_PLL_BYPASS_INFO 0x00000100
#define BF_PLL_BYPASS(val) (val & 0x00000001)
#define BF_PLL_BYPASS_GET(val) (val & 0x00000001)
#define BF_EN_PDPLL_WHENBYPASS_INFO 0x00000104
#define BF_EN_PDPLL_WHENBYPASS(val) ((val & 0x00000001) << 0x00000004)
#define BF_EN_PDPLL_WHENBYPASS_GET(val) ((val >> 0x00000004) & 0x00000001)

#define REG_ACLK_DEBUG_ADDR 0x00000095
#define BF_PD_RFDIV_INFO 0x00000100
#define BF_PD_RFDIV(val) (val & 0x00000001)
#define BF_PD_RFDIV_GET(val) (val & 0x00000001)
#define BF_PD_REF_GEN_INFO 0x00000101
#define BF_PD_REF_GEN(val) ((val & 0x00000001) << 0x00000001)
#define BF_PD_REF_GEN_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_PD_BIAS_INFO 0x00000102
#define BF_PD_BIAS(val) ((val & 0x00000001) << 0x00000002)
#define BF_PD_BIAS_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_PD_BUFFER_INFO 0x00000103
#define BF_PD_BUFFER(val) ((val & 0x00000001) << 0x00000003)
#define BF_PD_BUFFER_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_PD_CLK0_INFO 0x00000104
#define BF_PD_CLK0(val) ((val & 0x00000001) << 0x00000004)
#define BF_PD_CLK0_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_PD_CLK1_INFO 0x00000105
#define BF_PD_CLK1(val) ((val & 0x00000001) << 0x00000005)
#define BF_PD_CLK1_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_DUTYCYCLE_PD_INFO 0x00000106
#define BF_DUTYCYCLE_PD(val) ((val & 0x00000001) << 0x00000006)
#define BF_DUTYCYCLE_PD_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_ACLK_PD_OVERRD_INFO 0x00000107
#define BF_ACLK_PD_OVERRD(val) ((val & 0x00000001) << 0x00000007)
#define BF_ACLK_PD_OVERRD_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_NVM_CTRL_ADDR 0x00000099
#define BF_PD_BGR_INFO 0x00000107
#define BF_PD_BGR(val) ((val & 0x00000001) << 0x00000007)
#define BF_PD_BGR_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_SOURCE_SEL3_ADDR 0x000000A0
#define BF_VMON_SELECT_NEW_INFO 0x00000400
#define BF_VMON_SELECT_NEW(val) (val & 0x0000000F)
#define BF_VMON_SELECT_NEW_GET(val) (val & 0x0000000F)
#define BF_TEST_TEMP_ADD_INFO 0x00000205
#define BF_TEST_TEMP_ADD(val) ((val & 0x00000003) << 0x00000005)
#define BF_TEST_TEMP_ADD_GET(val) ((val >> 0x00000005) & 0x00000003)
#define BF_TEST_TEMP_ENABLE_INFO 0x00000107
#define BF_TEST_TEMP_ENABLE(val) ((val & 0x00000001) << 0x00000007)
#define BF_TEST_TEMP_ENABLE_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_RUPOLY_TRIM_ADDR 0x000000A3
#define BF_TRM_RUPOLY_INFO 0x00000600
#define BF_TRM_RUPOLY(val) (val & 0x0000003F)
#define BF_TRM_RUPOLY_GET(val) (val & 0x0000003F)

#define REG_RUPOLYCAL_CTRL_ADDR 0x000000A4
#define BF_RUPOLYCAL_CODE_FSM_INFO 0x00000600
#define BF_RUPOLYCAL_CODE_FSM(val) (val & 0x0000003F)
#define BF_RUPOLYCAL_CODE_FSM_GET(val) (val & 0x0000003F)
#define BF_RUPOLYCAL_SEL_INFO 0x00000106
#define BF_RUPOLYCAL_SEL(val) ((val & 0x00000001) << 0x00000006)
#define BF_RUPOLYCAL_SEL_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_RUPOLYCAL_EN_INFO 0x00000107
#define BF_RUPOLYCAL_EN(val) ((val & 0x00000001) << 0x00000007)
#define BF_RUPOLYCAL_EN_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_RUPOLYCAL_STATUS_ADDR 0x000000A5
#define BF_RUPOLYCAL_FSM_STATE_INFO 0x00000400
#define BF_RUPOLYCAL_FSM_STATE(val) (val & 0x0000000F)
#define BF_RUPOLYCAL_FSM_STATE_GET(val) (val & 0x0000000F)
#define BF_RUPOLYCAL_FSM_DONE_INFO 0x00000104
#define BF_RUPOLYCAL_FSM_DONE(val) ((val & 0x00000001) << 0x00000004)
#define BF_RUPOLYCAL_FSM_DONE_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_RUPOLYCAL_FSM_CMP_INFO 0x00000105
#define BF_RUPOLYCAL_FSM_CMP(val) ((val & 0x00000001) << 0x00000005)
#define BF_RUPOLYCAL_FSM_CMP_GET(val) ((val >> 0x00000005) & 0x00000001)

#define REG_ANAROSC_CLKDIV_ADDR 0x000000A6
#define BF_ANA_ROSC_CLK_DIV_INFO 0x00000400
#define BF_ANA_ROSC_CLK_DIV(val) (val & 0x0000000F)
#define BF_ANA_ROSC_CLK_DIV_GET(val) (val & 0x0000000F)
#define BF_ANAROSC_CLK_FORCE_OFF_INFO 0x00000107
#define BF_ANAROSC_CLK_FORCE_OFF(val) ((val & 0x00000001) << 0x00000007)
#define BF_ANAROSC_CLK_FORCE_OFF_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_FORCED_FASTV_COMP_LOWL0_ADDR 0x00000F20
#define BF_D_FASTV_COMP_LOWL_FORCED_INFO 0x00000B00
#define BF_D_FASTV_COMP_LOWL_FORCED(val) (val & 0x000007FF)
#define BF_D_FASTV_COMP_LOWL_FORCED_GET(val) (val & 0x000007FF)

#define REG_FORCED_FASTV_COMP_LOWL1_ADDR 0x00000F21

#define REG_FORCED_FASTV_COMP_HIGHL0_ADDR 0x00000F22
#define BF_D_FASTV_COMP_HIGHL_FORCED_INFO 0x00000B00
#define BF_D_FASTV_COMP_HIGHL_FORCED(val) (val & 0x000007FF)
#define BF_D_FASTV_COMP_HIGHL_FORCED_GET(val) (val & 0x000007FF)

#define REG_FORCED_FASTV_COMP_HIGHL1_ADDR 0x00000F23

#define REG_FORCED_SLOWV_COMP_LOWL0_ADDR 0x00000F24
#define BF_D_SLOWV_COMP_LOWL_FORCED_INFO 0x00000B00
#define BF_D_SLOWV_COMP_LOWL_FORCED(val) (val & 0x000007FF)
#define BF_D_SLOWV_COMP_LOWL_FORCED_GET(val) (val & 0x000007FF)

#define REG_FORCED_SLOWV_COMP_LOWL1_ADDR 0x00000F25

#define REG_FORCED_SLOWV_COMP_HIGHL0_ADDR 0x00000F26
#define BF_D_SLOWV_COMP_HIGHL_FORCED_INFO 0x00000B00
#define BF_D_SLOWV_COMP_HIGHL_FORCED(val) (val & 0x000007FF)
#define BF_D_SLOWV_COMP_HIGHL_FORCED_GET(val) (val & 0x000007FF)

#define REG_FORCED_SLOWV_COMP_HIGHL1_ADDR 0x00000F27

#define REG_SINT_CDR_CAL_STATUS_ADDR 0x00000F2C
#define BF_D_SINT_CDR_CAL_IN_PROGRESS_INFO 0x00000100
#define BF_D_SINT_CDR_CAL_IN_PROGRESS(val) (val & 0x00000001)
#define BF_D_SINT_CDR_CAL_IN_PROGRESS_GET(val) (val & 0x00000001)
#define BF_D_SINT_CDR_CAL_STATUS_INFO 0x00000101
#define BF_D_SINT_CDR_CAL_STATUS(val) ((val & 0x00000001) << 0x00000001)
#define BF_D_SINT_CDR_CAL_STATUS_GET(val) ((val >> 0x00000001) & 0x00000001)

#define REG_SINT_PD_CTRL_ADDR 0x00000F2E
#define BF_D_IMPALA_SINT_PD_INFO 0x00000100
#define BF_D_IMPALA_SINT_PD(val) (val & 0x00000001)
#define BF_D_IMPALA_SINT_PD_GET(val) (val & 0x00000001)
#define BF_D_SINT_PK_COMP_PD_INFO 0x00000101
#define BF_D_SINT_PK_COMP_PD(val) ((val & 0x00000001) << 0x00000001)
#define BF_D_SINT_PK_COMP_PD_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_D_SINT_PK_PD_INFO 0x00000102
#define BF_D_SINT_PK_PD(val) ((val & 0x00000001) << 0x00000002)
#define BF_D_SINT_PK_PD_GET(val) ((val >> 0x00000002) & 0x00000001)

#define REG_SINT_CAL_CTRL_ADDR 0x00000F32
#define BF_D_SINT_CDR_FORCE_CAL_INFO 0x00000100
#define BF_D_SINT_CDR_FORCE_CAL(val) (val & 0x00000001)
#define BF_D_SINT_CDR_FORCE_CAL_GET(val) (val & 0x00000001)
#define BF_D_SINT_CDR_INIT_CAL_INFO 0x00000101
#define BF_D_SINT_CDR_INIT_CAL(val) ((val & 0x00000001) << 0x00000001)
#define BF_D_SINT_CDR_INIT_CAL_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_D_SINT_CDR_AUTO_CAL_INFO 0x00000102
#define BF_D_SINT_CDR_AUTO_CAL(val) ((val & 0x00000001) << 0x00000002)
#define BF_D_SINT_CDR_AUTO_CAL_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_D_SINT_SS_I2C_CTRL_SEL_INFO 0x00000104
#define BF_D_SINT_SS_I2C_CTRL_SEL(val) ((val & 0x00000001) << 0x00000004)
#define BF_D_SINT_SS_I2C_CTRL_SEL_GET(val) ((val >> 0x00000004) & 0x00000001)

#define REG_SINT_REF_CLK_CTRL_ADDR 0x00000F33
#define BF_D_SINT_REF_CLK_RDY_INFO 0x00000101
#define BF_D_SINT_REF_CLK_RDY(val) ((val & 0x00000001) << 0x00000001)
#define BF_D_SINT_REF_CLK_RDY_GET(val) ((val >> 0x00000001) & 0x00000001)

#define REG_SINT_RESETN_ADDR 0x00000F34
#define BF_D_SINT_RESETN_INFO 0x00000100
#define BF_D_SINT_RESETN(val) (val & 0x00000001)
#define BF_D_SINT_RESETN_GET(val) (val & 0x00000001)

#define REG_SINT_SD_SDM_CTRL_ADDR 0x00000F38
#define BF_D_SINT_SD_PD_INFO 0x00000100
#define BF_D_SINT_SD_PD(val) (val & 0x00000001)
#define BF_D_SINT_SD_PD_GET(val) (val & 0x00000001)
#define BF_D_SINT_SDM_ORDER_INFO 0x00000101
#define BF_D_SINT_SDM_ORDER(val) ((val & 0x00000001) << 0x00000001)
#define BF_D_SINT_SDM_ORDER_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_D_SINT_SDM_DITHER_INFO 0x00000304
#define BF_D_SINT_SDM_DITHER(val) ((val & 0x00000007) << 0x00000004)
#define BF_D_SINT_SDM_DITHER_GET(val) ((val >> 0x00000004) & 0x00000007)

#define REG_SINT_PHI_0_ADDR 0x00000F39
#define BF_D_SINT_PHI_INFO 0x00000A00
#define BF_D_SINT_PHI(val) (val & 0x000003FF)
#define BF_D_SINT_PHI_GET(val) (val & 0x000003FF)

#define REG_SINT_PHI_1_ADDR 0x00000F3A

#define REG_SINT_PHI_LATCH_ADDR 0x00000F3B
#define BF_D_SINT_PHI_LATCH_INFO 0x00000100
#define BF_D_SINT_PHI_LATCH(val) (val & 0x00000001)
#define BF_D_SINT_PHI_LATCH_GET(val) (val & 0x00000001)

#define REG_IMPALA_DIV_PATH_SEL_ADDR 0x00000F3E
#define BF_D_IMPALA_DIV_PATH_SEL_INFO 0x00000100
#define BF_D_IMPALA_DIV_PATH_SEL(val) (val & 0x00000001)
#define BF_D_IMPALA_DIV_PATH_SEL_GET(val) (val & 0x00000001)

#define REG_SYNC_LMFC_DELAY_FRAME_ADDR 0x000000B0
#define BF_SYNC_LMFC_DELAY_SET_FRM_INFO 0x00000500
#define BF_SYNC_LMFC_DELAY_SET_FRM(val) (val & 0x0000001F)
#define BF_SYNC_LMFC_DELAY_SET_FRM_GET(val) (val & 0x0000001F)

#define REG_SYNC_LMFC_DELAY_ADDR 0x000000B1
#define BF_SYNC_LMFC_DELAY_SET_INFO 0x00000800
#define BF_SYNC_LMFC_DELAY_SET(val) (val & 0x000000FF)
#define BF_SYNC_LMFC_DELAY_SET_GET(val) (val & 0x000000FF)

#define REG_SYSREF_COUNT_ADDR 0x000000B4
#define BF_SYSREF_COUNT_INFO 0x00000800
#define BF_SYSREF_COUNT(val) (val & 0x000000FF)
#define BF_SYSREF_COUNT_GET(val) (val & 0x000000FF)

#define REG_SYSREF_PHASE0_ADDR 0x000000B5
#define BF_SYSREF_PHASE_INFO 0x00000D00
#define BF_SYSREF_PHASE(val) (val & 0x00001FFF)
#define BF_SYSREF_PHASE_GET(val) (val & 0x00001FFF)

#define REG_SYSREF_PHASE1_ADDR 0x000000B6

#define REG_SYSREF_ERR_WINDOW_ADDR 0x000000B7
#define BF_SYSREF_ERR_WINDOW_INFO 0x00000700
#define BF_SYSREF_ERR_WINDOW(val) (val & 0x0000007F)
#define BF_SYSREF_ERR_WINDOW_GET(val) (val & 0x0000007F)
#define BF_SYSREF_WITHIN_LMFC_ERRWINDOW_INFO 0x00000107
#define BF_SYSREF_WITHIN_LMFC_ERRWINDOW(val) ((val & 0x00000001) << 0x00000007)
#define BF_SYSREF_WITHIN_LMFC_ERRWINDOW_GET(val) \
	((val >> 0x00000007) & 0x00000001)

#define REG_SYSREF_MODE_ADDR 0x000000B8
#define BF_SYSREF_MODE_CONTINUOUS_INFO 0x00000100
#define BF_SYSREF_MODE_CONTINUOUS(val) (val & 0x00000001)
#define BF_SYSREF_MODE_CONTINUOUS_GET(val) (val & 0x00000001)
#define BF_SYSREF_MODE_ONESHOT_INFO 0x00000101
#define BF_SYSREF_MODE_ONESHOT(val) ((val & 0x00000001) << 0x00000001)
#define BF_SYSREF_MODE_ONESHOT_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_EN_ESYNC_INFO 0x00000102
#define BF_EN_ESYNC(val) ((val & 0x00000001) << 0x00000002)
#define BF_EN_ESYNC_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_FW_SYNC_ENABLE_INFO 0x00000103
#define BF_FW_SYNC_ENABLE(val) ((val & 0x00000001) << 0x00000003)
#define BF_FW_SYNC_ENABLE_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_ONESHOT_SYNC_DONE_INFO 0x00000104
#define BF_ONESHOT_SYNC_DONE(val) ((val & 0x00000001) << 0x00000004)
#define BF_ONESHOT_SYNC_DONE_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_INIT_SYNC_DONE_INFO 0x00000105
#define BF_INIT_SYNC_DONE(val) ((val & 0x00000001) << 0x00000005)
#define BF_INIT_SYNC_DONE_GET(val) ((val >> 0x00000005) & 0x00000001)

#define REG_ROTATION_MODE_ADDR 0x000000B9
#define BF_ROTATION_MODE_INFO 0x00000200
#define BF_ROTATION_MODE(val) (val & 0x00000003)
#define BF_ROTATION_MODE_GET(val) (val & 0x00000003)
#define BF_NCORST_AFTER_ROT_EN_INFO 0x00000104
#define BF_NCORST_AFTER_ROT_EN(val) ((val & 0x00000001) << 0x00000004)
#define BF_NCORST_AFTER_ROT_EN_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_PERIODIC_RST_EN_INFO 0x00000105
#define BF_PERIODIC_RST_EN(val) ((val & 0x00000001) << 0x00000005)
#define BF_PERIODIC_RST_EN_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_PERIODIC_SYNCPULSE_EN_INFO 0x00000106
#define BF_PERIODIC_SYNCPULSE_EN(val) ((val & 0x00000001) << 0x00000006)
#define BF_PERIODIC_SYNCPULSE_EN_GET(val) ((val >> 0x00000006) & 0x00000001)

#define REG_SYSREF_AVERAGE_ADDR 0x000000BA
#define BF_SYSREF_AVERAGE_INFO 0x00000300
#define BF_SYSREF_AVERAGE(val) (val & 0x00000007)
#define BF_SYSREF_AVERAGE_GET(val) (val & 0x00000007)

#define REG_PILOT_GEN_LMFC_CNT_ADDR 0x000000BB
#define BF_PILOT_GEN_LMFC_NUM_INFO 0x00000500
#define BF_PILOT_GEN_LMFC_NUM(val) (val & 0x0000001F)
#define BF_PILOT_GEN_LMFC_NUM_GET(val) (val & 0x0000001F)

#define REG_NCO_SYNC_MS_TRIG_ADDR 0x000000BC
#define BF_NCO_SYNC_MS_TRIG_INFO 0x00000100
#define BF_NCO_SYNC_MS_TRIG(val) (val & 0x00000001)
#define BF_NCO_SYNC_MS_TRIG_GET(val) (val & 0x00000001)

#define REG_RX_TX_LMFC_LCM_ADDR 0x000000BD
#define BF_RX_TX_LMFC_LCM_INFO 0x00000400
#define BF_RX_TX_LMFC_LCM(val) (val & 0x0000000F)
#define BF_RX_TX_LMFC_LCM_GET(val) (val & 0x0000000F)

#define REG_CLOCKING_CTRL_ADDR 0x000000C0
#define BF_RXCLK_EN_INFO 0x00000100
#define BF_RXCLK_EN(val) (val & 0x00000001)
#define BF_RXCLK_EN_GET(val) (val & 0x00000001)
#define BF_TXCLK_EN_INFO 0x00000101
#define BF_TXCLK_EN(val) ((val & 0x00000001) << 0x00000001)
#define BF_TXCLK_EN_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_RX_CLK_SEL_INFO 0x00000102
#define BF_RX_CLK_SEL(val) ((val & 0x00000001) << 0x00000002)
#define BF_RX_CLK_SEL_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_DIRECT_LOOPBACK_MODE_INFO 0x00000204
#define BF_DIRECT_LOOPBACK_MODE(val) ((val & 0x00000003) << 0x00000004)
#define BF_DIRECT_LOOPBACK_MODE_GET(val) ((val >> 0x00000004) & 0x00000003)

#define REG_LOOPBACK_CB_CTRL_ADDR 0x000000C2
#define BF_LOOPBACK_CB_CTRL_INFO 0x00000800
#define BF_LOOPBACK_CB_CTRL(val) (val & 0x000000FF)
#define BF_LOOPBACK_CB_CTRL_GET(val) (val & 0x000000FF)

#define REG_RETIMER_DEBUG0_ADDR 0x000000C3
#define BF_DAC_DATA_INVERSION_EN_INFO 0x00000400
#define BF_DAC_DATA_INVERSION_EN(val) (val & 0x0000000F)
#define BF_DAC_DATA_INVERSION_EN_GET(val) (val & 0x0000000F)
#define BF_DAC_DATA_XOR_EN_INFO 0x00000404
#define BF_DAC_DATA_XOR_EN(val) ((val & 0x0000000F) << 0x00000004)
#define BF_DAC_DATA_XOR_EN_GET(val) ((val >> 0x00000004) & 0x0000000F)

#define REG_RETIMER_DEBUG1_ADDR 0x000000C4
#define BF_THE17TH_BIT_MODE_INFO 0x00000200
#define BF_THE17TH_BIT_MODE(val) (val & 0x00000003)
#define BF_THE17TH_BIT_MODE_GET(val) (val & 0x00000003)
#define BF_PILOT_GEN_CTRL_INFO 0x00000202
#define BF_PILOT_GEN_CTRL(val) ((val & 0x00000003) << 0x00000002)
#define BF_PILOT_GEN_CTRL_GET(val) ((val >> 0x00000002) & 0x00000003)
#define BF_DAC_DATA_PRNG_RESET_INFO 0x00000104
#define BF_DAC_DATA_PRNG_RESET(val) ((val & 0x00000001) << 0x00000004)
#define BF_DAC_DATA_PRNG_RESET_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_PILOT_PRNG_RESET_INFO 0x00000105
#define BF_PILOT_PRNG_RESET(val) ((val & 0x00000001) << 0x00000005)
#define BF_PILOT_PRNG_RESET_GET(val) ((val >> 0x00000005) & 0x00000001)

#define REG_SYNC_DEBUG0_ADDR 0x000000C5
#define BF_EXTRA_LMFC_BEFORE_RXSYNC_INFO 0x00000300
#define BF_EXTRA_LMFC_BEFORE_RXSYNC(val) (val & 0x00000007)
#define BF_EXTRA_LMFC_BEFORE_RXSYNC_GET(val) (val & 0x00000007)
#define BF_ROT_ONALLSYSREF_EN_ANACTRLDIG_INFO 0x00000104
#define BF_ROT_ONALLSYSREF_EN_ANACTRLDIG(val) ((val & 0x00000001) << 0x00000004)
#define BF_ROT_ONALLSYSREF_EN_ANACTRLDIG_GET(val) \
	((val >> 0x00000004) & 0x00000001)
#define BF_AVRG_FLOW_EN_INFO 0x00000105
#define BF_AVRG_FLOW_EN(val) ((val & 0x00000001) << 0x00000005)
#define BF_AVRG_FLOW_EN_GET(val) ((val >> 0x00000005) & 0x00000001)

#define REG_SYNC_DEBUG1_ADDR 0x000000C6
#define BF_SYNC_STATE_INFO 0x00000300
#define BF_SYNC_STATE(val) (val & 0x00000007)
#define BF_SYNC_STATE_GET(val) (val & 0x00000007)
#define BF_RXCLKGEN_RSTEN_FORCE_EN_INFO 0x00000103
#define BF_RXCLKGEN_RSTEN_FORCE_EN(val) ((val & 0x00000001) << 0x00000003)
#define BF_RXCLKGEN_RSTEN_FORCE_EN_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_ROT_STATE_INFO 0x00000304
#define BF_ROT_STATE(val) ((val & 0x00000007) << 0x00000004)
#define BF_ROT_STATE_GET(val) ((val >> 0x00000004) & 0x00000007)
#define BF_HOLD_RSTEN_FROMRX_INFO 0x00000107
#define BF_HOLD_RSTEN_FROMRX(val) ((val & 0x00000001) << 0x00000007)
#define BF_HOLD_RSTEN_FROMRX_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_MANUAL_LMFC_PERIOD0_ADDR 0x000000C7
#define BF_LMFC_PERIOD_SPI_INFO 0x00000B00
#define BF_LMFC_PERIOD_SPI(val) (val & 0x000007FF)
#define BF_LMFC_PERIOD_SPI_GET(val) (val & 0x000007FF)

#define REG_MANUAL_LMFC_PERIOD1_ADDR 0x000000C8
#define BF_LMFC_PERIOD_SPI_EN_INFO 0x00000104
#define BF_LMFC_PERIOD_SPI_EN(val) ((val & 0x00000001) << 0x00000004)
#define BF_LMFC_PERIOD_SPI_EN_GET(val) ((val >> 0x00000004) & 0x00000001)

#define REG_MANUAL_FRAME_PERIOD_ADDR 0x000000C9
#define BF_FRAME_PERIOD_SPI_INFO 0x00000700
#define BF_FRAME_PERIOD_SPI(val) (val & 0x0000007F)
#define BF_FRAME_PERIOD_SPI_GET(val) (val & 0x0000007F)
#define BF_FRAME_PERIOD_SPI_EN_INFO 0x00000107
#define BF_FRAME_PERIOD_SPI_EN(val) ((val & 0x00000001) << 0x00000007)
#define BF_FRAME_PERIOD_SPI_EN_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_MANUAL_SEDESPLLREFCLK_PERIOD2_ADDR 0x000000CA
#define BF_SDSPLLREFCLK_DIV_RATIO_SPI_INFO 0x00000600
#define BF_SDSPLLREFCLK_DIV_RATIO_SPI(val) (val & 0x0000003F)
#define BF_SDSPLLREFCLK_DIV_RATIO_SPI_GET(val) (val & 0x0000003F)
#define BF_SDSPLLREFCLK_DIV_SPI_EN_INFO 0x00000107
#define BF_SDSPLLREFCLK_DIV_SPI_EN(val) ((val & 0x00000001) << 0x00000007)
#define BF_SDSPLLREFCLK_DIV_SPI_EN_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_NCOSYNC_SYSREF_MODE_ADDR 0x000000CB
#define BF_NCO_SYNC_SYSREF_MODE_INFO 0x00000200
#define BF_NCO_SYNC_SYSREF_MODE(val) (val & 0x00000003)
#define BF_NCO_SYNC_SYSREF_MODE_GET(val) (val & 0x00000003)
#define BF_NCO_SYNC_SYSREF_MODE_RX_INFO 0x00000202
#define BF_NCO_SYNC_SYSREF_MODE_RX(val) ((val & 0x00000003) << 0x00000002)
#define BF_NCO_SYNC_SYSREF_MODE_RX_GET(val) ((val >> 0x00000002) & 0x00000003)
#define BF_RXNCOSYNC_SYSREF_ALWAYSON_INFO 0x00000104
#define BF_RXNCOSYNC_SYSREF_ALWAYSON(val) ((val & 0x00000001) << 0x00000004)
#define BF_RXNCOSYNC_SYSREF_ALWAYSON_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_RXNCOSYNC_SYSREF_ONESHOT_INFO 0x00000105
#define BF_RXNCOSYNC_SYSREF_ONESHOT(val) ((val & 0x00000001) << 0x00000005)
#define BF_RXNCOSYNC_SYSREF_ONESHOT_GET(val) ((val >> 0x00000005) & 0x00000001)

#define REG_NCOSYNC_MS_MODE_ADDR 0x000000CC
#define BF_NCO_SYNC_MS_MODE_INFO 0x00000200
#define BF_NCO_SYNC_MS_MODE(val) (val & 0x00000003)
#define BF_NCO_SYNC_MS_MODE_GET(val) (val & 0x00000003)
#define BF_NCO_SYNC_MS_TRIG_SOURCE_INFO 0x00000202
#define BF_NCO_SYNC_MS_TRIG_SOURCE(val) ((val & 0x00000003) << 0x00000002)
#define BF_NCO_SYNC_MS_TRIG_SOURCE_GET(val) ((val >> 0x00000002) & 0x00000003)
#define BF_NCO_SYNC_MS_EXTRA_LMFC_NUM_INFO 0x00000404
#define BF_NCO_SYNC_MS_EXTRA_LMFC_NUM(val) ((val & 0x0000000F) << 0x00000004)
#define BF_NCO_SYNC_MS_EXTRA_LMFC_NUM_GET(val) \
	((val >> 0x00000004) & 0x0000000F)

#define REG_TX_SYSREF_PH_MAP_0_ADDR 0x000000CD
#define BF_TX_SYSREF_FSBY4_PH_MAP_INFO 0x00000800
#define BF_TX_SYSREF_FSBY4_PH_MAP(val) (val & 0x000000FF)
#define BF_TX_SYSREF_FSBY4_PH_MAP_GET(val) (val & 0x000000FF)

#define REG_TX_SYSREF_PH_MAP_1_ADDR 0x000000CE
#define BF_TX_SYSREF_FSBY8_PH_MAP_INFO 0x00000100
#define BF_TX_SYSREF_FSBY8_PH_MAP(val) (val & 0x00000001)
#define BF_TX_SYSREF_FSBY8_PH_MAP_GET(val) (val & 0x00000001)
#define BF_ATSPEED_CLK_DIV2_EN_INFO 0x00000104
#define BF_ATSPEED_CLK_DIV2_EN(val) ((val & 0x00000001) << 0x00000004)
#define BF_ATSPEED_CLK_DIV2_EN_GET(val) ((val >> 0x00000004) & 0x00000001)

#define REG_SPI_ENABLE_DAC_ADDR 0x000000D0
#define BF_SPI_EN_D2A0_INFO 0x00000100
#define BF_SPI_EN_D2A0(val) (val & 0x00000001)
#define BF_SPI_EN_D2A0_GET(val) (val & 0x00000001)
#define BF_SPI_EN_D2A1_INFO 0x00000101
#define BF_SPI_EN_D2A1(val) ((val & 0x00000001) << 0x00000001)
#define BF_SPI_EN_D2A1_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_SPI_EN_D2ACENTER_INFO 0x00000102
#define BF_SPI_EN_D2ACENTER(val) ((val & 0x00000001) << 0x00000002)
#define BF_SPI_EN_D2ACENTER_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_SPI_EN_ANACENTER_INFO 0x00000103
#define BF_SPI_EN_ANACENTER(val) ((val & 0x00000001) << 0x00000003)
#define BF_SPI_EN_ANACENTER_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_SPI_EN_DAC_ANA_INFO 0x00000104
#define BF_SPI_EN_DAC_ANA(val) ((val & 0x00000001) << 0x00000004)
#define BF_SPI_EN_DAC_ANA_GET(val) ((val >> 0x00000004) & 0x00000001)

#define REG_SPI_ENABLE_ADC_ADDR 0x000000D1
#define BF_SPI_EN_REG8_ADC0_INFO 0x00000100
#define BF_SPI_EN_REG8_ADC0(val) (val & 0x00000001)
#define BF_SPI_EN_REG8_ADC0_GET(val) (val & 0x00000001)
#define BF_SPI_EN_REG8_ADC1_INFO 0x00000101
#define BF_SPI_EN_REG8_ADC1(val) ((val & 0x00000001) << 0x00000001)
#define BF_SPI_EN_REG8_ADC1_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_SPI_EN_REG32_ADC0_INFO 0x00000104
#define BF_SPI_EN_REG32_ADC0(val) ((val & 0x00000001) << 0x00000004)
#define BF_SPI_EN_REG32_ADC0_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_SPI_EN_REG32_ADC1_INFO 0x00000105
#define BF_SPI_EN_REG32_ADC1(val) ((val & 0x00000001) << 0x00000005)
#define BF_SPI_EN_REG32_ADC1_GET(val) ((val >> 0x00000005) & 0x00000001)

#define REG_MANUAL_ROT_CENTER_ADDR 0x000000D8
#define BF_MASTERDIV4_MANUL_ROT_INFO 0x00000100
#define BF_MASTERDIV4_MANUL_ROT(val) (val & 0x00000001)
#define BF_MASTERDIV4_MANUL_ROT_GET(val) (val & 0x00000001)
#define BF_ANACTRLDIG_MANUL_ROT_ADC0_INFO 0x00000101
#define BF_ANACTRLDIG_MANUL_ROT_ADC0(val) ((val & 0x00000001) << 0x00000001)
#define BF_ANACTRLDIG_MANUL_ROT_ADC0_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_ANACTRLDIG_MANUL_ROT_ADC1_INFO 0x00000102
#define BF_ANACTRLDIG_MANUL_ROT_ADC1(val) ((val & 0x00000001) << 0x00000002)
#define BF_ANACTRLDIG_MANUL_ROT_ADC1_GET(val) ((val >> 0x00000002) & 0x00000001)

#define REG_MASTERDIV4_ROT_MAP_ADDR 0x000000D9
#define BF_MASTERDIV4_ROTMAP_INFO 0x00000800
#define BF_MASTERDIV4_ROTMAP(val) (val & 0x000000FF)
#define BF_MASTERDIV4_ROTMAP_GET(val) (val & 0x000000FF)

#define REG_ANACTRLDIG_ROT_MAP_ADC0_0_ADDR 0x000000DA
#define BF_ANACTRLDIGDIV4_ROTMAP_ADC0_INFO 0x00001800
#define BF_ANACTRLDIGDIV4_ROTMAP_ADC0(val) (val & 0x00FFFFFF)
#define BF_ANACTRLDIGDIV4_ROTMAP_ADC0_GET(val) (val & 0x00FFFFFF)

#define REG_ANACTRLDIG_ROT_MAP_ADC0_1_ADDR 0x000000DB

#define REG_ANACTRLDIG_ROT_MAP_ADC0_2_ADDR 0x000000DC

#define REG_ANACTRLDIG_ROT_MAP_ADC1_0_ADDR 0x000000DD
#define BF_ANACTRLDIGDIV4_ROTMAP_ADC1_INFO 0x00001800
#define BF_ANACTRLDIGDIV4_ROTMAP_ADC1(val) (val & 0x00FFFFFF)
#define BF_ANACTRLDIGDIV4_ROTMAP_ADC1_GET(val) (val & 0x00FFFFFF)

#define REG_ANACTRLDIG_ROT_MAP_ADC1_1_ADDR 0x000000DE

#define REG_ANACTRLDIG_ROT_MAP_ADC1_2_ADDR 0x000000DF

#define REG_DAC_SUPPLY_MONITOR_ADDR 0x00000210
#define BF_AVDD_DAC23_MON2_INFO 0x00000100
#define BF_AVDD_DAC23_MON2(val) (val & 0x00000001)
#define BF_AVDD_DAC23_MON2_GET(val) (val & 0x00000001)
#define BF_AVDD_DAC01_MON2_INFO 0x00000101
#define BF_AVDD_DAC01_MON2(val) ((val & 0x00000001) << 0x00000001)
#define BF_AVDD_DAC01_MON2_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_DVDD_DAC23_MON1_INFO 0x00000102
#define BF_DVDD_DAC23_MON1(val) ((val & 0x00000001) << 0x00000002)
#define BF_DVDD_DAC23_MON1_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_DVDD_DAC01_MON1_INFO 0x00000103
#define BF_DVDD_DAC01_MON1(val) ((val & 0x00000001) << 0x00000003)
#define BF_DVDD_DAC01_MON1_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_DAVDD_DAC23_MON1_INFO 0x00000104
#define BF_DAVDD_DAC23_MON1(val) ((val & 0x00000001) << 0x00000004)
#define BF_DAVDD_DAC23_MON1_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_DAVDD_DAC01_MON1_INFO 0x00000105
#define BF_DAVDD_DAC01_MON1(val) ((val & 0x00000001) << 0x00000005)
#define BF_DAVDD_DAC01_MON1_GET(val) ((val >> 0x00000005) & 0x00000001)

#define REG_CLOCK_SUPPLY_MONITOR_ADDR 0x00000211
#define BF_DACPLLVDD_MON2_INFO 0x00000100
#define BF_DACPLLVDD_MON2(val) (val & 0x00000001)
#define BF_DACPLLVDD_MON2_GET(val) (val & 0x00000001)
#define BF_LS_CLOCK_MON1_INFO 0x00000101
#define BF_LS_CLOCK_MON1(val) ((val & 0x00000001) << 0x00000001)
#define BF_LS_CLOCK_MON1_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_HS_CLOCK_MON1_INFO 0x00000102
#define BF_HS_CLOCK_MON1(val) ((val & 0x00000001) << 0x00000002)
#define BF_HS_CLOCK_MON1_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_REF_UP_CLOCK_MON1_INFO 0x00000103
#define BF_REF_UP_CLOCK_MON1(val) ((val & 0x00000001) << 0x00000003)
#define BF_REF_UP_CLOCK_MON1_GET(val) ((val >> 0x00000003) & 0x00000001)

#define REG_ADC0_SUPPLY_MONITOR_ADDR 0x00000212
#define BF_ADC0_CLK_MON1_INFO 0x00000100
#define BF_ADC0_CLK_MON1(val) (val & 0x00000001)
#define BF_ADC0_CLK_MON1_GET(val) (val & 0x00000001)
#define BF_ADC0_CORE_MON1_INFO 0x00000101
#define BF_ADC0_CORE_MON1(val) ((val & 0x00000001) << 0x00000001)
#define BF_ADC0_CORE_MON1_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_ADC0_BUF_MON1_INFO 0x00000102
#define BF_ADC0_BUF_MON1(val) ((val & 0x00000001) << 0x00000002)
#define BF_ADC0_BUF_MON1_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_ADC0_REFADC_MON1_INFO 0x00000103
#define BF_ADC0_REFADC_MON1(val) ((val & 0x00000001) << 0x00000003)
#define BF_ADC0_REFADC_MON1_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_ADC0_REF_MON2_INFO 0x00000104
#define BF_ADC0_REF_MON2(val) ((val & 0x00000001) << 0x00000004)
#define BF_ADC0_REF_MON2_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_ADC0_BUF_MON2_INFO 0x00000105 /* r2 */

#define REG_ADC1_SUPPLY_MONITOR_ADDR 0x00000213
#define BF_ADC1_CLK_MON1_INFO 0x00000100
#define BF_ADC1_CLK_MON1(val) (val & 0x00000001)
#define BF_ADC1_CLK_MON1_GET(val) (val & 0x00000001)
#define BF_ADC1_CORE_MON1_INFO 0x00000101
#define BF_ADC1_CORE_MON1(val) ((val & 0x00000001) << 0x00000001)
#define BF_ADC1_CORE_MON1_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_ADC1_BUF_MON1_INFO 0x00000102
#define BF_ADC1_BUF_MON1(val) ((val & 0x00000001) << 0x00000002)
#define BF_ADC1_BUF_MON1_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_ADC1_REFADC_MON1_INFO 0x00000103
#define BF_ADC1_REFADC_MON1(val) ((val & 0x00000001) << 0x00000003)
#define BF_ADC1_REFADC_MON1_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_ADC1_REF_MON2_INFO 0x00000104
#define BF_ADC1_REF_MON2(val) ((val & 0x00000001) << 0x00000004)
#define BF_ADC1_REF_MON2_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_ADC1_BUF_MON2_INFO 0x00000105 /* r2 */

#define REG_ADC_RESETS_ADDR 0x00000214
#define BF_ADC0_ANA_RESET_INFO 0x00000100
#define BF_ADC0_ANA_RESET(val) (val & 0x00000001)
#define BF_ADC0_ANA_RESET_GET(val) (val & 0x00000001)
#define BF_ADC0_DIG_RESET_INFO 0x00000101
#define BF_ADC0_DIG_RESET(val) ((val & 0x00000001) << 0x00000001)
#define BF_ADC0_DIG_RESET_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_ADC1_ANA_RESET_INFO 0x00000102
#define BF_ADC1_ANA_RESET(val) ((val & 0x00000001) << 0x00000002)
#define BF_ADC1_ANA_RESET_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_ADC1_DIG_RESET_INFO 0x00000103
#define BF_ADC1_DIG_RESET(val) ((val & 0x00000001) << 0x00000003)
#define BF_ADC1_DIG_RESET_GET(val) ((val >> 0x00000003) & 0x00000001)

#define REG_DAC_AND_CLOCK_RESETS_ADDR 0x00000215
#define BF_DAC01_RESET_INFO 0x00000100
#define BF_DAC01_RESET(val) (val & 0x00000001)
#define BF_DAC01_RESET_GET(val) (val & 0x00000001)
#define BF_DAC23_RESET_INFO 0x00000101
#define BF_DAC23_RESET(val) ((val & 0x00000001) << 0x00000001)
#define BF_DAC23_RESET_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_D2A01_RESET_INFO 0x00000102
#define BF_D2A01_RESET(val) ((val & 0x00000001) << 0x00000002)
#define BF_D2A01_RESET_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_D2A23_RESET_INFO 0x00000103
#define BF_D2A23_RESET(val) ((val & 0x00000001) << 0x00000003)
#define BF_D2A23_RESET_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_D2ACENT_RESET_INFO 0x00000104
#define BF_D2ACENT_RESET(val) ((val & 0x00000001) << 0x00000004)
#define BF_D2ACENT_RESET_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_ANACENT_RESET_INFO 0x00000105
#define BF_ANACENT_RESET(val) ((val & 0x00000001) << 0x00000005)
#define BF_ANACENT_RESET_GET(val) ((val >> 0x00000005) & 0x00000001)

#define REG_CAL_CTRL_ADDR 0x0000010F
#define BF_CAL_START_INFO 0x00000100
#define BF_CAL_START(val) (val & 0x00000001)
#define BF_CAL_START_GET(val) (val & 0x00000001)
#define BF_CAL_MODE_INFO 0x00000201
#define BF_CAL_MODE(val) ((val & 0x00000003) << 0x00000001)
#define BF_CAL_MODE_GET(val) ((val >> 0x00000001) & 0x00000003)
#define BF_CAL_RESETB_INFO 0x00000107
#define BF_CAL_RESETB(val) ((val & 0x00000001) << 0x00000007)
#define BF_CAL_RESETB_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_CAL_STAT_ADDR 0x00000110
#define BF_CAL_FINISH_INFO 0x00000100
#define BF_CAL_FINISH(val) (val & 0x00000001)
#define BF_CAL_FINISH_GET(val) (val & 0x00000001)
#define BF_CAL_FAIL_SEARCH_INFO 0x00000101
#define BF_CAL_FAIL_SEARCH(val) ((val & 0x00000001) << 0x00000001)
#define BF_CAL_FAIL_SEARCH_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_CAL_ACTIVE_INFO 0x00000102
#define BF_CAL_ACTIVE(val) ((val & 0x00000001) << 0x00000002)
#define BF_CAL_ACTIVE_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_SKIP_R2R_PRESET_INFO 0x00000107
#define BF_SKIP_R2R_PRESET(val) ((val & 0x00000001) << 0x00000007)
#define BF_SKIP_R2R_PRESET_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_FSC0_ADDR 0x00000117
#define BF_FSC_CTRL_INFO 0x00000A00
#define BF_FSC_CTRL(val) (val & 0x000003FF)
#define BF_FSC_CTRL_GET(val) (val & 0x000003FF)
#define BF_FSC_MIN_CTRL_INFO 0x00000404
#define BF_FSC_MIN_CTRL(val) ((val & 0x0000000F) << 0x00000004)
#define BF_FSC_MIN_CTRL_GET(val) ((val >> 0x00000004) & 0x0000000F)

#define REG_FSC1_ADDR 0x00000118

#define REG_CAL_DEBUG0_ADDR 0x0000011F
#define BF_CAL_EN_C_INFO 0x00000104
#define BF_CAL_EN_C(val) ((val & 0x00000001) << 0x00000004)
#define BF_CAL_EN_C_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_CAL_EN_G_INFO 0x00000105
#define BF_CAL_EN_G(val) ((val & 0x00000001) << 0x00000005)
#define BF_CAL_EN_G_GET(val) ((val >> 0x00000005) & 0x00000001)

#define REG_DECODE_MODE_ADDR 0x00000140
#define BF_ISB_MODE_INFO 0x00000200
#define BF_ISB_MODE(val) (val & 0x00000003)
#define BF_ISB_MODE_GET(val) (val & 0x00000003)
#define BF_MSB_MODE_INFO 0x00000204
#define BF_MSB_MODE(val) ((val & 0x00000003) << 0x00000004)
#define BF_MSB_MODE_GET(val) ((val >> 0x00000004) & 0x00000003)

#define REG_MSB_ROTATION_ADDR 0x00000143
#define BF_MSB_ROTATION_SPD_INFO 0x00000500
#define BF_MSB_ROTATION_SPD(val) (val & 0x0000001F)
#define BF_MSB_ROTATION_SPD_GET(val) (val & 0x0000001F)
#define BF_MSB_ROTATION_EN_INFO 0x00000105
#define BF_MSB_ROTATION_EN(val) ((val & 0x00000001) << 0x00000005)
#define BF_MSB_ROTATION_EN_GET(val) ((val >> 0x00000005) & 0x00000001)

#define REG_ADC_DIVIDER_CTRL_ADDR 0x00000180
#define BF_ADCDIVN_DIVRATIO_SPI_INFO 0x00000200
#define BF_ADCDIVN_DIVRATIO_SPI(val) (val & 0x00000003)
#define BF_ADCDIVN_DIVRATIO_SPI_GET(val) (val & 0x00000003)
#define BF_ADCDIVN_DIVRATIO_FORCED_INFO 0x00000202
#define BF_ADCDIVN_DIVRATIO_FORCED(val) ((val & 0x00000003) << 0x00000002)
#define BF_ADCDIVN_DIVRATIO_FORCED_GET(val) ((val >> 0x00000002) & 0x00000003)
#define BF_ADCDIVN_PD_INFO 0x00000104
#define BF_ADCDIVN_PD(val) ((val & 0x00000001) << 0x00000004)
#define BF_ADCDIVN_PD_GET(val) ((val >> 0x00000004) & 0x00000001)

#define REG_MUSHI_CTRL_ADDR 0x00000181
#define BF_MUSHI_PD0_INFO 0x00000100
#define BF_MUSHI_PD0(val) (val & 0x00000001)
#define BF_MUSHI_PD0_GET(val) (val & 0x00000001)
#define BF_MUSHI_PD0_DUM_INFO 0x00000101
#define BF_MUSHI_PD0_DUM(val) ((val & 0x00000001) << 0x00000001)
#define BF_MUSHI_PD0_DUM_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_MUSHI_PD1_INFO 0x00000104
#define BF_MUSHI_PD1(val) ((val & 0x00000001) << 0x00000004)
#define BF_MUSHI_PD1_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_MUSHI_PD1_DUM_INFO 0x00000105
#define BF_MUSHI_PD1_DUM(val) ((val & 0x00000001) << 0x00000005)
#define BF_MUSHI_PD1_DUM_GET(val) ((val >> 0x00000005) & 0x00000001)

#define REG_ENABLE_TIMING_CTRL_DAC0_ADDR 0x00000183
#define BF_SWDCLKEN_CTRL_DAC0_INFO 0x00000200
#define BF_SWDCLKEN_CTRL_DAC0(val) (val & 0x00000003)
#define BF_SWDCLKEN_CTRL_DAC0_GET(val) (val & 0x00000003)
#define BF_FORCEHIGH_CTRL_DAC0_INFO 0x00000202
#define BF_FORCEHIGH_CTRL_DAC0(val) ((val & 0x00000003) << 0x00000002)
#define BF_FORCEHIGH_CTRL_DAC0_GET(val) ((val >> 0x00000002) & 0x00000003)
#define BF_MUSHICLKEN_CTRL_DAC0_INFO 0x00000204
#define BF_MUSHICLKEN_CTRL_DAC0(val) ((val & 0x00000003) << 0x00000004)
#define BF_MUSHICLKEN_CTRL_DAC0_GET(val) ((val >> 0x00000004) & 0x00000003)

#define REG_ENABLE_TIMING_CTRL_DAC1_ADDR 0x00000184
#define BF_SWDCLKEN_CTRL_DAC1_INFO 0x00000200
#define BF_SWDCLKEN_CTRL_DAC1(val) (val & 0x00000003)
#define BF_SWDCLKEN_CTRL_DAC1_GET(val) (val & 0x00000003)
#define BF_FORCEHIGH_CTRL_DAC1_INFO 0x00000202
#define BF_FORCEHIGH_CTRL_DAC1(val) ((val & 0x00000003) << 0x00000002)
#define BF_FORCEHIGH_CTRL_DAC1_GET(val) ((val >> 0x00000002) & 0x00000003)
#define BF_MUSHICLKEN_CTRL_DAC1_INFO 0x00000204
#define BF_MUSHICLKEN_CTRL_DAC1(val) ((val & 0x00000003) << 0x00000004)
#define BF_MUSHICLKEN_CTRL_DAC1_GET(val) ((val >> 0x00000004) & 0x00000003)

#define REG_ENABLE_TIMING_CTRL_GENERAL_ADDR 0x00000185
#define BF_DLLCLK_ENCTRL_INFO 0x00000200
#define BF_DLLCLK_ENCTRL(val) (val & 0x00000003)
#define BF_DLLCLK_ENCTRL_GET(val) (val & 0x00000003)

#define REG_HANDOFF_DEBUG_ADDR 0x00000187
#define BF_PARITY_EN_DAC0_INFO 0x00000100
#define BF_PARITY_EN_DAC0(val) (val & 0x00000001)
#define BF_PARITY_EN_DAC0_GET(val) (val & 0x00000001)
#define BF_PARITY_CLEAR_DAC0_INFO 0x00000101
#define BF_PARITY_CLEAR_DAC0(val) ((val & 0x00000001) << 0x00000001)
#define BF_PARITY_CLEAR_DAC0_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_DATA_DEXOR_EN_DAC0_INFO 0x00000102
#define BF_DATA_DEXOR_EN_DAC0(val) ((val & 0x00000001) << 0x00000002)
#define BF_DATA_DEXOR_EN_DAC0_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_SELECTION_LSB7_DAC0_INFO 0x00000103
#define BF_SELECTION_LSB7_DAC0(val) ((val & 0x00000001) << 0x00000003)
#define BF_SELECTION_LSB7_DAC0_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_PARITY_EN_DAC1_INFO 0x00000104
#define BF_PARITY_EN_DAC1(val) ((val & 0x00000001) << 0x00000004)
#define BF_PARITY_EN_DAC1_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_PARITY_CLEAR_DAC1_INFO 0x00000105
#define BF_PARITY_CLEAR_DAC1(val) ((val & 0x00000001) << 0x00000005)
#define BF_PARITY_CLEAR_DAC1_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_DATA_DEXOR_EN_DAC1_INFO 0x00000106
#define BF_DATA_DEXOR_EN_DAC1(val) ((val & 0x00000001) << 0x00000006)
#define BF_DATA_DEXOR_EN_DAC1_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_SELECTION_LSB7_DAC1_INFO 0x00000107
#define BF_SELECTION_LSB7_DAC1(val) ((val & 0x00000001) << 0x00000007)
#define BF_SELECTION_LSB7_DAC1_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_PARITY_RESULTS_ADDR 0x00000188
#define BF_PARITY_RESULT_DAC0_INFO 0x00000400
#define BF_PARITY_RESULT_DAC0(val) (val & 0x0000000F)
#define BF_PARITY_RESULT_DAC0_GET(val) (val & 0x0000000F)
#define BF_PARITY_RESULT_DAC1_INFO 0x00000404
#define BF_PARITY_RESULT_DAC1(val) ((val & 0x0000000F) << 0x00000004)
#define BF_PARITY_RESULT_DAC1_GET(val) ((val >> 0x00000004) & 0x0000000F)

#define REG_D2ADIV4_ROT_MAP_ADDR 0x0000018B
#define BF_D2ADIV4_ROTMAP_INFO 0x00000800
#define BF_D2ADIV4_ROTMAP(val) (val & 0x000000FF)
#define BF_D2ADIV4_ROTMAP_GET(val) (val & 0x000000FF)

#define REG_ADCDIVN_ROT_MAP_ADDR 0x0000018C
#define BF_ADCDIVN_ROTMAP_INFO 0x00000800
#define BF_ADCDIVN_ROTMAP(val) (val & 0x000000FF)
#define BF_ADCDIVN_ROTMAP_GET(val) (val & 0x000000FF)

#define REG_D2A_DCC_CLKGEN_ADDR 0x00000190
#define BF_D2ADCC_CLKEN_INFO 0x00000106
#define BF_D2ADCC_CLKEN(val) ((val & 0x00000001) << 0x00000006)
#define BF_D2ADCC_CLKEN_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_D2ADUAL_DAC_CLK_ENABLE_INFO 0x00000107
#define BF_D2ADUAL_DAC_CLK_ENABLE(val) ((val & 0x00000001) << 0x00000007)
#define BF_D2ADUAL_DAC_CLK_ENABLE_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_D2A_DCC_CALCTRL_ADDR 0x00000191
#define BF_D2ADCC_MAX_SEARCH_NUM_INFO 0x00000500
#define BF_D2ADCC_MAX_SEARCH_NUM(val) (val & 0x0000001F)
#define BF_D2ADCC_MAX_SEARCH_NUM_GET(val) (val & 0x0000001F)
#define BF_D2ADCC_ENABLE_INFO 0x00000106
#define BF_D2ADCC_ENABLE(val) ((val & 0x00000001) << 0x00000006)
#define BF_D2ADCC_ENABLE_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_D2ADCC_START_INFO 0x00000107
#define BF_D2ADCC_START(val) ((val & 0x00000001) << 0x00000007)
#define BF_D2ADCC_START_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_D2A_DCC_RSLT_ADDR 0x00000193
#define BF_D2ADCC_CODE_INFO 0x00000600
#define BF_D2ADCC_CODE(val) (val & 0x0000003F)
#define BF_D2ADCC_CODE_GET(val) (val & 0x0000003F)
#define BF_D2ADCC_DONE_INFO 0x00000107
#define BF_D2ADCC_DONE(val) ((val & 0x00000001) << 0x00000007)
#define BF_D2ADCC_DONE_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_RING_OSC_ADDR 0x00000195
#define BF_RINGOSC_DIV_INFO 0x00000200
#define BF_RINGOSC_DIV(val) (val & 0x00000003)
#define BF_RINGOSC_DIV_GET(val) (val & 0x00000003)
#define BF_RINGOSC_EN_INFO 0x00000107
#define BF_RINGOSC_EN(val) ((val & 0x00000001) << 0x00000007)
#define BF_RINGOSC_EN_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_ADC_CLK_CTRL0_ADDR 0x00000196
#define BF_ADC_DRIVER_DATA_CTRL_INFO 0x00000500
#define BF_ADC_DRIVER_DATA_CTRL(val) (val & 0x0000001F)
#define BF_ADC_DRIVER_DATA_CTRL_GET(val) (val & 0x0000001F)

#define REG_CLK_CTRL1_ADDR 0x00000198
#define BF_PD_ADC_DRIVER_INFO 0x00000100
#define BF_PD_ADC_DRIVER(val) (val & 0x00000001)
#define BF_PD_ADC_DRIVER_GET(val) (val & 0x00000001)
#define BF_SEL_ADC_CLK_DRIVER_INFO 0x00000101
#define BF_SEL_ADC_CLK_DRIVER(val) ((val & 0x00000001) << 0x00000001)
#define BF_SEL_ADC_CLK_DRIVER_GET(val) ((val >> 0x00000001) & 0x00000001)

#define REG_CLK_CTRL2_ADDR 0x00000199
#define BF_CAL_CLK_PD0_INFO 0x00000100
#define BF_CAL_CLK_PD0(val) (val & 0x00000001)
#define BF_CAL_CLK_PD0_GET(val) (val & 0x00000001)
#define BF_CAL_CLK_PD1_INFO 0x00000101
#define BF_CAL_CLK_PD1(val) ((val & 0x00000001) << 0x00000001)
#define BF_CAL_CLK_PD1_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_CAL_CLK_PD2_INFO 0x00000102
#define BF_CAL_CLK_PD2(val) ((val & 0x00000001) << 0x00000002)
#define BF_CAL_CLK_PD2_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_CAL_CLK_PD3_INFO 0x00000103
#define BF_CAL_CLK_PD3(val) ((val & 0x00000001) << 0x00000003)
#define BF_CAL_CLK_PD3_GET(val) ((val >> 0x00000003) & 0x00000001)

#define REG_SYSREF_CTRL_ADDR 0x0000019A
#define BF_SYSREF_PD_INFO 0x00000100
#define BF_SYSREF_PD(val) (val & 0x00000001)
#define BF_SYSREF_PD_GET(val) (val & 0x00000001)
#define BF_SYSREF_INPUTMODE_INFO 0x00000106
#define BF_SYSREF_INPUTMODE(val) ((val & 0x00000001) << 0x00000006)
#define BF_SYSREF_INPUTMODE_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_SYSREF_BIAS_PD_INFO 0x00000107
#define BF_SYSREF_BIAS_PD(val) ((val & 0x00000001) << 0x00000007)
#define BF_SYSREF_BIAS_PD_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_UC_CLK_CTRL_ADDR 0x0000019B
#define BF_UC_CLK_PD_INFO 0x00000100
#define BF_UC_CLK_PD(val) (val & 0x00000001)
#define BF_UC_CLK_PD_GET(val) (val & 0x00000001)
#define BF_UC_CLK_SEL_INFO 0x00000101
#define BF_UC_CLK_SEL(val) ((val & 0x00000001) << 0x00000001)
#define BF_UC_CLK_SEL_GET(val) ((val >> 0x00000001) & 0x00000001)

#define REG_RSA_CLK_CTRL_ADDR 0x0000019D
#define BF_RSA_CLK_EN_INFO 0x00000100
#define BF_RSA_CLK_EN(val) (val & 0x00000001)
#define BF_RSA_CLK_EN_GET(val) (val & 0x00000001)

#define REG_SYSREF_CTRL2_ADDR 0x0000019E
#define BF_SYSREF_SAMPLE_TYPE_INFO 0x00000100
#define BF_SYSREF_SAMPLE_TYPE(val) (val & 0x00000001)
#define BF_SYSREF_SAMPLE_TYPE_GET(val) (val & 0x00000001)
#define BF_SYSREF_PLLREF_EN_INFO 0x00000104
#define BF_SYSREF_PLLREF_EN(val) ((val & 0x00000001) << 0x00000004)
#define BF_SYSREF_PLLREF_EN_GET(val) ((val >> 0x00000004) & 0x00000001)

#define REG_DDSC_DATAPATH_CFG_ADDR 0x000001A0
#define BF_TEST_TONE_EN_INFO 0x00000100
#define BF_TEST_TONE_EN(val) (val & 0x00000001)
#define BF_TEST_TONE_EN_GET(val) (val & 0x00000001)
#define BF_DDSC_SEL_SIDEBAND_INFO 0x00000101
#define BF_DDSC_SEL_SIDEBAND(val) ((val & 0x00000001) << 0x00000001)
#define BF_DDSC_SEL_SIDEBAND_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_DDSC_MODULUS_EN_INFO 0x00000102
#define BF_DDSC_MODULUS_EN(val) ((val & 0x00000001) << 0x00000002)
#define BF_DDSC_MODULUS_EN_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_DDSC_NCO_EN_INFO 0x00000106
#define BF_DDSC_NCO_EN(val) ((val & 0x00000001) << 0x00000006)
#define BF_DDSC_NCO_EN_GET(val) ((val >> 0x00000006) & 0x00000001)

#define REG_DDSC_FTW_UPDATE_ADDR 0x000001A1
#define BF_DDSC_FTW_LOAD_REQ_INFO 0x00000100
#define BF_DDSC_FTW_LOAD_REQ(val) (val & 0x00000001)
#define BF_DDSC_FTW_LOAD_REQ_GET(val) (val & 0x00000001)
#define BF_DDSC_FTW_LOAD_SYSREF_INFO 0x00000102
#define BF_DDSC_FTW_LOAD_SYSREF(val) ((val & 0x00000001) << 0x00000002)
#define BF_DDSC_FTW_LOAD_SYSREF_GET(val) ((val >> 0x00000002) & 0x00000001)

#define REG_DDSC_FTW0_ADDR 0x000001A2
#define BF_DDSC_FTW_INFO 0x00003000

#define REG_DDSC_FTW1_ADDR 0x000001A3

#define REG_DDSC_FTW2_ADDR 0x000001A4

#define REG_DDSC_FTW3_ADDR 0x000001A5

#define REG_DDSC_FTW4_ADDR 0x000001A6

#define REG_DDSC_FTW5_ADDR 0x000001A7

#define REG_DDSC_PHASE_OFFSET0_ADDR 0x000001A8
#define BF_DDSC_NCO_PHASE_OFFSET_INFO 0x00001000
#define BF_DDSC_NCO_PHASE_OFFSET(val) (val & 0x0000FFFF)
#define BF_DDSC_NCO_PHASE_OFFSET_GET(val) (val & 0x0000FFFF)

#define REG_DDSC_PHASE_OFFSET1_ADDR 0x000001A9

#define REG_DDSC_ACC_MODULUS0_ADDR 0x000001AA
#define BF_DDSC_ACC_MODULUS_INFO 0x00003000

#define REG_DDSC_ACC_MODULUS1_ADDR 0x000001AB

#define REG_DDSC_ACC_MODULUS2_ADDR 0x000001AC

#define REG_DDSC_ACC_MODULUS3_ADDR 0x000001AD

#define REG_DDSC_ACC_MODULUS4_ADDR 0x000001AE

#define REG_DDSC_ACC_MODULUS5_ADDR 0x000001AF

#define REG_DDSC_ACC_DELTA0_ADDR 0x000001B0
#define BF_DDSC_ACC_DELTA_INFO 0x00003000

#define REG_DDSC_ACC_DELTA1_ADDR 0x000001B1

#define REG_DDSC_ACC_DELTA2_ADDR 0x000001B2

#define REG_DDSC_ACC_DELTA3_ADDR 0x000001B3

#define REG_DDSC_ACC_DELTA4_ADDR 0x000001B4

#define REG_DDSC_ACC_DELTA5_ADDR 0x000001B5

#define REG_DC_OFFSET0_ADDR 0x000001B6
#define BF_DC_OFFSET_INFO 0x00001000
#define BF_DC_OFFSET(val) (val & 0x0000FFFF)
#define BF_DC_OFFSET_GET(val) (val & 0x0000FFFF)

#define REG_DC_OFFSET1_ADDR 0x000001B7

#define REG_CHNL_GAIN0_ADDR 0x000001B8
#define BF_CHNL_GAIN_INFO 0x00000C00
#define BF_CHNL_GAIN(val) (val & 0x00000FFF)
#define BF_CHNL_GAIN_GET(val) (val & 0x00000FFF)

#define REG_CHNL_GAIN1_ADDR 0x000001B9

#define REG_CHNL_SKEW_ADJUST_ADDR 0x000001C6
#define BF_CHNL_SKEW_ADJ_INFO 0x00000400
#define BF_CHNL_SKEW_ADJ(val) (val & 0x0000000F)
#define BF_CHNL_SKEW_ADJ_GET(val) (val & 0x0000000F)

#define REG_CHNL_NCO_SYNC_ADDR 0x000001C7
#define BF_NCO_SYNC_CHNL_SEL_INFO 0x00000800
#define BF_NCO_SYNC_CHNL_SEL(val) (val & 0x000000FF)
#define BF_NCO_SYNC_CHNL_SEL_GET(val) (val & 0x000000FF)

#define REG_MAINDP_DAC_1XXX_ENABLES_ADDR 0x000001C8
#define BF_MAINDP_DAC_1XXX_ENABLES_INFO 0x00000400
#define BF_MAINDP_DAC_1XXX_ENABLES(val) (val & 0x0000000F)
#define BF_MAINDP_DAC_1XXX_ENABLES_GET(val) (val & 0x0000000F)
#define BF_MAINDP_DAC_1XXX_EN_SPI_INFO 0x00000107
#define BF_MAINDP_DAC_1XXX_EN_SPI(val) ((val & 0x00000001) << 0x00000007)
#define BF_MAINDP_DAC_1XXX_EN_SPI_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_DDSM_DATAPATH_CFG_ADDR 0x000001C9
#define BF_DDSM_SEL_SIDEBAND_INFO 0x00000101
#define BF_DDSM_SEL_SIDEBAND(val) ((val & 0x00000001) << 0x00000001)
#define BF_DDSM_SEL_SIDEBAND_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_DDSM_MODULUS_EN_INFO 0x00000102
#define BF_DDSM_MODULUS_EN(val) ((val & 0x00000001) << 0x00000002)
#define BF_DDSM_MODULUS_EN_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_DDSM_NCO_EN_INFO 0x00000103
#define BF_DDSM_NCO_EN(val) ((val & 0x00000001) << 0x00000003)
#define BF_DDSM_NCO_EN_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_DDSM_MODE_INFO 0x00000204
#define BF_DDSM_MODE(val) ((val & 0x00000003) << 0x00000004)
#define BF_DDSM_MODE_GET(val) ((val >> 0x00000004) & 0x00000003)
#define BF_EN_CMPLX_MODULATION_INFO 0x00000106
#define BF_EN_CMPLX_MODULATION(val) ((val & 0x00000001) << 0x00000006)
#define BF_EN_CMPLX_MODULATION_GET(val) ((val >> 0x00000006) & 0x00000001)

#define REG_DDSM_FTW_UPDATE_ADDR 0x000001CA
#define BF_DDSM_FTW_LOAD_REQ_INFO 0x00000100
#define BF_DDSM_FTW_LOAD_REQ(val) (val & 0x00000001)
#define BF_DDSM_FTW_LOAD_REQ_GET(val) (val & 0x00000001)
#define BF_DDSM_FTW_LOAD_SYSREF_INFO 0x00000102
#define BF_DDSM_FTW_LOAD_SYSREF(val) ((val & 0x00000001) << 0x00000002)
#define BF_DDSM_FTW_LOAD_SYSREF_GET(val) ((val >> 0x00000002) & 0x00000001)

#define REG_DDSM_FTW0_ADDR 0x000001CB
#define BF_DDSM_FTW_INFO 0x00003000

#define REG_DDSM_FTW1_ADDR 0x000001CC

#define REG_DDSM_FTW2_ADDR 0x000001CD

#define REG_DDSM_FTW3_ADDR 0x000001CE

#define REG_DDSM_FTW4_ADDR 0x000001CF

#define REG_DDSM_FTW5_ADDR 0x000001D0

#define REG_DDSM_PHASE_OFFSET0_ADDR 0x000001D1
#define BF_DDSM_NCO_PHASE_OFFSET_INFO 0x00001000
#define BF_DDSM_NCO_PHASE_OFFSET(val) (val & 0x0000FFFF)
#define BF_DDSM_NCO_PHASE_OFFSET_GET(val) (val & 0x0000FFFF)

#define REG_DDSM_PHASE_OFFSET1_ADDR 0x000001D2

#define REG_DDSM_ACC_MODULUS0_ADDR 0x000001D3
#define BF_DDSM_ACC_MODULUS_INFO 0x00003000

#define REG_DDSM_ACC_MODULUS1_ADDR 0x000001D4

#define REG_DDSM_ACC_MODULUS2_ADDR 0x000001D5

#define REG_DDSM_ACC_MODULUS3_ADDR 0x000001D6

#define REG_DDSM_ACC_MODULUS4_ADDR 0x000001D7

#define REG_DDSM_ACC_MODULUS5_ADDR 0x000001D8

#define REG_DDSM_ACC_DELTA0_ADDR 0x000001D9
#define BF_DDSM_ACC_DELTA_INFO 0x00003000

#define REG_DDSM_ACC_DELTA1_ADDR 0x000001DA

#define REG_DDSM_ACC_DELTA2_ADDR 0x000001DB

#define REG_DDSM_ACC_DELTA3_ADDR 0x000001DC

#define REG_DDSM_ACC_DELTA4_ADDR 0x000001DD

#define REG_DDSM_ACC_DELTA5_ADDR 0x000001DE

#define REG_DDSM_CAL_FTW0_ADDR 0x000001E5
#define BF_DDSM_CAL_FTW_INFO 0x00002000
#define BF_DDSM_CAL_FTW(val) (val & 0x00000000)
#define BF_DDSM_CAL_FTW_GET(val) (val & 0x00000000)

#define REG_DDSM_CAL_FTW1_ADDR 0x000001E6

#define REG_DDSM_CAL_FTW2_ADDR 0x000001E7

#define REG_DDSM_CAL_FTW3_ADDR 0x000001E8

#define REG_DDSM_CAL_MODE_DEF_ADDR 0x000001E9
#define BF_DDSM_EN_CAL_FREQ_TUNE_INFO 0x00000100
#define BF_DDSM_EN_CAL_FREQ_TUNE(val) (val & 0x00000001)
#define BF_DDSM_EN_CAL_FREQ_TUNE_GET(val) (val & 0x00000001)
#define BF_DDSM_EN_CAL_DC_INPUT_INFO 0x00000101
#define BF_DDSM_EN_CAL_DC_INPUT(val) ((val & 0x00000001) << 0x00000001)
#define BF_DDSM_EN_CAL_DC_INPUT_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_DDSM_EN_CAL_ACC_INFO 0x00000102
#define BF_DDSM_EN_CAL_ACC(val) ((val & 0x00000001) << 0x00000002)
#define BF_DDSM_EN_CAL_ACC_GET(val) ((val >> 0x00000002) & 0x00000001)

#define REG_MAIN_AUTO_CLK_GATING_ADDR 0x000001EF
#define BF_NCO_1X1X_EN_INFO 0x00000404
#define BF_NCO_1X1X_EN(val) ((val & 0x0000000F) << 0x00000004)
#define BF_NCO_1X1X_EN_GET(val) ((val >> 0x00000004) & 0x0000000F)

#define REG_MAINDP_ENABLE_ADDR 0x000001F0
#define BF_EN_SPI_MAINDP_EN_INFO 0x00000100
#define BF_EN_SPI_MAINDP_EN(val) (val & 0x00000001)
#define BF_EN_SPI_MAINDP_EN_GET(val) (val & 0x00000001)
#define BF_HB3_90BW_EN_INFO 0x00000201
#define BF_HB3_90BW_EN(val) ((val & 0x00000003) << 0x00000001)
#define BF_HB3_90BW_EN_GET(val) ((val >> 0x00000001) & 0x00000003)
#define BF_DAC_MAINDP_EN_INFO 0x00000404
#define BF_DAC_MAINDP_EN(val) ((val & 0x0000000F) << 0x00000004)
#define BF_DAC_MAINDP_EN_GET(val) ((val >> 0x00000004) & 0x0000000F)

#define REG_TXEN_ROUTE_CTRL_ADDR 0x000001F1
#define BF_TXEN_ROUTE_CTRL_INFO 0x00000800
#define BF_TXEN_ROUTE_CTRL(val) (val & 0x000000FF)
#define BF_TXEN_ROUTE_CTRL_GET(val) (val & 0x000000FF)

#define REG_TX_ENABLE0_ADDR 0x000001F2
#define BF_EN_TXEN_FLEXIBLE_ROUTE_INFO 0x00000104
#define BF_EN_TXEN_FLEXIBLE_ROUTE(val) ((val & 0x00000001) << 0x00000004)
#define BF_EN_TXEN_FLEXIBLE_ROUTE_GET(val) ((val >> 0x00000004) & 0x00000001)

#define REG_JRX_LINK_MAINDP_MAP_ADDR 0x000001F4
#define BF_EN_JRX_LINK_FLEXIBLE_ROUTE_INFO 0x00000100
#define BF_EN_JRX_LINK_FLEXIBLE_ROUTE(val) (val & 0x00000001)
#define BF_EN_JRX_LINK_FLEXIBLE_ROUTE_GET(val) (val & 0x00000001)
#define BF_JRX_LINK_MAINDP_CTRL_INFO 0x00000401
#define BF_JRX_LINK_MAINDP_CTRL(val) ((val & 0x0000000F) << 0x00000001)
#define BF_JRX_LINK_MAINDP_CTRL_GET(val) ((val >> 0x00000001) & 0x0000000F)

#define REG_MAIN_NCO_SYNC_ADDR 0x000001F6
#define BF_NCO_SYNC_MAIN_SEL_INFO 0x00000800
#define BF_NCO_SYNC_MAIN_SEL(val) (val & 0x000000FF)
#define BF_NCO_SYNC_MAIN_SEL_GET(val) (val & 0x000000FF)

#define REG_DATAPATH_NCO_SYNC_CFG_ADDR 0x000001FB
#define BF_START_NCO_SYNC_INFO 0x00000100
#define BF_START_NCO_SYNC(val) (val & 0x00000001)
#define BF_START_NCO_SYNC_GET(val) (val & 0x00000001)
#define BF_ALL_NCO_SYNC_ACK_INFO 0x00000101
#define BF_ALL_NCO_SYNC_ACK(val) ((val & 0x00000001) << 0x00000001)
#define BF_ALL_NCO_SYNC_ACK_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_LO_MODE_ENABLE_INFO 0x00000102
#define BF_LO_MODE_ENABLE(val) ((val & 0x00000001) << 0x00000002)
#define BF_LO_MODE_ENABLE_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_EN_SYNC_ALL_CHNL_NCO_RESETS_INFO 0x00000103
#define BF_EN_SYNC_ALL_CHNL_NCO_RESETS(val) ((val & 0x00000001) << 0x00000003)
#define BF_EN_SYNC_ALL_CHNL_NCO_RESETS_GET(val) \
	((val >> 0x00000003) & 0x00000001)

#define REG_JESD_MODE_ADDR 0x000001FE
#define BF_TX_JESD_MODE_INFO 0x00000600
#define BF_TX_JESD_MODE(val) (val & 0x0000003F)
#define BF_TX_JESD_MODE_GET(val) (val & 0x0000003F)
#define BF_COM_SYNC_INFO 0x00000106
#define BF_COM_SYNC(val) ((val & 0x00000001) << 0x00000006)
#define BF_COM_SYNC_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_MODE_NOT_IN_TABLE_INFO 0x00000107
#define BF_MODE_NOT_IN_TABLE(val) ((val & 0x00000001) << 0x00000007)
#define BF_MODE_NOT_IN_TABLE_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_INTRP_MODE_ADDR 0x000001FF
#define BF_COARSE_INTERP_SEL_INFO 0x00000400
#define BF_COARSE_INTERP_SEL(val) (val & 0x0000000F)
#define BF_COARSE_INTERP_SEL_GET(val) (val & 0x0000000F)
#define BF_FINE_INTERP_SEL_INFO 0x00000404
#define BF_FINE_INTERP_SEL(val) ((val & 0x0000000F) << 0x00000004)
#define BF_FINE_INTERP_SEL_GET(val) ((val >> 0x00000004) & 0x0000000F)

#define REG_INTRP_MODE_TODEC_ADDR 0x00000200
#define BF_CH_INTERP_MODE2DEC_INFO 0x00000300
#define BF_CH_INTERP_MODE2DEC(val) (val & 0x00000007)
#define BF_CH_INTERP_MODE2DEC_GET(val) (val & 0x00000007)
#define BF_DP_INTERP_MODE2DEC_INFO 0x00000303
#define BF_DP_INTERP_MODE2DEC(val) ((val & 0x00000007) << 0x00000003)
#define BF_DP_INTERP_MODE2DEC_GET(val) ((val >> 0x00000003) & 0x00000007)

#define REG_DIG_RESET_ADDR 0x00000201
#define BF_DIG_RESET_INFO 0x00000100
#define BF_DIG_RESET(val) (val & 0x00000001)
#define BF_DIG_RESET_GET(val) (val & 0x00000001)

#define REG_MAIN_NCO_RST_EN_ADDR 0x00000203
#define BF_SPI_MAIN_NCO_RST_EN_INFO 0x00000400
#define BF_SPI_MAIN_NCO_RST_EN(val) (val & 0x0000000F)
#define BF_SPI_MAIN_NCO_RST_EN_GET(val) (val & 0x0000000F)

#define REG_CHNL_NCO_RST_EN_ADDR 0x00000204
#define BF_SPI_CHNL_NCO_RST_EN_INFO 0x00000800
#define BF_SPI_CHNL_NCO_RST_EN(val) (val & 0x000000FF)
#define BF_SPI_CHNL_NCO_RST_EN_GET(val) (val & 0x000000FF)

#define REG_BE_SOFT_OFF_GAIN_CTRL_ADDR 0x00000300
#define BF_BE_GAIN_RAMP_RATE_INFO 0x00000300
#define BF_BE_GAIN_RAMP_RATE(val) (val & 0x00000007)
#define BF_BE_GAIN_RAMP_RATE_GET(val) (val & 0x00000007)
#define BF_BE_SOFT_OFF_GAIN_EN_INFO 0x00000107
#define BF_BE_SOFT_OFF_GAIN_EN(val) ((val & 0x00000001) << 0x00000007)
#define BF_BE_SOFT_OFF_GAIN_EN_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_BE_SOFT_OFF_ENABLE0_ADDR 0x00000301
#define BF_SPI_SOFT_OFF_EN_INFO 0x00000100
#define BF_SPI_SOFT_OFF_EN(val) (val & 0x00000001)
#define BF_SPI_SOFT_OFF_EN_GET(val) (val & 0x00000001)
#define BF_TXEN_SOFT_OFF_EN_INFO 0x00000101
#define BF_TXEN_SOFT_OFF_EN(val) ((val & 0x00000001) << 0x00000001)
#define BF_TXEN_SOFT_OFF_EN_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_ROTATE_SOFT_OFF_EN_INFO 0x00000102
#define BF_ROTATE_SOFT_OFF_EN(val) ((val & 0x00000001) << 0x00000002)
#define BF_ROTATE_SOFT_OFF_EN_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_ENA_JESD_ERR_SOFTOFF_INFO 0x00000103
#define BF_ENA_JESD_ERR_SOFTOFF(val) ((val & 0x00000001) << 0x00000003)
#define BF_ENA_JESD_ERR_SOFTOFF_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_ENA_LONG_PAERR_SOFTOFF_INFO 0x00000106
#define BF_ENA_LONG_PAERR_SOFTOFF(val) ((val & 0x00000001) << 0x00000006)
#define BF_ENA_LONG_PAERR_SOFTOFF_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_ENA_SHORT_PAERR_SOFTOFF_INFO 0x00000107
#define BF_ENA_SHORT_PAERR_SOFTOFF(val) ((val & 0x00000001) << 0x00000007)
#define BF_ENA_SHORT_PAERR_SOFTOFF_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_BE_SOFT_OFF_ENABLE1_ADDR 0x00000302
#define BF_ENA_DLL_UNLOCK_SOFTOFF_INFO 0x00000100
#define BF_ENA_DLL_UNLOCK_SOFTOFF(val) (val & 0x00000001)
#define BF_ENA_DLL_UNLOCK_SOFTOFF_GET(val) (val & 0x00000001)
#define BF_ENA_204C_CRCERR_SOFTOFF_INFO 0x00000101
#define BF_ENA_204C_CRCERR_SOFTOFF(val) ((val & 0x00000001) << 0x00000001)
#define BF_ENA_204C_CRCERR_SOFTOFF_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_HI_LO_FAIL_SOFT_OFF_EN_INFO 0x00000103
#define BF_HI_LO_FAIL_SOFT_OFF_EN(val) ((val & 0x00000001) << 0x00000003)
#define BF_HI_LO_FAIL_SOFT_OFF_EN_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_ENA_SRERR_SOFTOFF_INFO 0x00000104
#define BF_ENA_SRERR_SOFTOFF(val) ((val & 0x00000001) << 0x00000004)
#define BF_ENA_SRERR_SOFTOFF_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_ENA_PLL_FAST_SLOW_SOFTOFF_INFO 0x00000105 /* r2 */
#define BF_ENA_PLL_SLOW_SOFTOFF_INFO 0x00000106 /* r2 */
#define BF_ENA_SYNC_IRQ_SOFTOFF_INFO 0x00000107 /* r2 */

#define REG_BE_SOFT_ON_ENABLE_ADDR 0x00000303
#define BF_HI_LO_RECV_SOFT_ON_EN_INFO 0x00000104
#define BF_HI_LO_RECV_SOFT_ON_EN(val) ((val & 0x00000001) << 0x00000004)
#define BF_HI_LO_RECV_SOFT_ON_EN_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_LONG_LEVEL_SOFTON_EN_INFO 0x00000106
#define BF_LONG_LEVEL_SOFTON_EN(val) ((val & 0x00000001) << 0x00000006)
#define BF_LONG_LEVEL_SOFTON_EN_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_SPI_SOFT_ON_EN_INFO 0x00000107
#define BF_SPI_SOFT_ON_EN(val) ((val & 0x00000001) << 0x00000007)
#define BF_SPI_SOFT_ON_EN_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_PA_COMMON_CTRL_ADDR 0x00000304
#define BF_SHORT_PA_ALL_ENABLE_INFO 0x00000100
#define BF_SHORT_PA_ALL_ENABLE(val) (val & 0x00000001)
#define BF_SHORT_PA_ALL_ENABLE_GET(val) (val & 0x00000001)
#define BF_LONG_PA_ALL_ENABLE_INFO 0x00000101
#define BF_LONG_PA_ALL_ENABLE(val) ((val & 0x00000001) << 0x00000001)
#define BF_LONG_PA_ALL_ENABLE_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_SOFT_OFF_GAIN_ALL_ENABLE_INFO 0x00000102
#define BF_SOFT_OFF_GAIN_ALL_ENABLE(val) ((val & 0x00000001) << 0x00000002)
#define BF_SOFT_OFF_GAIN_ALL_ENABLE_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_PAP_ERR_SELF_CLR_EN_INFO 0x00000103 /* r2 */
#define BF_NEW_SOFT_OFF_SCHEME_INFO 0x00000104 /* r2 */
#define BF_NEW_SOFT_ON_SCHEME_INFO 0x00000105 /* r2 */

#define REG_LONG_PA_THRES_LSB_ADDR 0x00000305
#define BF_LONG_PA_THRESHOLD_INFO 0x00000D00
#define BF_LONG_PA_THRESHOLD(val) (val & 0x00001FFF)
#define BF_LONG_PA_THRESHOLD_GET(val) (val & 0x00001FFF)

#define REG_LONG_PA_THRES_MSB_ADDR 0x00000306

#define REG_LONG_PA_CONTROL_ADDR 0x00000307
#define BF_LONG_PA_AVG_TIME_INFO 0x00000400
#define BF_LONG_PA_AVG_TIME(val) (val & 0x0000000F)
#define BF_LONG_PA_AVG_TIME_GET(val) (val & 0x0000000F)
#define BF_LONG_PA_ENABLE_INFO 0x00000107
#define BF_LONG_PA_ENABLE(val) ((val & 0x00000001) << 0x00000007)
#define BF_LONG_PA_ENABLE_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_LONG_PA_POWER_LSB_ADDR 0x00000308
#define BF_LONG_PA_POWER_INFO 0x00000D00
#define BF_LONG_PA_POWER(val) (val & 0x00001FFF)
#define BF_LONG_PA_POWER_GET(val) (val & 0x00001FFF)

#define REG_LONG_PA_POWER_MSB_ADDR 0x00000309
#define BF_LONG_PA_POWER_STB_INFO 0x00000107 /* r2 */

#define REG_SHORT_PA_THRES_LSB_ADDR 0x0000030A
#define BF_SHORT_PA_THRESHOLD_INFO 0x00000D00
#define BF_SHORT_PA_THRESHOLD(val) (val & 0x00001FFF)
#define BF_SHORT_PA_THRESHOLD_GET(val) (val & 0x00001FFF)

#define REG_SHORT_PA_THRES_MSB_ADDR 0x0000030B

#define REG_SHORT_PA_CONTROL_ADDR 0x0000030C
#define BF_SHORT_PA_AVG_TIME_INFO 0x00000200
#define BF_SHORT_PA_AVG_TIME(val) (val & 0x00000003)
#define BF_SHORT_PA_AVG_TIME_GET(val) (val & 0x00000003)
#define BF_SHORT_PA_ENABLE_INFO 0x00000107
#define BF_SHORT_PA_ENABLE(val) ((val & 0x00000001) << 0x00000007)
#define BF_SHORT_PA_ENABLE_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_SHORT_PA_POWER_LSB_ADDR 0x0000030D
#define BF_SHORT_PA_POWER_INFO 0x00000D00
#define BF_SHORT_PA_POWER(val) (val & 0x00001FFF)
#define BF_SHORT_PA_POWER_GET(val) (val & 0x00001FFF)

#define REG_SHORT_PA_POWER_MSB_ADDR 0x0000030E
#define BF_SHORT_PA_POWER_STB_INFO 0x00000107 /* r2 */

#define REG_TXEN_SM_0_ADDR 0x0000030F
#define BF_ENA_TXENSM_INFO 0x00000100
#define BF_ENA_TXENSM(val) (val & 0x00000001)
#define BF_ENA_TXENSM_GET(val) (val & 0x00000001)

#define REG_PA_PROT_PIN_CTRL0_ADDR 0x0000031F
#define BF_SPI_PA_CTRL_INFO 0x00000100
#define BF_SPI_PA_CTRL(val) (val & 0x00000001)
#define BF_SPI_PA_CTRL_GET(val) (val & 0x00000001)
#define BF_ENA_PAPROT_PIN_TXENSM_INFO 0x00000101
#define BF_ENA_PAPROT_PIN_TXENSM(val) ((val & 0x00000001) << 0x00000001)
#define BF_ENA_PAPROT_PIN_TXENSM_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_ENA_PAPROT_PIN_BLSM_INFO 0x00000102
#define BF_ENA_PAPROT_PIN_BLSM(val) ((val & 0x00000001) << 0x00000002)
#define BF_ENA_PAPROT_PIN_BLSM_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_ENA_PAPROT_PIN_JESD_ERRORS_INFO 0x00000103
#define BF_ENA_PAPROT_PIN_JESD_ERRORS(val) ((val & 0x00000001) << 0x00000003)
#define BF_ENA_PAPROT_PIN_JESD_ERRORS_GET(val) \
	((val >> 0x00000003) & 0x00000001)
#define BF_ENA_PAPROT_PIN_JRX_204C_CRC_ERR_INFO 0x00000104
#define BF_ENA_PAPROT_PIN_JRX_204C_CRC_ERR(val) \
	((val & 0x00000001) << 0x00000004)
#define BF_ENA_PAPROT_PIN_JRX_204C_CRC_ERR_GET(val) \
	((val >> 0x00000004) & 0x00000001)
#define BF_ENA_LONG_PAPROT_PIN_AVGPOW_INFO 0x00000105
#define BF_ENA_LONG_PAPROT_PIN_AVGPOW(val) ((val & 0x00000001) << 0x00000005)
#define BF_ENA_LONG_PAPROT_PIN_AVGPOW_GET(val) \
	((val >> 0x00000005) & 0x00000001)
#define BF_ENA_SHORT_PAPROT_PIN_AVGPOW_INFO 0x00000106
#define BF_ENA_SHORT_PAPROT_PIN_AVGPOW(val) ((val & 0x00000001) << 0x00000006)
#define BF_ENA_SHORT_PAPROT_PIN_AVGPOW_GET(val) \
	((val >> 0x00000006) & 0x00000001)
#define BF_ENA_PAPROT_PIN_DLL_UNLOCK_INFO 0x00000107
#define BF_ENA_PAPROT_PIN_DLL_UNLOCK(val) ((val & 0x00000001) << 0x00000007)
#define BF_ENA_PAPROT_PIN_DLL_UNLOCK_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_PA_PROT_PIN_CTRL1_ADDR 0x00000320
#define BF_ENA_PAPROT_PIN_DLL_VTH_FAIL_INFO 0x00000100
#define BF_ENA_PAPROT_PIN_DLL_VTH_FAIL(val) (val & 0x00000001)
#define BF_ENA_PAPROT_PIN_DLL_VTH_FAIL_GET(val) (val & 0x00000001)
#define BF_ENA_PAPROT_PIN_DLL_VTH_PASS_INFO 0x00000101
#define BF_ENA_PAPROT_PIN_DLL_VTH_PASS(val) ((val & 0x00000001) << 0x00000001)
#define BF_ENA_PAPROT_PIN_DLL_VTH_PASS_GET(val) \
	((val >> 0x00000001) & 0x00000001)
#define BF_ENA_PAPROT_PIN_SRERR_INFO 0x00000102
#define BF_ENA_PAPROT_PIN_SRERR(val) ((val & 0x00000001) << 0x00000002)
#define BF_ENA_PAPROT_PIN_SRERR_GET(val) ((val >> 0x00000002) & 0x00000001)

#define REG_BLANKING_CTRL_ADDR 0x00000321
#define BF_ENA_SPI_TXEN_INFO 0x00000102
#define BF_ENA_SPI_TXEN(val) ((val & 0x00000001) << 0x00000002)
#define BF_ENA_SPI_TXEN_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_SPI_TXEN_INFO 0x00000103
#define BF_SPI_TXEN(val) ((val & 0x00000001) << 0x00000003)
#define BF_SPI_TXEN_GET(val) ((val >> 0x00000003) & 0x00000001)

#define REG_TXEN_FLUSH_CTRL0_ADDR 0x00000322
#define BF_SPI_FLUSH_EN_INFO 0x00000100
#define BF_SPI_FLUSH_EN(val) (val & 0x00000001)
#define BF_SPI_FLUSH_EN_GET(val) (val & 0x00000001)
#define BF_WAIT_CNT_INFO 0x00000701 /* r2 */

#define REG_SLEW_RATE_CTRL_ADDR 0x00000324
#define BF_DELAY_RANGE_INFO 0x00000500 /* r1 */
#define BF_SLEW_RATE_PATH_SEL_INFO 0x00000300 /* r2 */
#define BF_SR_ERR_SELF_CLR_EN_INFO 0x00000106 /* r2 */
#define BF_SLEW_RATE_ENABLE_INFO 0x00000107

#define REG_SLEW_RATE_THRESHOLD0_ADDR_R1 0x00000326 /* r1 */
#define BF_SLEW_RATE_THRESHOLD_INFO_R1 0x00001B00 /* r1 */
#define REG_SLEW_RATE_THRESHOLD1_ADDR_R1 0x00000327 /* r1 */
#define REG_SLEW_RATE_THRESHOLD2_ADDR_R1 0x00000328 /* r1 */
#define REG_SLEW_RATE_THRESHOLD3_ADDR_R1 0x00000329 /* r1 */

#define REG_SLEW_RATE_DATA0_ADDR 0x0000032A /* r1 */
#define BF_SLEW_RATE_DATA_INFO 0x00001B00 /* r1 */
#define REG_SLEW_RATE_DATA1_ADDR 0x0000032B /* r1 */
#define REG_SLEW_RATE_DATA2_ADDR 0x0000032C /* r1 */
#define REG_SLEW_RATE_DATA3_ADDR 0x0000032D /* r1 */

#define REG_SLEW_RATE_THRESHOLD0_ADDR_R2 0x00000325 /* r2 */
#define BF_SLEW_RATE_THRESHOLD_INFO_R2 0x00001100 /* r2 */
#define REG_SLEW_RATE_THRESHOLD1_ADDR_R2 0x00000326 /* r2 */
#define REG_SLEW_RATE_THRESHOLD2_ADDR_R2 0x00000327 /* r2 */

#define REG_SLEW_RATE_DATA_I0_ADDR 0x00000328 /* r2 */
#define BF_SLEW_RATE_DATA_I_INFO 0x00001100 /* r2 */
#define REG_SLEW_RATE_DATA_I1_ADDR 0x00000329 /* r2 */
#define REG_SLEW_RATE_DATA_I2_ADDR 0x0000032A /* r2 */
#define BF_RD_STB_Q_INFO 0x00000105 /* r2 */
#define BF_RD_STB_I_INFO 0x00000106 /* r2 */
#define BF_RD_STB_I_Q_INFO 0x00000107 /* r2 */

#define REG_SLEW_RATE_DATA_Q0_ADDR 0x0000032B /* r2 */
#define BF_SLEW_RATE_DATA_Q_INFO 0x00001100 /* r2 */
#define REG_SLEW_RATE_DATA_Q1_ADDR 0x0000032C /* r2 */
#define REG_SLEW_RATE_DATA_Q2_ADDR 0x0000032D /* r2 */

#define REG_JRX_TPL_0_ADDR 0x000004A0
#define BF_JRX_TPL_USR_DATA_RDY_INFO 0x00000101
#define BF_JRX_TPL_USR_DATA_RDY(val) ((val & 0x00000001) << 0x00000001)
#define BF_JRX_TPL_USR_DATA_RDY_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_JRX_TPL_SYSREF_RCVD_INFO 0x00000102
#define BF_JRX_TPL_SYSREF_RCVD(val) ((val & 0x00000001) << 0x00000002)
#define BF_JRX_TPL_SYSREF_RCVD_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_JRX_TPL_SYSREF_N_SHOT_ENABLE_INFO 0x00000103
#define BF_JRX_TPL_SYSREF_N_SHOT_ENABLE(val) ((val & 0x00000001) << 0x00000003)
#define BF_JRX_TPL_SYSREF_N_SHOT_ENABLE_GET(val) \
	((val >> 0x00000003) & 0x00000001)
#define BF_JRX_TPL_SYSREF_N_SHOT_COUNT_INFO 0x00000404
#define BF_JRX_TPL_SYSREF_N_SHOT_COUNT(val) ((val & 0x0000000F) << 0x00000004)
#define BF_JRX_TPL_SYSREF_N_SHOT_COUNT_GET(val) \
	((val >> 0x00000004) & 0x0000000F)

#define REG_JRX_TPL_1_ADDR 0x000004A1
#define BF_JRX_TPL_SYSREF_IGNORE_WHEN_LINKED_INFO 0x00000102
#define BF_JRX_TPL_SYSREF_IGNORE_WHEN_LINKED(val) \
	((val & 0x00000001) << 0x00000002)
#define BF_JRX_TPL_SYSREF_IGNORE_WHEN_LINKED_GET(val) \
	((val >> 0x00000002) & 0x00000001)
#define BF_JRX_TPL_BUF_PROTECT_EN_INFO 0x00000106
#define BF_JRX_TPL_BUF_PROTECT_EN(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_TPL_BUF_PROTECT_EN_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_JRX_TPL_BUF_PROTECTION_INFO 0x00000107
#define BF_JRX_TPL_BUF_PROTECTION(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_TPL_BUF_PROTECTION_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_TPL_2_ADDR 0x000004A2
#define BF_JRX_TPL_BUF_FRAMES_INFO 0x00000800
#define BF_JRX_TPL_BUF_FRAMES(val) (val & 0x000000FF)
#define BF_JRX_TPL_BUF_FRAMES_GET(val) (val & 0x000000FF)

#define REG_JRX_TPL_3_ADDR 0x000004A3
#define BF_JRX_TPL_PHASE_ADJUST_INFO 0x00001000
#define BF_JRX_TPL_PHASE_ADJUST(val) (val & 0x0000FFFF)
#define BF_JRX_TPL_PHASE_ADJUST_GET(val) (val & 0x0000FFFF)

#define REG_JRX_TPL_4_ADDR 0x000004A4

#define REG_JRX_TPL_5_ADDR 0x000004A5
#define BF_JRX_TPL_PHASE_DIFF_INFO 0x00000800
#define BF_JRX_TPL_PHASE_DIFF(val) (val & 0x000000FF)
#define BF_JRX_TPL_PHASE_DIFF_GET(val) (val & 0x000000FF)

#define REG_JRX_L0_0_ADDR 0x000004A6
#define BF_JRX_DID_CFG_INFO 0x00000800
#define BF_JRX_DID_CFG(val) (val & 0x000000FF)
#define BF_JRX_DID_CFG_GET(val) (val & 0x000000FF)

#define REG_JRX_L0_2_ADDR 0x000004A8
#define BF_JRX_LID_CFG_INFO 0x00000500
#define BF_JRX_LID_CFG(val) (val & 0x0000001F)
#define BF_JRX_LID_CFG_GET(val) (val & 0x0000001F)

#define REG_JRX_L0_3_ADDR 0x000004A9
#define BF_JRX_DSCR_CFG_INFO 0x00000107
#define BF_JRX_DSCR_CFG(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DSCR_CFG_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_L0_7_ADDR 0x000004AD
#define BF_JRX_CS_CFG_INFO 0x00000206
#define BF_JRX_CS_CFG(val) ((val & 0x00000003) << 0x00000006)
#define BF_JRX_CS_CFG_GET(val) ((val >> 0x00000006) & 0x00000003)

#define REG_JRX_L0_8_ADDR 0x000004AE
#define BF_JRX_SUBCLASSV_CFG_INFO 0x00000305
#define BF_JRX_SUBCLASSV_CFG(val) ((val & 0x00000007) << 0x00000005)
#define BF_JRX_SUBCLASSV_CFG_GET(val) ((val >> 0x00000005) & 0x00000007)

#define REG_JRX_DL_204B_0_ADDR 0x000004BE
#define BF_JRX_DL_204B_AR_ECNTR_INFO 0x00000100
#define BF_JRX_DL_204B_AR_ECNTR(val) (val & 0x00000001)
#define BF_JRX_DL_204B_AR_ECNTR_GET(val) (val & 0x00000001)
#define BF_JRX_DL_204B_CHAR_REPL_DIS_INFO 0x00000102
#define BF_JRX_DL_204B_CHAR_REPL_DIS(val) ((val & 0x00000001) << 0x00000002)
#define BF_JRX_DL_204B_CHAR_REPL_DIS_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_JRX_DL_204B_ENA_RAMP_CHECK_INFO 0x00000103
#define BF_JRX_DL_204B_ENA_RAMP_CHECK(val) ((val & 0x00000001) << 0x00000003)
#define BF_JRX_DL_204B_ENA_RAMP_CHECK_GET(val) \
	((val >> 0x00000003) & 0x00000001)
#define BF_JRX_DL_204B_FCHK_N_INFO 0x00000104
#define BF_JRX_DL_204B_FCHK_N(val) ((val & 0x00000001) << 0x00000004)
#define BF_JRX_DL_204B_FCHK_N_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_JRX_DL_204B_ILS_MODE_INFO 0x00000106
#define BF_JRX_DL_204B_ILS_MODE(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_DL_204B_ILS_MODE_GET(val) ((val >> 0x00000006) & 0x00000001)

#define REG_JRX_DL_204B_1_ADDR 0x000004BF
#define BF_JRX_DL_204B_ETH_INFO 0x00000800
#define BF_JRX_DL_204B_ETH(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_ETH_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_2_ADDR 0x000004C0
#define BF_JRX_DL_204B_ENABLE_INFO 0x00000105
#define BF_JRX_DL_204B_ENABLE(val) ((val & 0x00000001) << 0x00000005)
#define BF_JRX_DL_204B_ENABLE_GET(val) ((val >> 0x00000005) & 0x00000001)

#define REG_JRX_DL_204B_3_ADDR 0x000004C1
#define BF_JRX_DL_204B_L0_RXCFG_0_INFO 0x00000800
#define BF_JRX_DL_204B_L0_RXCFG_0(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_L0_RXCFG_0_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_4_ADDR 0x000004C2
#define BF_JRX_DL_204B_L0_RXCFG_1_INFO 0x00000800
#define BF_JRX_DL_204B_L0_RXCFG_1(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_L0_RXCFG_1_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_5_ADDR 0x000004C3
#define BF_JRX_DL_204B_L0_RXCFG_2_INFO 0x00000800
#define BF_JRX_DL_204B_L0_RXCFG_2(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_L0_RXCFG_2_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_6_ADDR 0x000004C4
#define BF_JRX_DL_204B_L0_RXCFG_3_INFO 0x00000800
#define BF_JRX_DL_204B_L0_RXCFG_3(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_L0_RXCFG_3_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_7_ADDR 0x000004C5
#define BF_JRX_DL_204B_L0_RXCFG_4_INFO 0x00000800
#define BF_JRX_DL_204B_L0_RXCFG_4(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_L0_RXCFG_4_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_8_ADDR 0x000004C6
#define BF_JRX_DL_204B_L0_RXCFG_5_INFO 0x00000800
#define BF_JRX_DL_204B_L0_RXCFG_5(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_L0_RXCFG_5_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_9_ADDR 0x000004C7
#define BF_JRX_DL_204B_L0_RXCFG_6_INFO 0x00000800
#define BF_JRX_DL_204B_L0_RXCFG_6(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_L0_RXCFG_6_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_10_ADDR 0x000004C8
#define BF_JRX_DL_204B_L0_RXCFG_7_INFO 0x00000800
#define BF_JRX_DL_204B_L0_RXCFG_7(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_L0_RXCFG_7_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_11_ADDR 0x000004C9
#define BF_JRX_DL_204B_L0_RXCFG_8_INFO 0x00000800
#define BF_JRX_DL_204B_L0_RXCFG_8(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_L0_RXCFG_8_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_12_ADDR 0x000004CA
#define BF_JRX_DL_204B_L0_RXCFG_9_INFO 0x00000800
#define BF_JRX_DL_204B_L0_RXCFG_9(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_L0_RXCFG_9_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_13_ADDR 0x000004CB
#define BF_JRX_DL_204B_L0_RXCFG_10_INFO 0x00000800
#define BF_JRX_DL_204B_L0_RXCFG_10(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_L0_RXCFG_10_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_14_ADDR 0x000004CC
#define BF_JRX_DL_204B_L0_RXCFG_11_INFO 0x00000800
#define BF_JRX_DL_204B_L0_RXCFG_11(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_L0_RXCFG_11_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_15_ADDR 0x000004CD
#define BF_JRX_DL_204B_L0_RXCFG_12_INFO 0x00000800
#define BF_JRX_DL_204B_L0_RXCFG_12(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_L0_RXCFG_12_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_16_ADDR 0x000004CE
#define BF_JRX_DL_204B_L0_RXCFG_13_INFO 0x00000800
#define BF_JRX_DL_204B_L0_RXCFG_13(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_L0_RXCFG_13_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_17_LANE7_ADDR 0x000004D6
#define BF_JRX_DL_204B_ECNT_ENA_0_INFO 0x00000300
#define BF_JRX_DL_204B_ECNT_ENA_0(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_ENA_0_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_RST_0_INFO 0x00000304
#define BF_JRX_DL_204B_ECNT_RST_0(val) ((val & 0x00000007) << 0x00000004)
#define BF_JRX_DL_204B_ECNT_RST_0_GET(val) ((val >> 0x00000004) & 0x00000007)

#define REG_JRX_DL_204B_17_LANE6_ADDR 0x000004D5
#define BF_JRX_DL_204B_ECNT_ENA_1_INFO 0x00000300
#define BF_JRX_DL_204B_ECNT_ENA_1(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_ENA_1_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_RST_1_INFO 0x00000304
#define BF_JRX_DL_204B_ECNT_RST_1(val) ((val & 0x00000007) << 0x00000004)
#define BF_JRX_DL_204B_ECNT_RST_1_GET(val) ((val >> 0x00000004) & 0x00000007)

#define REG_JRX_DL_204B_17_LANE5_ADDR 0x000004D4
#define BF_JRX_DL_204B_ECNT_ENA_2_INFO 0x00000300
#define BF_JRX_DL_204B_ECNT_ENA_2(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_ENA_2_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_RST_2_INFO 0x00000304
#define BF_JRX_DL_204B_ECNT_RST_2(val) ((val & 0x00000007) << 0x00000004)
#define BF_JRX_DL_204B_ECNT_RST_2_GET(val) ((val >> 0x00000004) & 0x00000007)

#define REG_JRX_DL_204B_17_LANE4_ADDR 0x000004D3
#define BF_JRX_DL_204B_ECNT_ENA_3_INFO 0x00000300
#define BF_JRX_DL_204B_ECNT_ENA_3(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_ENA_3_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_RST_3_INFO 0x00000304
#define BF_JRX_DL_204B_ECNT_RST_3(val) ((val & 0x00000007) << 0x00000004)
#define BF_JRX_DL_204B_ECNT_RST_3_GET(val) ((val >> 0x00000004) & 0x00000007)

#define REG_JRX_DL_204B_17_LANE3_ADDR 0x000004D2
#define BF_JRX_DL_204B_ECNT_ENA_4_INFO 0x00000300
#define BF_JRX_DL_204B_ECNT_ENA_4(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_ENA_4_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_RST_4_INFO 0x00000304
#define BF_JRX_DL_204B_ECNT_RST_4(val) ((val & 0x00000007) << 0x00000004)
#define BF_JRX_DL_204B_ECNT_RST_4_GET(val) ((val >> 0x00000004) & 0x00000007)

#define REG_JRX_DL_204B_17_LANE2_ADDR 0x000004D1
#define BF_JRX_DL_204B_ECNT_ENA_5_INFO 0x00000300
#define BF_JRX_DL_204B_ECNT_ENA_5(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_ENA_5_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_RST_5_INFO 0x00000304
#define BF_JRX_DL_204B_ECNT_RST_5(val) ((val & 0x00000007) << 0x00000004)
#define BF_JRX_DL_204B_ECNT_RST_5_GET(val) ((val >> 0x00000004) & 0x00000007)

#define REG_JRX_DL_204B_17_LANE1_ADDR 0x000004D0
#define BF_JRX_DL_204B_ECNT_ENA_6_INFO 0x00000300
#define BF_JRX_DL_204B_ECNT_ENA_6(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_ENA_6_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_RST_6_INFO 0x00000304
#define BF_JRX_DL_204B_ECNT_RST_6(val) ((val & 0x00000007) << 0x00000004)
#define BF_JRX_DL_204B_ECNT_RST_6_GET(val) ((val >> 0x00000004) & 0x00000007)

#define REG_JRX_DL_204B_17_LANE0_ADDR 0x000004CF
#define BF_JRX_DL_204B_ECNT_ENA_7_INFO 0x00000300
#define BF_JRX_DL_204B_ECNT_ENA_7(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_ENA_7_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_RST_7_INFO 0x00000304
#define BF_JRX_DL_204B_ECNT_RST_7(val) ((val & 0x00000007) << 0x00000004)
#define BF_JRX_DL_204B_ECNT_RST_7_GET(val) ((val >> 0x00000004) & 0x00000007)

#define REG_JRX_DL_204B_18_LANE7_ADDR 0x000004E5
#define BF_JRX_DL_204B_ECNT_TCH_0_INFO 0x00000300
#define BF_JRX_DL_204B_ECNT_TCH_0(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_TCH_0_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_TCR_0_INFO 0x00000304
#define BF_JRX_DL_204B_ECNT_TCR_0(val) ((val & 0x00000007) << 0x00000004)
#define BF_JRX_DL_204B_ECNT_TCR_0_GET(val) ((val >> 0x00000004) & 0x00000007)

#define REG_JRX_DL_204B_18_LANE6_ADDR 0x000004E4
#define BF_JRX_DL_204B_ECNT_TCH_1_INFO 0x00000300
#define BF_JRX_DL_204B_ECNT_TCH_1(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_TCH_1_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_TCR_1_INFO 0x00000304
#define BF_JRX_DL_204B_ECNT_TCR_1(val) ((val & 0x00000007) << 0x00000004)
#define BF_JRX_DL_204B_ECNT_TCR_1_GET(val) ((val >> 0x00000004) & 0x00000007)

#define REG_JRX_DL_204B_18_LANE5_ADDR 0x000004E3
#define BF_JRX_DL_204B_ECNT_TCH_2_INFO 0x00000300
#define BF_JRX_DL_204B_ECNT_TCH_2(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_TCH_2_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_TCR_2_INFO 0x00000304
#define BF_JRX_DL_204B_ECNT_TCR_2(val) ((val & 0x00000007) << 0x00000004)
#define BF_JRX_DL_204B_ECNT_TCR_2_GET(val) ((val >> 0x00000004) & 0x00000007)

#define REG_JRX_DL_204B_18_LANE4_ADDR 0x000004E2
#define BF_JRX_DL_204B_ECNT_TCH_3_INFO 0x00000300
#define BF_JRX_DL_204B_ECNT_TCH_3(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_TCH_3_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_TCR_3_INFO 0x00000304
#define BF_JRX_DL_204B_ECNT_TCR_3(val) ((val & 0x00000007) << 0x00000004)
#define BF_JRX_DL_204B_ECNT_TCR_3_GET(val) ((val >> 0x00000004) & 0x00000007)

#define REG_JRX_DL_204B_18_LANE3_ADDR 0x000004E1
#define BF_JRX_DL_204B_ECNT_TCH_4_INFO 0x00000300
#define BF_JRX_DL_204B_ECNT_TCH_4(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_TCH_4_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_TCR_4_INFO 0x00000304
#define BF_JRX_DL_204B_ECNT_TCR_4(val) ((val & 0x00000007) << 0x00000004)
#define BF_JRX_DL_204B_ECNT_TCR_4_GET(val) ((val >> 0x00000004) & 0x00000007)

#define REG_JRX_DL_204B_18_LANE2_ADDR 0x000004E0
#define BF_JRX_DL_204B_ECNT_TCH_5_INFO 0x00000300
#define BF_JRX_DL_204B_ECNT_TCH_5(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_TCH_5_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_TCR_5_INFO 0x00000304
#define BF_JRX_DL_204B_ECNT_TCR_5(val) ((val & 0x00000007) << 0x00000004)
#define BF_JRX_DL_204B_ECNT_TCR_5_GET(val) ((val >> 0x00000004) & 0x00000007)

#define REG_JRX_DL_204B_18_LANE1_ADDR 0x000004DF
#define BF_JRX_DL_204B_ECNT_TCH_6_INFO 0x00000300
#define BF_JRX_DL_204B_ECNT_TCH_6(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_TCH_6_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_TCR_6_INFO 0x00000304
#define BF_JRX_DL_204B_ECNT_TCR_6(val) ((val & 0x00000007) << 0x00000004)
#define BF_JRX_DL_204B_ECNT_TCR_6_GET(val) ((val >> 0x00000004) & 0x00000007)

#define REG_JRX_DL_204B_18_LANE0_ADDR 0x000004DE
#define BF_JRX_DL_204B_ECNT_TCH_7_INFO 0x00000300
#define BF_JRX_DL_204B_ECNT_TCH_7(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_TCH_7_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204B_ECNT_TCR_7_INFO 0x00000304
#define BF_JRX_DL_204B_ECNT_TCR_7(val) ((val & 0x00000007) << 0x00000004)
#define BF_JRX_DL_204B_ECNT_TCR_7_GET(val) ((val >> 0x00000004) & 0x00000007)

#define REG_JRX_DL_204B_20_LANE7_ADDR 0x000004F5
#define BF_JRX_DL_204B_BDE_0_INFO 0x00000100
#define BF_JRX_DL_204B_BDE_0(val) (val & 0x00000001)
#define BF_JRX_DL_204B_BDE_0_GET(val) (val & 0x00000001)
#define BF_JRX_DL_204B_CGS_0_INFO 0x00000101
#define BF_JRX_DL_204B_CGS_0(val) ((val & 0x00000001) << 0x00000001)
#define BF_JRX_DL_204B_CGS_0_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_JRX_DL_204B_CKS_0_INFO 0x00000102
#define BF_JRX_DL_204B_CKS_0(val) ((val & 0x00000001) << 0x00000002)
#define BF_JRX_DL_204B_CKS_0_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_JRX_DL_204B_FS_0_INFO 0x00000103
#define BF_JRX_DL_204B_FS_0(val) ((val & 0x00000001) << 0x00000003)
#define BF_JRX_DL_204B_FS_0_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_JRX_DL_204B_ILD_0_INFO 0x00000104
#define BF_JRX_DL_204B_ILD_0(val) ((val & 0x00000001) << 0x00000004)
#define BF_JRX_DL_204B_ILD_0_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_JRX_DL_204B_ILS_0_INFO 0x00000105
#define BF_JRX_DL_204B_ILS_0(val) ((val & 0x00000001) << 0x00000005)
#define BF_JRX_DL_204B_ILS_0_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_JRX_DL_204B_NIT_0_INFO 0x00000106
#define BF_JRX_DL_204B_NIT_0(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_DL_204B_NIT_0_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_JRX_DL_204B_UEK_0_INFO 0x00000107
#define BF_JRX_DL_204B_UEK_0(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204B_UEK_0_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204B_20_LANE6_ADDR 0x000004F4
#define BF_JRX_DL_204B_BDE_1_INFO 0x00000100
#define BF_JRX_DL_204B_BDE_1(val) (val & 0x00000001)
#define BF_JRX_DL_204B_BDE_1_GET(val) (val & 0x00000001)
#define BF_JRX_DL_204B_CGS_1_INFO 0x00000101
#define BF_JRX_DL_204B_CGS_1(val) ((val & 0x00000001) << 0x00000001)
#define BF_JRX_DL_204B_CGS_1_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_JRX_DL_204B_CKS_1_INFO 0x00000102
#define BF_JRX_DL_204B_CKS_1(val) ((val & 0x00000001) << 0x00000002)
#define BF_JRX_DL_204B_CKS_1_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_JRX_DL_204B_FS_1_INFO 0x00000103
#define BF_JRX_DL_204B_FS_1(val) ((val & 0x00000001) << 0x00000003)
#define BF_JRX_DL_204B_FS_1_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_JRX_DL_204B_ILD_1_INFO 0x00000104
#define BF_JRX_DL_204B_ILD_1(val) ((val & 0x00000001) << 0x00000004)
#define BF_JRX_DL_204B_ILD_1_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_JRX_DL_204B_ILS_1_INFO 0x00000105
#define BF_JRX_DL_204B_ILS_1(val) ((val & 0x00000001) << 0x00000005)
#define BF_JRX_DL_204B_ILS_1_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_JRX_DL_204B_NIT_1_INFO 0x00000106
#define BF_JRX_DL_204B_NIT_1(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_DL_204B_NIT_1_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_JRX_DL_204B_UEK_1_INFO 0x00000107
#define BF_JRX_DL_204B_UEK_1(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204B_UEK_1_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204B_20_LANE5_ADDR 0x000004F3
#define BF_JRX_DL_204B_BDE_2_INFO 0x00000100
#define BF_JRX_DL_204B_BDE_2(val) (val & 0x00000001)
#define BF_JRX_DL_204B_BDE_2_GET(val) (val & 0x00000001)
#define BF_JRX_DL_204B_CGS_2_INFO 0x00000101
#define BF_JRX_DL_204B_CGS_2(val) ((val & 0x00000001) << 0x00000001)
#define BF_JRX_DL_204B_CGS_2_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_JRX_DL_204B_CKS_2_INFO 0x00000102
#define BF_JRX_DL_204B_CKS_2(val) ((val & 0x00000001) << 0x00000002)
#define BF_JRX_DL_204B_CKS_2_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_JRX_DL_204B_FS_2_INFO 0x00000103
#define BF_JRX_DL_204B_FS_2(val) ((val & 0x00000001) << 0x00000003)
#define BF_JRX_DL_204B_FS_2_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_JRX_DL_204B_ILD_2_INFO 0x00000104
#define BF_JRX_DL_204B_ILD_2(val) ((val & 0x00000001) << 0x00000004)
#define BF_JRX_DL_204B_ILD_2_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_JRX_DL_204B_ILS_2_INFO 0x00000105
#define BF_JRX_DL_204B_ILS_2(val) ((val & 0x00000001) << 0x00000005)
#define BF_JRX_DL_204B_ILS_2_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_JRX_DL_204B_NIT_2_INFO 0x00000106
#define BF_JRX_DL_204B_NIT_2(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_DL_204B_NIT_2_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_JRX_DL_204B_UEK_2_INFO 0x00000107
#define BF_JRX_DL_204B_UEK_2(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204B_UEK_2_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204B_20_LANE4_ADDR 0x000004F2
#define BF_JRX_DL_204B_BDE_3_INFO 0x00000100
#define BF_JRX_DL_204B_BDE_3(val) (val & 0x00000001)
#define BF_JRX_DL_204B_BDE_3_GET(val) (val & 0x00000001)
#define BF_JRX_DL_204B_CGS_3_INFO 0x00000101
#define BF_JRX_DL_204B_CGS_3(val) ((val & 0x00000001) << 0x00000001)
#define BF_JRX_DL_204B_CGS_3_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_JRX_DL_204B_CKS_3_INFO 0x00000102
#define BF_JRX_DL_204B_CKS_3(val) ((val & 0x00000001) << 0x00000002)
#define BF_JRX_DL_204B_CKS_3_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_JRX_DL_204B_FS_3_INFO 0x00000103
#define BF_JRX_DL_204B_FS_3(val) ((val & 0x00000001) << 0x00000003)
#define BF_JRX_DL_204B_FS_3_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_JRX_DL_204B_ILD_3_INFO 0x00000104
#define BF_JRX_DL_204B_ILD_3(val) ((val & 0x00000001) << 0x00000004)
#define BF_JRX_DL_204B_ILD_3_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_JRX_DL_204B_ILS_3_INFO 0x00000105
#define BF_JRX_DL_204B_ILS_3(val) ((val & 0x00000001) << 0x00000005)
#define BF_JRX_DL_204B_ILS_3_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_JRX_DL_204B_NIT_3_INFO 0x00000106
#define BF_JRX_DL_204B_NIT_3(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_DL_204B_NIT_3_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_JRX_DL_204B_UEK_3_INFO 0x00000107
#define BF_JRX_DL_204B_UEK_3(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204B_UEK_3_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204B_20_LANE3_ADDR 0x000004F1
#define BF_JRX_DL_204B_BDE_4_INFO 0x00000100
#define BF_JRX_DL_204B_BDE_4(val) (val & 0x00000001)
#define BF_JRX_DL_204B_BDE_4_GET(val) (val & 0x00000001)
#define BF_JRX_DL_204B_CGS_4_INFO 0x00000101
#define BF_JRX_DL_204B_CGS_4(val) ((val & 0x00000001) << 0x00000001)
#define BF_JRX_DL_204B_CGS_4_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_JRX_DL_204B_CKS_4_INFO 0x00000102
#define BF_JRX_DL_204B_CKS_4(val) ((val & 0x00000001) << 0x00000002)
#define BF_JRX_DL_204B_CKS_4_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_JRX_DL_204B_FS_4_INFO 0x00000103
#define BF_JRX_DL_204B_FS_4(val) ((val & 0x00000001) << 0x00000003)
#define BF_JRX_DL_204B_FS_4_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_JRX_DL_204B_ILD_4_INFO 0x00000104
#define BF_JRX_DL_204B_ILD_4(val) ((val & 0x00000001) << 0x00000004)
#define BF_JRX_DL_204B_ILD_4_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_JRX_DL_204B_ILS_4_INFO 0x00000105
#define BF_JRX_DL_204B_ILS_4(val) ((val & 0x00000001) << 0x00000005)
#define BF_JRX_DL_204B_ILS_4_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_JRX_DL_204B_NIT_4_INFO 0x00000106
#define BF_JRX_DL_204B_NIT_4(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_DL_204B_NIT_4_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_JRX_DL_204B_UEK_4_INFO 0x00000107
#define BF_JRX_DL_204B_UEK_4(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204B_UEK_4_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204B_20_LANE2_ADDR 0x000004F0
#define BF_JRX_DL_204B_BDE_5_INFO 0x00000100
#define BF_JRX_DL_204B_BDE_5(val) (val & 0x00000001)
#define BF_JRX_DL_204B_BDE_5_GET(val) (val & 0x00000001)
#define BF_JRX_DL_204B_CGS_5_INFO 0x00000101
#define BF_JRX_DL_204B_CGS_5(val) ((val & 0x00000001) << 0x00000001)
#define BF_JRX_DL_204B_CGS_5_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_JRX_DL_204B_CKS_5_INFO 0x00000102
#define BF_JRX_DL_204B_CKS_5(val) ((val & 0x00000001) << 0x00000002)
#define BF_JRX_DL_204B_CKS_5_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_JRX_DL_204B_FS_5_INFO 0x00000103
#define BF_JRX_DL_204B_FS_5(val) ((val & 0x00000001) << 0x00000003)
#define BF_JRX_DL_204B_FS_5_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_JRX_DL_204B_ILD_5_INFO 0x00000104
#define BF_JRX_DL_204B_ILD_5(val) ((val & 0x00000001) << 0x00000004)
#define BF_JRX_DL_204B_ILD_5_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_JRX_DL_204B_ILS_5_INFO 0x00000105
#define BF_JRX_DL_204B_ILS_5(val) ((val & 0x00000001) << 0x00000005)
#define BF_JRX_DL_204B_ILS_5_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_JRX_DL_204B_NIT_5_INFO 0x00000106
#define BF_JRX_DL_204B_NIT_5(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_DL_204B_NIT_5_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_JRX_DL_204B_UEK_5_INFO 0x00000107
#define BF_JRX_DL_204B_UEK_5(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204B_UEK_5_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204B_20_LANE1_ADDR 0x000004EF
#define BF_JRX_DL_204B_BDE_6_INFO 0x00000100
#define BF_JRX_DL_204B_BDE_6(val) (val & 0x00000001)
#define BF_JRX_DL_204B_BDE_6_GET(val) (val & 0x00000001)
#define BF_JRX_DL_204B_CGS_6_INFO 0x00000101
#define BF_JRX_DL_204B_CGS_6(val) ((val & 0x00000001) << 0x00000001)
#define BF_JRX_DL_204B_CGS_6_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_JRX_DL_204B_CKS_6_INFO 0x00000102
#define BF_JRX_DL_204B_CKS_6(val) ((val & 0x00000001) << 0x00000002)
#define BF_JRX_DL_204B_CKS_6_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_JRX_DL_204B_FS_6_INFO 0x00000103
#define BF_JRX_DL_204B_FS_6(val) ((val & 0x00000001) << 0x00000003)
#define BF_JRX_DL_204B_FS_6_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_JRX_DL_204B_ILD_6_INFO 0x00000104
#define BF_JRX_DL_204B_ILD_6(val) ((val & 0x00000001) << 0x00000004)
#define BF_JRX_DL_204B_ILD_6_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_JRX_DL_204B_ILS_6_INFO 0x00000105
#define BF_JRX_DL_204B_ILS_6(val) ((val & 0x00000001) << 0x00000005)
#define BF_JRX_DL_204B_ILS_6_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_JRX_DL_204B_NIT_6_INFO 0x00000106
#define BF_JRX_DL_204B_NIT_6(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_DL_204B_NIT_6_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_JRX_DL_204B_UEK_6_INFO 0x00000107
#define BF_JRX_DL_204B_UEK_6(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204B_UEK_6_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204B_20_LANE0_ADDR 0x000004EE
#define BF_JRX_DL_204B_BDE_7_INFO 0x00000100
#define BF_JRX_DL_204B_BDE_7(val) (val & 0x00000001)
#define BF_JRX_DL_204B_BDE_7_GET(val) (val & 0x00000001)
#define BF_JRX_DL_204B_CGS_7_INFO 0x00000101
#define BF_JRX_DL_204B_CGS_7(val) ((val & 0x00000001) << 0x00000001)
#define BF_JRX_DL_204B_CGS_7_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_JRX_DL_204B_CKS_7_INFO 0x00000102
#define BF_JRX_DL_204B_CKS_7(val) ((val & 0x00000001) << 0x00000002)
#define BF_JRX_DL_204B_CKS_7_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_JRX_DL_204B_FS_7_INFO 0x00000103
#define BF_JRX_DL_204B_FS_7(val) ((val & 0x00000001) << 0x00000003)
#define BF_JRX_DL_204B_FS_7_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_JRX_DL_204B_ILD_7_INFO 0x00000104
#define BF_JRX_DL_204B_ILD_7(val) ((val & 0x00000001) << 0x00000004)
#define BF_JRX_DL_204B_ILD_7_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_JRX_DL_204B_ILS_7_INFO 0x00000105
#define BF_JRX_DL_204B_ILS_7(val) ((val & 0x00000001) << 0x00000005)
#define BF_JRX_DL_204B_ILS_7_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_JRX_DL_204B_NIT_7_INFO 0x00000106
#define BF_JRX_DL_204B_NIT_7(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_DL_204B_NIT_7_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_JRX_DL_204B_UEK_7_INFO 0x00000107
#define BF_JRX_DL_204B_UEK_7(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204B_UEK_7_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204B_19_LANE7_ADDR 0x00000505
#define BF_JRX_DL_204B_BD_CNT_0_INFO 0x00000800
#define BF_JRX_DL_204B_BD_CNT_0(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_BD_CNT_0_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_19_LANE6_ADDR 0x00000504
#define BF_JRX_DL_204B_BD_CNT_1_INFO 0x00000800
#define BF_JRX_DL_204B_BD_CNT_1(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_BD_CNT_1_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_19_LANE5_ADDR 0x00000503
#define BF_JRX_DL_204B_BD_CNT_2_INFO 0x00000800
#define BF_JRX_DL_204B_BD_CNT_2(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_BD_CNT_2_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_19_LANE4_ADDR 0x00000502
#define BF_JRX_DL_204B_BD_CNT_3_INFO 0x00000800
#define BF_JRX_DL_204B_BD_CNT_3(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_BD_CNT_3_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_19_LANE3_ADDR 0x00000501
#define BF_JRX_DL_204B_BD_CNT_4_INFO 0x00000800
#define BF_JRX_DL_204B_BD_CNT_4(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_BD_CNT_4_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_19_LANE2_ADDR 0x00000500
#define BF_JRX_DL_204B_BD_CNT_5_INFO 0x00000800
#define BF_JRX_DL_204B_BD_CNT_5(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_BD_CNT_5_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_19_LANE1_ADDR 0x000004FF
#define BF_JRX_DL_204B_BD_CNT_6_INFO 0x00000800
#define BF_JRX_DL_204B_BD_CNT_6(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_BD_CNT_6_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_19_LANE0_ADDR 0x000004FE
#define BF_JRX_DL_204B_BD_CNT_7_INFO 0x00000800
#define BF_JRX_DL_204B_BD_CNT_7(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_BD_CNT_7_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_21_LANE7_ADDR 0x00000515
#define BF_JRX_DL_204B_UEK_CNT_0_INFO 0x00000800
#define BF_JRX_DL_204B_UEK_CNT_0(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_UEK_CNT_0_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_21_LANE6_ADDR 0x00000514
#define BF_JRX_DL_204B_UEK_CNT_1_INFO 0x00000800
#define BF_JRX_DL_204B_UEK_CNT_1(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_UEK_CNT_1_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_21_LANE5_ADDR 0x00000513
#define BF_JRX_DL_204B_UEK_CNT_2_INFO 0x00000800
#define BF_JRX_DL_204B_UEK_CNT_2(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_UEK_CNT_2_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_21_LANE4_ADDR 0x00000512
#define BF_JRX_DL_204B_UEK_CNT_3_INFO 0x00000800
#define BF_JRX_DL_204B_UEK_CNT_3(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_UEK_CNT_3_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_21_LANE3_ADDR 0x00000511
#define BF_JRX_DL_204B_UEK_CNT_4_INFO 0x00000800
#define BF_JRX_DL_204B_UEK_CNT_4(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_UEK_CNT_4_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_21_LANE2_ADDR 0x00000510
#define BF_JRX_DL_204B_UEK_CNT_5_INFO 0x00000800
#define BF_JRX_DL_204B_UEK_CNT_5(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_UEK_CNT_5_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_21_LANE1_ADDR 0x0000050F
#define BF_JRX_DL_204B_UEK_CNT_6_INFO 0x00000800
#define BF_JRX_DL_204B_UEK_CNT_6(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_UEK_CNT_6_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_21_LANE0_ADDR 0x0000050E
#define BF_JRX_DL_204B_UEK_CNT_7_INFO 0x00000800
#define BF_JRX_DL_204B_UEK_CNT_7(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_UEK_CNT_7_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_23_LANE7_ADDR 0x00000535
#define BF_JRX_DL_204B_LL_FCHK_0_INFO 0x00000800
#define BF_JRX_DL_204B_LL_FCHK_0(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_LL_FCHK_0_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_23_LANE6_ADDR 0x00000534
#define BF_JRX_DL_204B_LL_FCHK_1_INFO 0x00000800
#define BF_JRX_DL_204B_LL_FCHK_1(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_LL_FCHK_1_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_23_LANE5_ADDR 0x00000533
#define BF_JRX_DL_204B_LL_FCHK_2_INFO 0x00000800
#define BF_JRX_DL_204B_LL_FCHK_2(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_LL_FCHK_2_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_23_LANE4_ADDR 0x00000532
#define BF_JRX_DL_204B_LL_FCHK_3_INFO 0x00000800
#define BF_JRX_DL_204B_LL_FCHK_3(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_LL_FCHK_3_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_23_LANE3_ADDR 0x00000531
#define BF_JRX_DL_204B_LL_FCHK_4_INFO 0x00000800
#define BF_JRX_DL_204B_LL_FCHK_4(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_LL_FCHK_4_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_23_LANE2_ADDR 0x00000530
#define BF_JRX_DL_204B_LL_FCHK_5_INFO 0x00000800
#define BF_JRX_DL_204B_LL_FCHK_5(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_LL_FCHK_5_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_23_LANE1_ADDR 0x0000052F
#define BF_JRX_DL_204B_LL_FCHK_6_INFO 0x00000800
#define BF_JRX_DL_204B_LL_FCHK_6(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_LL_FCHK_6_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_23_LANE0_ADDR 0x0000052E
#define BF_JRX_DL_204B_LL_FCHK_7_INFO 0x00000800
#define BF_JRX_DL_204B_LL_FCHK_7(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_LL_FCHK_7_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_24_LANE7_ADDR 0x00000545
#define BF_JRX_DL_204B_LL_FCMP_0_INFO 0x00000800
#define BF_JRX_DL_204B_LL_FCMP_0(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_LL_FCMP_0_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_24_LANE6_ADDR 0x00000544
#define BF_JRX_DL_204B_LL_FCMP_1_INFO 0x00000800
#define BF_JRX_DL_204B_LL_FCMP_1(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_LL_FCMP_1_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_24_LANE5_ADDR 0x00000543
#define BF_JRX_DL_204B_LL_FCMP_2_INFO 0x00000800
#define BF_JRX_DL_204B_LL_FCMP_2(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_LL_FCMP_2_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_24_LANE4_ADDR 0x00000542
#define BF_JRX_DL_204B_LL_FCMP_3_INFO 0x00000800
#define BF_JRX_DL_204B_LL_FCMP_3(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_LL_FCMP_3_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_24_LANE3_ADDR 0x00000541
#define BF_JRX_DL_204B_LL_FCMP_4_INFO 0x00000800
#define BF_JRX_DL_204B_LL_FCMP_4(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_LL_FCMP_4_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_24_LANE2_ADDR 0x00000540
#define BF_JRX_DL_204B_LL_FCMP_5_INFO 0x00000800
#define BF_JRX_DL_204B_LL_FCMP_5(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_LL_FCMP_5_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_24_LANE1_ADDR 0x0000053F
#define BF_JRX_DL_204B_LL_FCMP_6_INFO 0x00000800
#define BF_JRX_DL_204B_LL_FCMP_6(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_LL_FCMP_6_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_24_LANE0_ADDR 0x0000053E
#define BF_JRX_DL_204B_LL_FCMP_7_INFO 0x00000800
#define BF_JRX_DL_204B_LL_FCMP_7(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_LL_FCMP_7_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_25_LANE7_ADDR 0x00000555
#define BF_JRX_DL_204B_LL_LID_0_INFO 0x00000500
#define BF_JRX_DL_204B_LL_LID_0(val) (val & 0x0000001F)
#define BF_JRX_DL_204B_LL_LID_0_GET(val) (val & 0x0000001F)

#define REG_JRX_DL_204B_25_LANE6_ADDR 0x00000554
#define BF_JRX_DL_204B_LL_LID_1_INFO 0x00000500
#define BF_JRX_DL_204B_LL_LID_1(val) (val & 0x0000001F)
#define BF_JRX_DL_204B_LL_LID_1_GET(val) (val & 0x0000001F)

#define REG_JRX_DL_204B_25_LANE5_ADDR 0x00000553
#define BF_JRX_DL_204B_LL_LID_2_INFO 0x00000500
#define BF_JRX_DL_204B_LL_LID_2(val) (val & 0x0000001F)
#define BF_JRX_DL_204B_LL_LID_2_GET(val) (val & 0x0000001F)

#define REG_JRX_DL_204B_25_LANE4_ADDR 0x00000552
#define BF_JRX_DL_204B_LL_LID_3_INFO 0x00000500
#define BF_JRX_DL_204B_LL_LID_3(val) (val & 0x0000001F)
#define BF_JRX_DL_204B_LL_LID_3_GET(val) (val & 0x0000001F)

#define REG_JRX_DL_204B_25_LANE3_ADDR 0x00000551
#define BF_JRX_DL_204B_LL_LID_4_INFO 0x00000500
#define BF_JRX_DL_204B_LL_LID_4(val) (val & 0x0000001F)
#define BF_JRX_DL_204B_LL_LID_4_GET(val) (val & 0x0000001F)

#define REG_JRX_DL_204B_25_LANE2_ADDR 0x00000550
#define BF_JRX_DL_204B_LL_LID_5_INFO 0x00000500
#define BF_JRX_DL_204B_LL_LID_5(val) (val & 0x0000001F)
#define BF_JRX_DL_204B_LL_LID_5_GET(val) (val & 0x0000001F)

#define REG_JRX_DL_204B_25_LANE1_ADDR 0x0000054F
#define BF_JRX_DL_204B_LL_LID_6_INFO 0x00000500
#define BF_JRX_DL_204B_LL_LID_6(val) (val & 0x0000001F)
#define BF_JRX_DL_204B_LL_LID_6_GET(val) (val & 0x0000001F)

#define REG_JRX_DL_204B_25_LANE0_ADDR 0x0000054E
#define BF_JRX_DL_204B_LL_LID_7_INFO 0x00000500
#define BF_JRX_DL_204B_LL_LID_7(val) (val & 0x0000001F)
#define BF_JRX_DL_204B_LL_LID_7_GET(val) (val & 0x0000001F)

#define REG_JRX_DL_204B_26_ADDR 0x00000557
#define BF_JRX_DL_204B_EOF_EVENT_INFO 0x00000100
#define BF_JRX_DL_204B_EOF_EVENT(val) (val & 0x00000001)
#define BF_JRX_DL_204B_EOF_EVENT_GET(val) (val & 0x00000001)
#define BF_JRX_DL_204B_EOMF_EVENT_INFO 0x00000101
#define BF_JRX_DL_204B_EOMF_EVENT(val) ((val & 0x00000001) << 0x00000001)
#define BF_JRX_DL_204B_EOMF_EVENT_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_JRX_DL_204B_FS_LOST_INFO 0x00000102
#define BF_JRX_DL_204B_FS_LOST(val) ((val & 0x00000001) << 0x00000002)
#define BF_JRX_DL_204B_FS_LOST_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_JRX_DL_204B_SYNC_N_INFO 0x00000103
#define BF_JRX_DL_204B_SYNC_N(val) ((val & 0x00000001) << 0x00000003)
#define BF_JRX_DL_204B_SYNC_N_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_JRX_DL_204B_USER_DATA_INFO 0x00000104
#define BF_JRX_DL_204B_USER_DATA(val) ((val & 0x00000001) << 0x00000004)
#define BF_JRX_DL_204B_USER_DATA_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_JRX_DL_204B_VALID_CKSUM_INFO 0x00000105
#define BF_JRX_DL_204B_VALID_CKSUM(val) ((val & 0x00000001) << 0x00000005)
#define BF_JRX_DL_204B_VALID_CKSUM_GET(val) ((val >> 0x00000005) & 0x00000001)

#define REG_JRX_DL_204B_27_ADDR 0x00000558
#define BF_JRX_DL_204B_KSYNC_INFO 0x00000800
#define BF_JRX_DL_204B_KSYNC(val) (val & 0x000000FF)
#define BF_JRX_DL_204B_KSYNC_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204B_29_ADDR 0x0000055A
#define BF_JRX_DL_204B_IRQ_VEC_INFO 0x00000900
#define BF_JRX_DL_204B_IRQ_VEC(val) (val & 0x000001FF)
#define BF_JRX_DL_204B_IRQ_VEC_GET(val) (val & 0x000001FF)

#define REG_JRX_DL_204B_30_ADDR 0x0000055B
#define BF_JRX_DL_204B_IRQ_CLR_INFO 0x00000900
#define BF_JRX_DL_204B_IRQ_CLR(val) (val & 0x000001FF)
#define BF_JRX_DL_204B_IRQ_CLR_GET(val) (val & 0x000001FF)

#define REG_JRX_DL_204B_31_ADDR 0x0000055C
#define BF_JRX_DL_204B_IRQ_INFO 0x00000100
#define BF_JRX_DL_204B_IRQ(val) (val & 0x00000001)
#define BF_JRX_DL_204B_IRQ_GET(val) (val & 0x00000001)

#define REG_JRX_DL_204C_0_ADDR 0x0000055E
#define BF_JRX_DL_204C_HOLD_ERR_CNT_INFO 0x00000101 /* r2 */
#define BF_JRX_DL_204C_CLR_ERR_CNT_INFO 0x00000103
#define BF_JRX_DL_204C_CLR_ERR_CNT(val) ((val & 0x00000001) << 0x00000003)
#define BF_JRX_DL_204C_CLR_ERR_CNT_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_JRX_DL_204C_STATE_INFO 0x00000304
#define BF_JRX_DL_204C_STATE(val) ((val & 0x00000007) << 0x00000004)
#define BF_JRX_DL_204C_STATE_GET(val) ((val >> 0x00000004) & 0x00000007)
#define BF_JRX_DL_204C_ENABLE_INFO 0x00000107
#define BF_JRX_DL_204C_ENABLE(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204C_ENABLE_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204C_1_ADDR 0x0000055F
#define BF_JRX_DL_204C_MB_ERR_CFG_INFO 0x00000400
#define BF_JRX_DL_204C_MB_ERR_CFG(val) (val & 0x0000000F)
#define BF_JRX_DL_204C_MB_ERR_CFG_GET(val) (val & 0x0000000F)
#define BF_JRX_DL_204C_MB_REQD_CFG_INFO 0x00000404
#define BF_JRX_DL_204C_MB_REQD_CFG(val) ((val & 0x0000000F) << 0x00000004)
#define BF_JRX_DL_204C_MB_REQD_CFG_GET(val) ((val >> 0x00000004) & 0x0000000F)

#define REG_JRX_DL_204C_2_ADDR 0x00000560
#define BF_JRX_DL_204C_SH_ERR_CFG_INFO 0x00000600
#define BF_JRX_DL_204C_SH_ERR_CFG(val) (val & 0x0000003F)
#define BF_JRX_DL_204C_SH_ERR_CFG_GET(val) (val & 0x0000003F)

#define REG_JRX_DL_204C_3_ADDR 0x00000561
#define BF_JRX_DL_204C_SH_REQD_CFG_INFO 0x00000600
#define BF_JRX_DL_204C_SH_REQD_CFG(val) (val & 0x0000003F)
#define BF_JRX_DL_204C_SH_REQD_CFG_GET(val) (val & 0x0000003F)

#define REG_JRX_DL_204C_5_LANE7_ADDR 0x00000572
#define BF_JRX_DL_204C_MB_ERR_CNT_0_INFO 0x00000400
#define BF_JRX_DL_204C_MB_ERR_CNT_0(val) (val & 0x0000000F)
#define BF_JRX_DL_204C_MB_ERR_CNT_0_GET(val) (val & 0x0000000F)

#define REG_JRX_DL_204C_5_LANE6_ADDR 0x00000571
#define BF_JRX_DL_204C_MB_ERR_CNT_1_INFO 0x00000400
#define BF_JRX_DL_204C_MB_ERR_CNT_1(val) (val & 0x0000000F)
#define BF_JRX_DL_204C_MB_ERR_CNT_1_GET(val) (val & 0x0000000F)

#define REG_JRX_DL_204C_5_LANE5_ADDR 0x00000570
#define BF_JRX_DL_204C_MB_ERR_CNT_2_INFO 0x00000400
#define BF_JRX_DL_204C_MB_ERR_CNT_2(val) (val & 0x0000000F)
#define BF_JRX_DL_204C_MB_ERR_CNT_2_GET(val) (val & 0x0000000F)

#define REG_JRX_DL_204C_5_LANE4_ADDR 0x0000056F
#define BF_JRX_DL_204C_MB_ERR_CNT_3_INFO 0x00000400
#define BF_JRX_DL_204C_MB_ERR_CNT_3(val) (val & 0x0000000F)
#define BF_JRX_DL_204C_MB_ERR_CNT_3_GET(val) (val & 0x0000000F)

#define REG_JRX_DL_204C_5_LANE3_ADDR 0x0000056E
#define BF_JRX_DL_204C_MB_ERR_CNT_4_INFO 0x00000400
#define BF_JRX_DL_204C_MB_ERR_CNT_4(val) (val & 0x0000000F)
#define BF_JRX_DL_204C_MB_ERR_CNT_4_GET(val) (val & 0x0000000F)

#define REG_JRX_DL_204C_5_LANE2_ADDR 0x0000056D
#define BF_JRX_DL_204C_MB_ERR_CNT_5_INFO 0x00000400
#define BF_JRX_DL_204C_MB_ERR_CNT_5(val) (val & 0x0000000F)
#define BF_JRX_DL_204C_MB_ERR_CNT_5_GET(val) (val & 0x0000000F)

#define REG_JRX_DL_204C_5_LANE1_ADDR 0x0000056C
#define BF_JRX_DL_204C_MB_ERR_CNT_6_INFO 0x00000400
#define BF_JRX_DL_204C_MB_ERR_CNT_6(val) (val & 0x0000000F)
#define BF_JRX_DL_204C_MB_ERR_CNT_6_GET(val) (val & 0x0000000F)

#define REG_JRX_DL_204C_5_LANE0_ADDR 0x0000056B
#define BF_JRX_DL_204C_MB_ERR_CNT_7_INFO 0x00000400
#define BF_JRX_DL_204C_MB_ERR_CNT_7(val) (val & 0x0000000F)
#define BF_JRX_DL_204C_MB_ERR_CNT_7_GET(val) (val & 0x0000000F)

#define REG_JRX_DL_204C_6_LANE7_ADDR 0x0000057B
#define BF_JRX_DL_204C_SH_ERR_CNT_0_INFO 0x00000600
#define BF_JRX_DL_204C_SH_ERR_CNT_0(val) (val & 0x0000003F)
#define BF_JRX_DL_204C_SH_ERR_CNT_0_GET(val) (val & 0x0000003F)

#define REG_JRX_DL_204C_6_LANE6_ADDR 0x0000057A
#define BF_JRX_DL_204C_SH_ERR_CNT_1_INFO 0x00000600
#define BF_JRX_DL_204C_SH_ERR_CNT_1(val) (val & 0x0000003F)
#define BF_JRX_DL_204C_SH_ERR_CNT_1_GET(val) (val & 0x0000003F)

#define REG_JRX_DL_204C_6_LANE5_ADDR 0x00000579
#define BF_JRX_DL_204C_SH_ERR_CNT_2_INFO 0x00000600
#define BF_JRX_DL_204C_SH_ERR_CNT_2(val) (val & 0x0000003F)
#define BF_JRX_DL_204C_SH_ERR_CNT_2_GET(val) (val & 0x0000003F)

#define REG_JRX_DL_204C_6_LANE4_ADDR 0x00000578
#define BF_JRX_DL_204C_SH_ERR_CNT_3_INFO 0x00000600
#define BF_JRX_DL_204C_SH_ERR_CNT_3(val) (val & 0x0000003F)
#define BF_JRX_DL_204C_SH_ERR_CNT_3_GET(val) (val & 0x0000003F)

#define REG_JRX_DL_204C_6_LANE3_ADDR 0x00000577
#define BF_JRX_DL_204C_SH_ERR_CNT_4_INFO 0x00000600
#define BF_JRX_DL_204C_SH_ERR_CNT_4(val) (val & 0x0000003F)
#define BF_JRX_DL_204C_SH_ERR_CNT_4_GET(val) (val & 0x0000003F)

#define REG_JRX_DL_204C_6_LANE2_ADDR 0x00000576
#define BF_JRX_DL_204C_SH_ERR_CNT_5_INFO 0x00000600
#define BF_JRX_DL_204C_SH_ERR_CNT_5(val) (val & 0x0000003F)
#define BF_JRX_DL_204C_SH_ERR_CNT_5_GET(val) (val & 0x0000003F)

#define REG_JRX_DL_204C_6_LANE1_ADDR 0x00000575
#define BF_JRX_DL_204C_SH_ERR_CNT_6_INFO 0x00000600
#define BF_JRX_DL_204C_SH_ERR_CNT_6(val) (val & 0x0000003F)
#define BF_JRX_DL_204C_SH_ERR_CNT_6_GET(val) (val & 0x0000003F)

#define REG_JRX_DL_204C_6_LANE0_ADDR 0x00000574
#define BF_JRX_DL_204C_SH_ERR_CNT_7_INFO 0x00000600
#define BF_JRX_DL_204C_SH_ERR_CNT_7(val) (val & 0x0000003F)
#define BF_JRX_DL_204C_SH_ERR_CNT_7_GET(val) (val & 0x0000003F)

#define REG_JRX_CORE_1_ADDR 0x0000058C
#define BF_JRX_CHKSUM_LSB_ALG_INFO 0x00000101
#define BF_JRX_CHKSUM_LSB_ALG(val) ((val & 0x00000001) << 0x00000001)
#define BF_JRX_CHKSUM_LSB_ALG_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_JRX_CHKSUM_DISABLE_INFO 0x00000102
#define BF_JRX_CHKSUM_DISABLE(val) ((val & 0x00000001) << 0x00000002)
#define BF_JRX_CHKSUM_DISABLE_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_JRX_SYSREF_FOR_STARTUP_INFO 0x00000106
#define BF_JRX_SYSREF_FOR_STARTUP(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_SYSREF_FOR_STARTUP_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_JRX_SYSREF_FOR_RELINK_INFO 0x00000107
#define BF_JRX_SYSREF_FOR_RELINK(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_SYSREF_FOR_RELINK_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_CORE_2_LANE7_ADDR 0x00000594
#define BF_JRX_SRC_LANE_0_INFO 0x00000500
#define BF_JRX_SRC_LANE_0(val) (val & 0x0000001F)
#define BF_JRX_SRC_LANE_0_GET(val) (val & 0x0000001F)
#define BF_JRX_LINK_LANE_INVERSE_0_INFO 0x00000106
#define BF_JRX_LINK_LANE_INVERSE_0(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_LINK_LANE_INVERSE_0_GET(val) ((val >> 0x00000006) & 0x00000001)

#define REG_JRX_CORE_2_LANE6_ADDR 0x00000593
#define BF_JRX_SRC_LANE_1_INFO 0x00000500
#define BF_JRX_SRC_LANE_1(val) (val & 0x0000001F)
#define BF_JRX_SRC_LANE_1_GET(val) (val & 0x0000001F)
#define BF_JRX_LINK_LANE_INVERSE_1_INFO 0x00000106
#define BF_JRX_LINK_LANE_INVERSE_1(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_LINK_LANE_INVERSE_1_GET(val) ((val >> 0x00000006) & 0x00000001)

#define REG_JRX_CORE_2_LANE5_ADDR 0x00000592
#define BF_JRX_SRC_LANE_2_INFO 0x00000500
#define BF_JRX_SRC_LANE_2(val) (val & 0x0000001F)
#define BF_JRX_SRC_LANE_2_GET(val) (val & 0x0000001F)
#define BF_JRX_LINK_LANE_INVERSE_2_INFO 0x00000106
#define BF_JRX_LINK_LANE_INVERSE_2(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_LINK_LANE_INVERSE_2_GET(val) ((val >> 0x00000006) & 0x00000001)

#define REG_JRX_CORE_2_LANE4_ADDR 0x00000591
#define BF_JRX_SRC_LANE_3_INFO 0x00000500
#define BF_JRX_SRC_LANE_3(val) (val & 0x0000001F)
#define BF_JRX_SRC_LANE_3_GET(val) (val & 0x0000001F)
#define BF_JRX_LINK_LANE_INVERSE_3_INFO 0x00000106
#define BF_JRX_LINK_LANE_INVERSE_3(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_LINK_LANE_INVERSE_3_GET(val) ((val >> 0x00000006) & 0x00000001)

#define REG_JRX_CORE_2_LANE3_ADDR 0x00000590
#define BF_JRX_SRC_LANE_4_INFO 0x00000500
#define BF_JRX_SRC_LANE_4(val) (val & 0x0000001F)
#define BF_JRX_SRC_LANE_4_GET(val) (val & 0x0000001F)
#define BF_JRX_LINK_LANE_INVERSE_4_INFO 0x00000106
#define BF_JRX_LINK_LANE_INVERSE_4(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_LINK_LANE_INVERSE_4_GET(val) ((val >> 0x00000006) & 0x00000001)

#define REG_JRX_CORE_2_LANE2_ADDR 0x0000058F
#define BF_JRX_SRC_LANE_5_INFO 0x00000500
#define BF_JRX_SRC_LANE_5(val) (val & 0x0000001F)
#define BF_JRX_SRC_LANE_5_GET(val) (val & 0x0000001F)
#define BF_JRX_LINK_LANE_INVERSE_5_INFO 0x00000106
#define BF_JRX_LINK_LANE_INVERSE_5(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_LINK_LANE_INVERSE_5_GET(val) ((val >> 0x00000006) & 0x00000001)

#define REG_JRX_CORE_2_LANE1_ADDR 0x0000058E
#define BF_JRX_SRC_LANE_6_INFO 0x00000500
#define BF_JRX_SRC_LANE_6(val) (val & 0x0000001F)
#define BF_JRX_SRC_LANE_6_GET(val) (val & 0x0000001F)
#define BF_JRX_LINK_LANE_INVERSE_6_INFO 0x00000106
#define BF_JRX_LINK_LANE_INVERSE_6(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_LINK_LANE_INVERSE_6_GET(val) ((val >> 0x00000006) & 0x00000001)

#define REG_JRX_CORE_2_LANE0_ADDR 0x0000058D
#define BF_JRX_SRC_LANE_7_INFO 0x00000500
#define BF_JRX_SRC_LANE_7(val) (val & 0x0000001F)
#define BF_JRX_SRC_LANE_7_GET(val) (val & 0x0000001F)
#define BF_JRX_LINK_LANE_INVERSE_7_INFO 0x00000106
#define BF_JRX_LINK_LANE_INVERSE_7(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_LINK_LANE_INVERSE_7_GET(val) ((val >> 0x00000006) & 0x00000001)

#define REG_JRX_CORE_3_ADDR 0x00000595
#define BF_JRX_SYNC_N_SEL_INFO 0x00000800
#define BF_JRX_SYNC_N_SEL(val) (val & 0x000000FF)
#define BF_JRX_SYNC_N_SEL_GET(val) (val & 0x000000FF)

#define REG_GENERAL_JRX_CTRL_ADDR 0x00000596
#define BF_LINK_EN_INFO 0x00000200
#define BF_LINK_EN(val) (val & 0x00000003)
#define BF_LINK_EN_GET(val) (val & 0x00000003)
#define BF_LINK_SEPARATE_EN_INFO 0x00000102
#define BF_LINK_SEPARATE_EN(val) ((val & 0x00000001) << 0x00000002)
#define BF_LINK_SEPARATE_EN_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_LINK_MODE_INFO 0x00000103
#define BF_LINK_MODE(val) ((val & 0x00000001) << 0x00000003)
#define BF_LINK_MODE_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_LINK0_SYNCB_COMB_EN_INFO 0x00000105
#define BF_LINK0_SYNCB_COMB_EN(val) ((val & 0x00000001) << 0x00000005)
#define BF_LINK0_SYNCB_COMB_EN_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_LINK1_SYNCB_COMB_EN_INFO 0x00000106
#define BF_LINK1_SYNCB_COMB_EN(val) ((val & 0x00000001) << 0x00000006)
#define BF_LINK1_SYNCB_COMB_EN_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_USE_JRXIP_SYNCB_INFO 0x00000107
#define BF_USE_JRXIP_SYNCB(val) ((val & 0x00000001) << 0x00000007)
#define BF_USE_JRXIP_SYNCB_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_SYNCB_GEN_0_ADDR 0x00000597
#define BF_EOF_MASK_INFO 0x00000100
#define BF_EOF_MASK(val) (val & 0x00000001)
#define BF_EOF_MASK_GET(val) (val & 0x00000001)
#define BF_EOMF_MASK_INFO 0x00000102
#define BF_EOMF_MASK(val) ((val & 0x00000001) << 0x00000002)
#define BF_EOMF_MASK_GET(val) ((val >> 0x00000002) & 0x00000001)

#define REG_SYNCB_GEN_1_ADDR 0x00000598
#define BF_SYNCB_ERR_DUR_INFO 0x00000404
#define BF_SYNCB_ERR_DUR(val) ((val & 0x0000000F) << 0x00000004)
#define BF_SYNCB_ERR_DUR_GET(val) ((val >> 0x00000004) & 0x0000000F)

#define REG_JESD_DEBUG_REG_10_ADDR 0x000005A4
#define BF_FORCE_GOTO_MUX1TO2_INFO 0x00000B00
#define BF_FORCE_GOTO_MUX1TO2(val) (val & 0x000007FF)
#define BF_FORCE_GOTO_MUX1TO2_GET(val) (val & 0x000007FF)

#define REG_JESD_DEBUG_REG_11_ADDR 0x000005A5

#define REG_JESD_DEBUG_REG_12_ADDR 0x000005A6
#define BF_FORCE_GOTO_MUX32TO8_INFO 0x00000B00
#define BF_FORCE_GOTO_MUX32TO8(val) (val & 0x000007FF)
#define BF_FORCE_GOTO_MUX32TO8_GET(val) (val & 0x000007FF)

#define REG_JESD_DEBUG_REG_13_ADDR 0x000005A7

#define REG_JESD_DEBUG_REG_14_ADDR 0x000005A8
#define BF_FORCE_GOTO_MUX8TO32_INFO 0x00000B00
#define BF_FORCE_GOTO_MUX8TO32(val) (val & 0x000007FF)
#define BF_FORCE_GOTO_MUX8TO32_GET(val) (val & 0x000007FF)

#define REG_JESD_DEBUG_REG_15_ADDR 0x000005A9

#define REG_JESD_JRX_204BQBD_PA_INT_ENABLE_ADDR 0x000005AA
#define BF_EN_204B_CGS_JRX_INT_GAINOFF_INFO 0x00000100
#define BF_EN_204B_CGS_JRX_INT_GAINOFF(val) (val & 0x00000001)
#define BF_EN_204B_CGS_JRX_INT_GAINOFF_GET(val) (val & 0x00000001)
#define BF_EN_204B_FS_JRX_INT_GAINOFF_INFO 0x00000101
#define BF_EN_204B_FS_JRX_INT_GAINOFF(val) ((val & 0x00000001) << 0x00000001)
#define BF_EN_204B_FS_JRX_INT_GAINOFF_GET(val) \
	((val >> 0x00000001) & 0x00000001)
#define BF_EN_204B_GCS_JRX_INT_GAINOFF_INFO 0x00000102
#define BF_EN_204B_GCS_JRX_INT_GAINOFF(val) ((val & 0x00000001) << 0x00000002)
#define BF_EN_204B_GCS_JRX_INT_GAINOFF_GET(val) \
	((val >> 0x00000002) & 0x00000001)
#define BF_EN_204B_ILS_JRX_INT_GAINOFF_INFO 0x00000103
#define BF_EN_204B_ILS_JRX_INT_GAINOFF(val) ((val & 0x00000001) << 0x00000003)
#define BF_EN_204B_ILS_JRX_INT_GAINOFF_GET(val) \
	((val >> 0x00000003) & 0x00000001)
#define BF_EN_204B_ILD_JRX_INT_GAINOFF_INFO 0x00000104
#define BF_EN_204B_ILD_JRX_INT_GAINOFF(val) ((val & 0x00000001) << 0x00000004)
#define BF_EN_204B_ILD_JRX_INT_GAINOFF_GET(val) \
	((val >> 0x00000004) & 0x00000001)
#define BF_EN_204B_BD_JRX_INT_GAINOFF_INFO 0x00000105
#define BF_EN_204B_BD_JRX_INT_GAINOFF(val) ((val & 0x00000001) << 0x00000005)
#define BF_EN_204B_BD_JRX_INT_GAINOFF_GET(val) \
	((val >> 0x00000005) & 0x00000001)
#define BF_EN_204B_NIT_JRX_INT_GAINOFF_INFO 0x00000106
#define BF_EN_204B_NIT_JRX_INT_GAINOFF(val) ((val & 0x00000001) << 0x00000006)
#define BF_EN_204B_NIT_JRX_INT_GAINOFF_GET(val) \
	((val >> 0x00000006) & 0x00000001)
#define BF_EN_204B_UEK_JRX_INT_GAINOFF_INFO 0x00000107
#define BF_EN_204B_UEK_JRX_INT_GAINOFF(val) ((val & 0x00000001) << 0x00000007)
#define BF_EN_204B_UEK_JRX_INT_GAINOFF_GET(val) \
	((val >> 0x00000007) & 0x00000001)

#define REG_JESD_JRX_204H_PA_INT_ENABLE_ADDR 0x000005AB
#define BF_EN_204H_CGS_JRX_INT_GAINOFF_INFO 0x00000100
#define BF_EN_204H_CGS_JRX_INT_GAINOFF(val) (val & 0x00000001)
#define BF_EN_204H_CGS_JRX_INT_GAINOFF_GET(val) (val & 0x00000001)
#define BF_EN_204H_FS_JRX_INT_GAINOFF_INFO 0x00000101
#define BF_EN_204H_FS_JRX_INT_GAINOFF(val) ((val & 0x00000001) << 0x00000001)
#define BF_EN_204H_FS_JRX_INT_GAINOFF_GET(val) \
	((val >> 0x00000001) & 0x00000001)
#define BF_EN_204H_CKS_JRX_INT_GAINOFF_INFO 0x00000102
#define BF_EN_204H_CKS_JRX_INT_GAINOFF(val) ((val & 0x00000001) << 0x00000002)
#define BF_EN_204H_CKS_JRX_INT_GAINOFF_GET(val) \
	((val >> 0x00000002) & 0x00000001)
#define BF_EN_204H_ILS_JRX_INT_GAINOFF_INFO 0x00000103
#define BF_EN_204H_ILS_JRX_INT_GAINOFF(val) ((val & 0x00000001) << 0x00000003)
#define BF_EN_204H_ILS_JRX_INT_GAINOFF_GET(val) \
	((val >> 0x00000003) & 0x00000001)
#define BF_EN_204H_ILD_JRX_INT_GAINOFF_INFO 0x00000104
#define BF_EN_204H_ILD_JRX_INT_GAINOFF(val) ((val & 0x00000001) << 0x00000004)
#define BF_EN_204H_ILD_JRX_INT_GAINOFF_GET(val) \
	((val >> 0x00000004) & 0x00000001)
#define BF_EN_204H_UEK_JRX_INT_GAINOFF_INFO 0x00000105
#define BF_EN_204H_UEK_JRX_INT_GAINOFF(val) ((val & 0x00000001) << 0x00000005)
#define BF_EN_204H_UEK_JRX_INT_GAINOFF_GET(val) \
	((val >> 0x00000005) & 0x00000001)
#define BF_EN_204H_PARITY_JRX_INT_GAINOFF_INFO 0x00000106
#define BF_EN_204H_PARITY_JRX_INT_GAINOFF(val) \
	((val & 0x00000001) << 0x00000006)
#define BF_EN_204H_PARITY_JRX_INT_GAINOFF_GET(val) \
	((val >> 0x00000006) & 0x00000001)
#define BF_EN_204H_SH_JRX_INT_GAINOFF_INFO 0x00000107
#define BF_EN_204H_SH_JRX_INT_GAINOFF(val) ((val & 0x00000001) << 0x00000007)
#define BF_EN_204H_SH_JRX_INT_GAINOFF_GET(val) \
	((val >> 0x00000007) & 0x00000001)

#define REG_JESD_LANE_FIFO_INT_ENABLE_ADDR 0x000005AC
#define BF_EN_JRX_LANE_FIFO_EMPTY_INT_GAINOFF_INFO 0x00000100
#define BF_EN_JRX_LANE_FIFO_EMPTY_INT_GAINOFF(val) (val & 0x00000001)
#define BF_EN_JRX_LANE_FIFO_EMPTY_INT_GAINOFF_GET(val) (val & 0x00000001)
#define BF_EN_JRX_LANE_FIFO_FULL_INT_GAINOFF_INFO 0x00000101
#define BF_EN_JRX_LANE_FIFO_FULL_INT_GAINOFF(val) \
	((val & 0x00000001) << 0x00000001)
#define BF_EN_JRX_LANE_FIFO_FULL_INT_GAINOFF_GET(val) \
	((val >> 0x00000001) & 0x00000001)

#define REG_FIFO_STATUS_REG_0_ADDR 0x000005AD
#define BF_LANE_FIFO_FULL_INFO 0x00000800
#define BF_LANE_FIFO_FULL(val) (val & 0x000000FF)
#define BF_LANE_FIFO_FULL_GET(val) (val & 0x000000FF)

#define REG_FIFO_STATUS_REG_1_ADDR 0x000005AE
#define BF_LANE_FIFO_EMPTY_INFO 0x00000800
#define BF_LANE_FIFO_EMPTY(val) (val & 0x000000FF)
#define BF_LANE_FIFO_EMPTY_GET(val) (val & 0x000000FF)

#define REG_CAP_SRAM_CFG00_ADDR 0x000005AF
#define BF_INPUT_SEL_INFO 0x00000300
#define BF_INPUT_SEL(val) (val & 0x00000007)
#define BF_INPUT_SEL_GET(val) (val & 0x00000007)
#define BF_WORD_WIDTH_SEL_INFO 0x00000204
#define BF_WORD_WIDTH_SEL(val) ((val & 0x00000003) << 0x00000004)
#define BF_WORD_WIDTH_SEL_GET(val) ((val >> 0x00000004) & 0x00000003)

#define REG_CAP_SRAM_CFG01_ADDR 0x000005B0
#define BF_START_CAPTURE_INFO 0x00000100
#define BF_START_CAPTURE(val) (val & 0x00000001)
#define BF_START_CAPTURE_GET(val) (val & 0x00000001)
#define BF_EN_ALIGN_66B_INFO 0x00000104
#define BF_EN_ALIGN_66B(val) ((val & 0x00000001) << 0x00000004)
#define BF_EN_ALIGN_66B_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_ALIGN_66B_BIT_INFO 0x00000105
#define BF_ALIGN_66B_BIT(val) ((val & 0x00000001) << 0x00000005)
#define BF_ALIGN_66B_BIT_GET(val) ((val >> 0x00000005) & 0x00000001)

#define REG_CAP_SRAM_CFG02_ADDR 0x000005B1
#define BF_START_ADDR_INFO 0x00000B00
#define BF_START_ADDR(val) (val & 0x000007FF)
#define BF_START_ADDR_GET(val) (val & 0x000007FF)

#define REG_CAP_SRAM_CFG03_ADDR 0x000005B2

#define REG_CAP_SRAM_CFG04_ADDR 0x000005B3
#define BF_END_ADDR_INFO 0x00000B00
#define BF_END_ADDR(val) (val & 0x000007FF)
#define BF_END_ADDR_GET(val) (val & 0x000007FF)

#define REG_CAP_SRAM_CFG05_ADDR 0x000005B4

#define REG_CAP_SRAM_CFG06_ADDR 0x000005B5
#define BF_EN_MEM_READ_INTF_INFO 0x00000100
#define BF_EN_MEM_READ_INTF(val) (val & 0x00000001)
#define BF_EN_MEM_READ_INTF_GET(val) (val & 0x00000001)
#define BF_SRAM_SEL_DBG_INFO 0x00000101
#define BF_SRAM_SEL_DBG(val) ((val & 0x00000001) << 0x00000001)
#define BF_SRAM_SEL_DBG_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_EN_DEBUG_INTF_INFO 0x00000104
#define BF_EN_DEBUG_INTF(val) ((val & 0x00000001) << 0x00000004)
#define BF_EN_DEBUG_INTF_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_SRAM_SEL_DMA_INFO 0x00000105
#define BF_SRAM_SEL_DMA(val) ((val & 0x00000001) << 0x00000005)
#define BF_SRAM_SEL_DMA_GET(val) ((val >> 0x00000005) & 0x00000001)

#define REG_CAP_SRAM_CFG07_ADDR 0x000005B6
#define BF_SRAM_SLP_INFO 0x00000100
#define BF_SRAM_SLP(val) (val & 0x00000001)
#define BF_SRAM_SLP_GET(val) (val & 0x00000001)
#define BF_SRAM_SD_INFO 0x00000101
#define BF_SRAM_SD(val) ((val & 0x00000001) << 0x00000001)
#define BF_SRAM_SD_GET(val) ((val >> 0x00000001) & 0x00000001)

#define REG_CAP_SRAM_STAT0_ADDR 0x000005B7
#define BF_CAPTURE_DONE_INFO 0x00000100
#define BF_CAPTURE_DONE(val) (val & 0x00000001)
#define BF_CAPTURE_DONE_GET(val) (val & 0x00000001)
#define BF_CAP_IN_PROCESS_INFO 0x00000101
#define BF_CAP_IN_PROCESS(val) ((val & 0x00000001) << 0x00000001)
#define BF_CAP_IN_PROCESS_GET(val) ((val >> 0x00000001) & 0x00000001)

#define REG_JRX_204C_IRQ_ADDR 0x000005BB
#define BF_JRX_204C_CRC_IRQ_ENABLE_INFO 0x00000100
#define BF_JRX_204C_MB_IRQ_ENABLE_INFO_R1 0x00000101 /* r1 */
#define BF_JRX_204C_SH_IRQ_ENABLE_INFO_R1 0x00000102 /* r1 */
#define BF_JRX_204C_CRC_IRQ_INFO_R1 0x00000103 /* r1 */
#define BF_JRX_204C_MB_IRQ_INFO_R1 0x00000104 /* r1 */
#define BF_JRX_204C_SH_IRQ_INFO_R1 0x00000105 /* r1 */
#define BF_JRX_204C_EMB_IRQ_ENABLE_INFO_R2 0x00000101 /* r2 */
#define BF_JRX_204C_MB_IRQ_ENABLE_INFO_R2 0x00000102 /* r2 */
#define BF_JRX_204C_SH_IRQ_ENABLE_INFO_R2 0x00000103 /* r2 */
#define BF_JRX_204C_CRC_IRQ_INFO_R2 0x00000104 /* r2 */
#define BF_JRX_204C_EMB_IRQ_INFO_R2 0x00000105 /* r2 */
#define BF_JRX_204C_MB_IRQ_INFO_R2 0x00000106 /* r2 */
#define BF_JRX_204C_SH_IRQ_INFO_R2 0x00000107 /* r2 */

#define REG_DDSM_HOPF_CTRL0_ADDR 0x00000800
#define BF_DDSM_HOPF_SEL_INFO 0x00000500
#define BF_DDSM_HOPF_SEL(val) (val & 0x0000001F)
#define BF_DDSM_HOPF_SEL_GET(val) (val & 0x0000001F)
#define BF_DDSM_HOPF_MODE_INFO 0x00000206
#define BF_DDSM_HOPF_MODE(val) ((val & 0x00000003) << 0x00000006)
#define BF_DDSM_HOPF_MODE_GET(val) ((val >> 0x00000006) & 0x00000003)

#define REG_DDSM_HOPF_CTRL1_ADDR 0x00000801
#define BF_GPIO_HOP_EN_INFO 0x00000100
#define BF_GPIO_HOP_EN(val) (val & 0x00000001)
#define BF_GPIO_HOP_EN_GET(val) (val & 0x00000001)

#define REG_DDSM_HOPF_FTW1_0_ADDR 0x00000806
#define BF_DDSM_HOPF_FTW1_INFO 0x00002000
#define BF_DDSM_HOPF_FTW1(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW1_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW1_1_ADDR 0x00000807

#define REG_DDSM_HOPF_FTW1_2_ADDR 0x00000808

#define REG_DDSM_HOPF_FTW1_3_ADDR 0x00000809

#define REG_DDSM_HOPF_FTW2_0_ADDR 0x0000080A
#define BF_DDSM_HOPF_FTW2_INFO 0x00002000
#define BF_DDSM_HOPF_FTW2(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW2_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW2_1_ADDR 0x0000080B

#define REG_DDSM_HOPF_FTW2_2_ADDR 0x0000080C

#define REG_DDSM_HOPF_FTW2_3_ADDR 0x0000080D

#define REG_DDSM_HOPF_FTW3_0_ADDR 0x0000080E
#define BF_DDSM_HOPF_FTW3_INFO 0x00002000
#define BF_DDSM_HOPF_FTW3(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW3_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW3_1_ADDR 0x0000080F

#define REG_DDSM_HOPF_FTW3_2_ADDR 0x00000810

#define REG_DDSM_HOPF_FTW3_3_ADDR 0x00000811

#define REG_DDSM_HOPF_FTW4_0_ADDR 0x00000812
#define BF_DDSM_HOPF_FTW4_INFO 0x00002000
#define BF_DDSM_HOPF_FTW4(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW4_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW4_1_ADDR 0x00000813

#define REG_DDSM_HOPF_FTW4_2_ADDR 0x00000814

#define REG_DDSM_HOPF_FTW4_3_ADDR 0x00000815

#define REG_DDSM_HOPF_FTW5_0_ADDR 0x00000816
#define BF_DDSM_HOPF_FTW5_INFO 0x00002000
#define BF_DDSM_HOPF_FTW5(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW5_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW5_1_ADDR 0x00000817

#define REG_DDSM_HOPF_FTW5_2_ADDR 0x00000818

#define REG_DDSM_HOPF_FTW5_3_ADDR 0x00000819

#define REG_DDSM_HOPF_FTW6_0_ADDR 0x0000081A
#define BF_DDSM_HOPF_FTW6_INFO 0x00002000
#define BF_DDSM_HOPF_FTW6(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW6_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW6_1_ADDR 0x0000081B

#define REG_DDSM_HOPF_FTW6_2_ADDR 0x0000081C

#define REG_DDSM_HOPF_FTW6_3_ADDR 0x0000081D

#define REG_DDSM_HOPF_FTW7_0_ADDR 0x0000081E
#define BF_DDSM_HOPF_FTW7_INFO 0x00002000
#define BF_DDSM_HOPF_FTW7(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW7_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW7_1_ADDR 0x0000081F

#define REG_DDSM_HOPF_FTW7_2_ADDR 0x00000820

#define REG_DDSM_HOPF_FTW7_3_ADDR 0x00000821

#define REG_DDSM_HOPF_FTW8_0_ADDR 0x00000822
#define BF_DDSM_HOPF_FTW8_INFO 0x00002000
#define BF_DDSM_HOPF_FTW8(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW8_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW8_1_ADDR 0x00000823

#define REG_DDSM_HOPF_FTW8_2_ADDR 0x00000824

#define REG_DDSM_HOPF_FTW8_3_ADDR 0x00000825

#define REG_DDSM_HOPF_FTW9_0_ADDR 0x00000826
#define BF_DDSM_HOPF_FTW9_INFO 0x00002000
#define BF_DDSM_HOPF_FTW9(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW9_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW9_1_ADDR 0x00000827

#define REG_DDSM_HOPF_FTW9_2_ADDR 0x00000828

#define REG_DDSM_HOPF_FTW9_3_ADDR 0x00000829

#define REG_DDSM_HOPF_FTW10_0_ADDR 0x0000082A
#define BF_DDSM_HOPF_FTW10_INFO 0x00002000
#define BF_DDSM_HOPF_FTW10(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW10_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW10_1_ADDR 0x0000082B

#define REG_DDSM_HOPF_FTW10_2_ADDR 0x0000082C

#define REG_DDSM_HOPF_FTW10_3_ADDR 0x0000082D

#define REG_DDSM_HOPF_FTW11_0_ADDR 0x0000082E
#define BF_DDSM_HOPF_FTW11_INFO 0x00002000
#define BF_DDSM_HOPF_FTW11(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW11_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW11_1_ADDR 0x0000082F

#define REG_DDSM_HOPF_FTW11_2_ADDR 0x00000830

#define REG_DDSM_HOPF_FTW11_3_ADDR 0x00000831

#define REG_DDSM_HOPF_FTW12_0_ADDR 0x00000832
#define BF_DDSM_HOPF_FTW12_INFO 0x00002000
#define BF_DDSM_HOPF_FTW12(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW12_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW12_1_ADDR 0x00000833

#define REG_DDSM_HOPF_FTW12_2_ADDR 0x00000834

#define REG_DDSM_HOPF_FTW12_3_ADDR 0x00000835

#define REG_DDSM_HOPF_FTW13_0_ADDR 0x00000836
#define BF_DDSM_HOPF_FTW13_INFO 0x00002000
#define BF_DDSM_HOPF_FTW13(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW13_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW13_1_ADDR 0x00000837

#define REG_DDSM_HOPF_FTW13_2_ADDR 0x00000838

#define REG_DDSM_HOPF_FTW13_3_ADDR 0x00000839

#define REG_DDSM_HOPF_FTW14_0_ADDR 0x0000083A
#define BF_DDSM_HOPF_FTW14_INFO 0x00002000
#define BF_DDSM_HOPF_FTW14(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW14_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW14_1_ADDR 0x0000083B

#define REG_DDSM_HOPF_FTW14_2_ADDR 0x0000083C

#define REG_DDSM_HOPF_FTW14_3_ADDR 0x0000083D

#define REG_DDSM_HOPF_FTW15_0_ADDR 0x0000083E
#define BF_DDSM_HOPF_FTW15_INFO 0x00002000
#define BF_DDSM_HOPF_FTW15(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW15_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW15_1_ADDR 0x0000083F

#define REG_DDSM_HOPF_FTW15_2_ADDR 0x00000840

#define REG_DDSM_HOPF_FTW15_3_ADDR 0x00000841

#define REG_DDSM_HOPF_FTW16_0_ADDR 0x00000842
#define BF_DDSM_HOPF_FTW16_INFO 0x00002000
#define BF_DDSM_HOPF_FTW16(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW16_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW16_1_ADDR 0x00000843

#define REG_DDSM_HOPF_FTW16_2_ADDR 0x00000844

#define REG_DDSM_HOPF_FTW16_3_ADDR 0x00000845

#define REG_DDSM_HOPF_FTW17_0_ADDR 0x00000846
#define BF_DDSM_HOPF_FTW17_INFO 0x00002000
#define BF_DDSM_HOPF_FTW17(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW17_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW17_1_ADDR 0x00000847

#define REG_DDSM_HOPF_FTW17_2_ADDR 0x00000848

#define REG_DDSM_HOPF_FTW17_3_ADDR 0x00000849

#define REG_DDSM_HOPF_FTW18_0_ADDR 0x0000084A
#define BF_DDSM_HOPF_FTW18_INFO 0x00002000
#define BF_DDSM_HOPF_FTW18(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW18_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW18_1_ADDR 0x0000084B

#define REG_DDSM_HOPF_FTW18_2_ADDR 0x0000084C

#define REG_DDSM_HOPF_FTW18_3_ADDR 0x0000084D

#define REG_DDSM_HOPF_FTW19_0_ADDR 0x0000084E
#define BF_DDSM_HOPF_FTW19_INFO 0x00002000
#define BF_DDSM_HOPF_FTW19(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW19_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW19_1_ADDR 0x0000084F

#define REG_DDSM_HOPF_FTW19_2_ADDR 0x00000850

#define REG_DDSM_HOPF_FTW19_3_ADDR 0x00000851

#define REG_DDSM_HOPF_FTW20_0_ADDR 0x00000852
#define BF_DDSM_HOPF_FTW20_INFO 0x00002000
#define BF_DDSM_HOPF_FTW20(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW20_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW20_1_ADDR 0x00000853

#define REG_DDSM_HOPF_FTW20_2_ADDR 0x00000854

#define REG_DDSM_HOPF_FTW20_3_ADDR 0x00000855

#define REG_DDSM_HOPF_FTW21_0_ADDR 0x00000856
#define BF_DDSM_HOPF_FTW21_INFO 0x00002000
#define BF_DDSM_HOPF_FTW21(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW21_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW21_1_ADDR 0x00000857

#define REG_DDSM_HOPF_FTW21_2_ADDR 0x00000858

#define REG_DDSM_HOPF_FTW21_3_ADDR 0x00000859

#define REG_DDSM_HOPF_FTW22_0_ADDR 0x0000085A
#define BF_DDSM_HOPF_FTW22_INFO 0x00002000
#define BF_DDSM_HOPF_FTW22(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW22_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW22_1_ADDR 0x0000085B

#define REG_DDSM_HOPF_FTW22_2_ADDR 0x0000085C

#define REG_DDSM_HOPF_FTW22_3_ADDR 0x0000085D

#define REG_DDSM_HOPF_FTW23_0_ADDR 0x0000085E
#define BF_DDSM_HOPF_FTW23_INFO 0x00002000
#define BF_DDSM_HOPF_FTW23(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW23_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW23_1_ADDR 0x0000085F

#define REG_DDSM_HOPF_FTW23_2_ADDR 0x00000860

#define REG_DDSM_HOPF_FTW23_3_ADDR 0x00000861

#define REG_DDSM_HOPF_FTW24_0_ADDR 0x00000862
#define BF_DDSM_HOPF_FTW24_INFO 0x00002000
#define BF_DDSM_HOPF_FTW24(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW24_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW24_1_ADDR 0x00000863

#define REG_DDSM_HOPF_FTW24_2_ADDR 0x00000864

#define REG_DDSM_HOPF_FTW24_3_ADDR 0x00000865

#define REG_DDSM_HOPF_FTW25_0_ADDR 0x00000866
#define BF_DDSM_HOPF_FTW25_INFO 0x00002000
#define BF_DDSM_HOPF_FTW25(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW25_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW25_1_ADDR 0x00000867

#define REG_DDSM_HOPF_FTW25_2_ADDR 0x00000868

#define REG_DDSM_HOPF_FTW25_3_ADDR 0x00000869

#define REG_DDSM_HOPF_FTW26_0_ADDR 0x0000086A
#define BF_DDSM_HOPF_FTW26_INFO 0x00002000
#define BF_DDSM_HOPF_FTW26(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW26_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW26_1_ADDR 0x0000086B

#define REG_DDSM_HOPF_FTW26_2_ADDR 0x0000086C

#define REG_DDSM_HOPF_FTW26_3_ADDR 0x0000086D

#define REG_DDSM_HOPF_FTW27_0_ADDR 0x0000086E
#define BF_DDSM_HOPF_FTW27_INFO 0x00002000
#define BF_DDSM_HOPF_FTW27(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW27_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW27_1_ADDR 0x0000086F

#define REG_DDSM_HOPF_FTW27_2_ADDR 0x00000870

#define REG_DDSM_HOPF_FTW27_3_ADDR 0x00000871

#define REG_DDSM_HOPF_FTW28_0_ADDR 0x00000872
#define BF_DDSM_HOPF_FTW28_INFO 0x00002000
#define BF_DDSM_HOPF_FTW28(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW28_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW28_1_ADDR 0x00000873

#define REG_DDSM_HOPF_FTW28_2_ADDR 0x00000874

#define REG_DDSM_HOPF_FTW28_3_ADDR 0x00000875

#define REG_DDSM_HOPF_FTW29_0_ADDR 0x00000876
#define BF_DDSM_HOPF_FTW29_INFO 0x00002000
#define BF_DDSM_HOPF_FTW29(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW29_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW29_1_ADDR 0x00000877

#define REG_DDSM_HOPF_FTW29_2_ADDR 0x00000878

#define REG_DDSM_HOPF_FTW29_3_ADDR 0x00000879

#define REG_DDSM_HOPF_FTW30_0_ADDR 0x0000087A
#define BF_DDSM_HOPF_FTW30_INFO 0x00002000
#define BF_DDSM_HOPF_FTW30(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW30_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW30_1_ADDR 0x0000087B

#define REG_DDSM_HOPF_FTW30_2_ADDR 0x0000087C

#define REG_DDSM_HOPF_FTW30_3_ADDR 0x0000087D

#define REG_DDSM_HOPF_FTW31_0_ADDR 0x0000087E
#define BF_DDSM_HOPF_FTW31_INFO 0x00002000
#define BF_DDSM_HOPF_FTW31(val) (val & 0x00000000)
#define BF_DDSM_HOPF_FTW31_GET(val) (val & 0x00000000)

#define REG_DDSM_HOPF_FTW31_1_ADDR 0x0000087F

#define REG_DDSM_HOPF_FTW31_2_ADDR 0x00000880

#define REG_DDSM_HOPF_FTW31_3_ADDR 0x00000881

#define REG_JRX_TEST_0_ADDR 0x00000950
#define BF_JRX_PRBS_LANE_CLEAR_ERRORS_INFO 0x00000100
#define BF_JRX_PRBS_LANE_CLEAR_ERRORS(val) (val & 0x00000001)
#define BF_JRX_PRBS_LANE_CLEAR_ERRORS_GET(val) (val & 0x00000001)
#define BF_JRX_PRBS_LANE_UPDATE_ERROR_COUNT_INFO 0x00000101
#define BF_JRX_PRBS_LANE_UPDATE_ERROR_COUNT(val) \
	((val & 0x00000001) << 0x00000001)
#define BF_JRX_PRBS_LANE_UPDATE_ERROR_COUNT_GET(val) \
	((val >> 0x00000001) & 0x00000001)
#define BF_JRX_PRBS_SWAP_ENDIANNESS_INFO 0x00000103
#define BF_JRX_PRBS_SWAP_ENDIANNESS(val) ((val & 0x00000001) << 0x00000003)
#define BF_JRX_PRBS_SWAP_ENDIANNESS_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_JRX_PRBS_SAMPLE_UPDATE_ERROR_COUNT_INFO 0x00000104
#define BF_JRX_PRBS_SAMPLE_UPDATE_ERROR_COUNT(val) \
	((val & 0x00000001) << 0x00000004)
#define BF_JRX_PRBS_SAMPLE_UPDATE_ERROR_COUNT_GET(val) \
	((val >> 0x00000004) & 0x00000001)
#define BF_JRX_PRBS_SAMPLE_CLEAR_ERRORS_INFO 0x00000105
#define BF_JRX_PRBS_SAMPLE_CLEAR_ERRORS(val) ((val & 0x00000001) << 0x00000005)
#define BF_JRX_PRBS_SAMPLE_CLEAR_ERRORS_GET(val) \
	((val >> 0x00000005) & 0x00000001)
#define BF_JRX_PRBS_SAMPLE_INVALID_DATA_FLAG_INFO 0x00000106
#define BF_JRX_PRBS_SAMPLE_INVALID_DATA_FLAG(val) \
	((val & 0x00000001) << 0x00000006)
#define BF_JRX_PRBS_SAMPLE_INVALID_DATA_FLAG_GET(val) \
	((val >> 0x00000006) & 0x00000001)
#define BF_JRX_PRBS_SAMPLE_ERROR_FLAG_INFO 0x00000107
#define BF_JRX_PRBS_SAMPLE_ERROR_FLAG(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_PRBS_SAMPLE_ERROR_FLAG_GET(val) \
	((val >> 0x00000007) & 0x00000001)

#define REG_JRX_TEST_1_ADDR 0x00000951
#define BF_JRX_PRBS_SAMPLE_ERROR_COUNT_INFO 0x00000800
#define BF_JRX_PRBS_SAMPLE_ERROR_COUNT(val) (val & 0x000000FF)
#define BF_JRX_PRBS_SAMPLE_ERROR_COUNT_GET(val) (val & 0x000000FF)

#define REG_JRX_TEST_2_ADDR 0x00000952
#define BF_JRX_PRBS_MODE_INFO 0x00000300
#define BF_JRX_PRBS_MODE(val) (val & 0x00000007)
#define BF_JRX_PRBS_MODE_GET(val) (val & 0x00000007)
#define BF_JRX_PRBS_SOURCE_INFO 0x00000107
#define BF_JRX_PRBS_SOURCE(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_PRBS_SOURCE_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_TEST_3_LANE7_ADDR 0x0000095A
#define BF_JRX_PRBS_LANE_INVALID_DATA_FLAG_0_INFO 0x00000106
#define BF_JRX_PRBS_LANE_INVALID_DATA_FLAG_0(val) \
	((val & 0x00000001) << 0x00000006)
#define BF_JRX_PRBS_LANE_INVALID_DATA_FLAG_0_GET(val) \
	((val >> 0x00000006) & 0x00000001)
#define BF_JRX_PRBS_LANE_ERROR_FLAG_0_INFO 0x00000107
#define BF_JRX_PRBS_LANE_ERROR_FLAG_0(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_PRBS_LANE_ERROR_FLAG_0_GET(val) \
	((val >> 0x00000007) & 0x00000001)

#define REG_JRX_TEST_3_LANE6_ADDR 0x00000959
#define BF_JRX_PRBS_LANE_INVALID_DATA_FLAG_1_INFO 0x00000106
#define BF_JRX_PRBS_LANE_INVALID_DATA_FLAG_1(val) \
	((val & 0x00000001) << 0x00000006)
#define BF_JRX_PRBS_LANE_INVALID_DATA_FLAG_1_GET(val) \
	((val >> 0x00000006) & 0x00000001)
#define BF_JRX_PRBS_LANE_ERROR_FLAG_1_INFO 0x00000107
#define BF_JRX_PRBS_LANE_ERROR_FLAG_1(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_PRBS_LANE_ERROR_FLAG_1_GET(val) \
	((val >> 0x00000007) & 0x00000001)

#define REG_JRX_TEST_3_LANE5_ADDR 0x00000958
#define BF_JRX_PRBS_LANE_INVALID_DATA_FLAG_2_INFO 0x00000106
#define BF_JRX_PRBS_LANE_INVALID_DATA_FLAG_2(val) \
	((val & 0x00000001) << 0x00000006)
#define BF_JRX_PRBS_LANE_INVALID_DATA_FLAG_2_GET(val) \
	((val >> 0x00000006) & 0x00000001)
#define BF_JRX_PRBS_LANE_ERROR_FLAG_2_INFO 0x00000107
#define BF_JRX_PRBS_LANE_ERROR_FLAG_2(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_PRBS_LANE_ERROR_FLAG_2_GET(val) \
	((val >> 0x00000007) & 0x00000001)

#define REG_JRX_TEST_3_LANE4_ADDR 0x00000957
#define BF_JRX_PRBS_LANE_INVALID_DATA_FLAG_3_INFO 0x00000106
#define BF_JRX_PRBS_LANE_INVALID_DATA_FLAG_3(val) \
	((val & 0x00000001) << 0x00000006)
#define BF_JRX_PRBS_LANE_INVALID_DATA_FLAG_3_GET(val) \
	((val >> 0x00000006) & 0x00000001)
#define BF_JRX_PRBS_LANE_ERROR_FLAG_3_INFO 0x00000107
#define BF_JRX_PRBS_LANE_ERROR_FLAG_3(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_PRBS_LANE_ERROR_FLAG_3_GET(val) \
	((val >> 0x00000007) & 0x00000001)

#define REG_JRX_TEST_3_LANE3_ADDR 0x00000956
#define BF_JRX_PRBS_LANE_INVALID_DATA_FLAG_4_INFO 0x00000106
#define BF_JRX_PRBS_LANE_INVALID_DATA_FLAG_4(val) \
	((val & 0x00000001) << 0x00000006)
#define BF_JRX_PRBS_LANE_INVALID_DATA_FLAG_4_GET(val) \
	((val >> 0x00000006) & 0x00000001)
#define BF_JRX_PRBS_LANE_ERROR_FLAG_4_INFO 0x00000107
#define BF_JRX_PRBS_LANE_ERROR_FLAG_4(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_PRBS_LANE_ERROR_FLAG_4_GET(val) \
	((val >> 0x00000007) & 0x00000001)

#define REG_JRX_TEST_3_LANE2_ADDR 0x00000955
#define BF_JRX_PRBS_LANE_INVALID_DATA_FLAG_5_INFO 0x00000106
#define BF_JRX_PRBS_LANE_INVALID_DATA_FLAG_5(val) \
	((val & 0x00000001) << 0x00000006)
#define BF_JRX_PRBS_LANE_INVALID_DATA_FLAG_5_GET(val) \
	((val >> 0x00000006) & 0x00000001)
#define BF_JRX_PRBS_LANE_ERROR_FLAG_5_INFO 0x00000107
#define BF_JRX_PRBS_LANE_ERROR_FLAG_5(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_PRBS_LANE_ERROR_FLAG_5_GET(val) \
	((val >> 0x00000007) & 0x00000001)

#define REG_JRX_TEST_3_LANE1_ADDR 0x00000954
#define BF_JRX_PRBS_LANE_INVALID_DATA_FLAG_6_INFO 0x00000106
#define BF_JRX_PRBS_LANE_INVALID_DATA_FLAG_6(val) \
	((val & 0x00000001) << 0x00000006)
#define BF_JRX_PRBS_LANE_INVALID_DATA_FLAG_6_GET(val) \
	((val >> 0x00000006) & 0x00000001)
#define BF_JRX_PRBS_LANE_ERROR_FLAG_6_INFO 0x00000107
#define BF_JRX_PRBS_LANE_ERROR_FLAG_6(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_PRBS_LANE_ERROR_FLAG_6_GET(val) \
	((val >> 0x00000007) & 0x00000001)

#define REG_JRX_TEST_3_LANE0_ADDR 0x00000953
#define BF_JRX_PRBS_LANE_INVALID_DATA_FLAG_7_INFO 0x00000106
#define BF_JRX_PRBS_LANE_INVALID_DATA_FLAG_7(val) \
	((val & 0x00000001) << 0x00000006)
#define BF_JRX_PRBS_LANE_INVALID_DATA_FLAG_7_GET(val) \
	((val >> 0x00000006) & 0x00000001)
#define BF_JRX_PRBS_LANE_ERROR_FLAG_7_INFO 0x00000107
#define BF_JRX_PRBS_LANE_ERROR_FLAG_7(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_PRBS_LANE_ERROR_FLAG_7_GET(val) \
	((val >> 0x00000007) & 0x00000001)

#define REG_JRX_TEST_4_LANE7_ADDR 0x00000962
#define BF_JRX_PRBS_LANE_ERROR_COUNT_0_INFO 0x00001800
#define BF_JRX_PRBS_LANE_ERROR_COUNT_0(val) (val & 0x00FFFFFF)
#define BF_JRX_PRBS_LANE_ERROR_COUNT_0_GET(val) (val & 0x00FFFFFF)

#define REG_JRX_TEST_4_LANE6_ADDR 0x00000961
#define BF_JRX_PRBS_LANE_ERROR_COUNT_1_INFO 0x00001800
#define BF_JRX_PRBS_LANE_ERROR_COUNT_1(val) (val & 0x00FFFFFF)
#define BF_JRX_PRBS_LANE_ERROR_COUNT_1_GET(val) (val & 0x00FFFFFF)

#define REG_JRX_TEST_4_LANE5_ADDR 0x00000960
#define BF_JRX_PRBS_LANE_ERROR_COUNT_2_INFO 0x00001800
#define BF_JRX_PRBS_LANE_ERROR_COUNT_2(val) (val & 0x00FFFFFF)
#define BF_JRX_PRBS_LANE_ERROR_COUNT_2_GET(val) (val & 0x00FFFFFF)

#define REG_JRX_TEST_4_LANE4_ADDR 0x0000095F
#define BF_JRX_PRBS_LANE_ERROR_COUNT_3_INFO 0x00001800
#define BF_JRX_PRBS_LANE_ERROR_COUNT_3(val) (val & 0x00FFFFFF)
#define BF_JRX_PRBS_LANE_ERROR_COUNT_3_GET(val) (val & 0x00FFFFFF)

#define REG_JRX_TEST_4_LANE3_ADDR 0x0000095E
#define BF_JRX_PRBS_LANE_ERROR_COUNT_4_INFO 0x00001800
#define BF_JRX_PRBS_LANE_ERROR_COUNT_4(val) (val & 0x00FFFFFF)
#define BF_JRX_PRBS_LANE_ERROR_COUNT_4_GET(val) (val & 0x00FFFFFF)

#define REG_JRX_TEST_4_LANE2_ADDR 0x0000095D
#define BF_JRX_PRBS_LANE_ERROR_COUNT_5_INFO 0x00001800
#define BF_JRX_PRBS_LANE_ERROR_COUNT_5(val) (val & 0x00FFFFFF)
#define BF_JRX_PRBS_LANE_ERROR_COUNT_5_GET(val) (val & 0x00FFFFFF)

#define REG_JRX_TEST_4_LANE1_ADDR 0x0000095C
#define BF_JRX_PRBS_LANE_ERROR_COUNT_6_INFO 0x00001800
#define BF_JRX_PRBS_LANE_ERROR_COUNT_6(val) (val & 0x00FFFFFF)
#define BF_JRX_PRBS_LANE_ERROR_COUNT_6_GET(val) (val & 0x00FFFFFF)

#define REG_JRX_TEST_4_LANE0_ADDR 0x0000095B
#define BF_JRX_PRBS_LANE_ERROR_COUNT_7_INFO 0x00001800
#define BF_JRX_PRBS_LANE_ERROR_COUNT_7(val) (val & 0x00FFFFFF)
#define BF_JRX_PRBS_LANE_ERROR_COUNT_7_GET(val) (val & 0x00FFFFFF)

#define REG_JRX_TEST_5_LANE7_ADDR 0x0000096A

#define REG_JRX_TEST_5_LANE6_ADDR 0x00000969

#define REG_JRX_TEST_5_LANE5_ADDR 0x00000968

#define REG_JRX_TEST_5_LANE4_ADDR 0x00000967

#define REG_JRX_TEST_5_LANE3_ADDR 0x00000966

#define REG_JRX_TEST_5_LANE2_ADDR 0x00000965

#define REG_JRX_TEST_5_LANE1_ADDR 0x00000964

#define REG_JRX_TEST_5_LANE0_ADDR 0x00000963

#define REG_JRX_TEST_6_LANE7_ADDR 0x00000972

#define REG_JRX_TEST_6_LANE6_ADDR 0x00000971

#define REG_JRX_TEST_6_LANE5_ADDR 0x00000970

#define REG_JRX_TEST_6_LANE4_ADDR 0x0000096F

#define REG_JRX_TEST_6_LANE3_ADDR 0x0000096E

#define REG_JRX_TEST_6_LANE2_ADDR 0x0000096D

#define REG_JRX_TEST_6_LANE1_ADDR 0x0000096C

#define REG_JRX_TEST_6_LANE0_ADDR 0x0000096B

#define REG_JRX_TEST_7_ADDR 0x00000973
#define BF_JRX_TEST_USER_DATA_INFO 0x00002000
#define BF_JRX_TEST_USER_DATA(val) (val & 0x00000000)
#define BF_JRX_TEST_USER_DATA_GET(val) (val & 0x00000000)

#define REG_JRX_TEST_8_ADDR 0x00000974

#define REG_JRX_TEST_9_ADDR 0x00000975

#define REG_JRX_TEST_10_ADDR 0x00000976

#define REG_JRX_DL_204H_0_ADDR 0x00000977
#define BF_JRX_DL_204H_AR_ECNTR_INFO 0x00000100
#define BF_JRX_DL_204H_AR_ECNTR(val) (val & 0x00000001)
#define BF_JRX_DL_204H_AR_ECNTR_GET(val) (val & 0x00000001)
#define BF_JRX_DL_204H_CHAR_REPL_DIS_INFO 0x00000102
#define BF_JRX_DL_204H_CHAR_REPL_DIS(val) ((val & 0x00000001) << 0x00000002)
#define BF_JRX_DL_204H_CHAR_REPL_DIS_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_JRX_DL_204H_ENA_RAMP_CHECK_INFO 0x00000103
#define BF_JRX_DL_204H_ENA_RAMP_CHECK(val) ((val & 0x00000001) << 0x00000003)
#define BF_JRX_DL_204H_ENA_RAMP_CHECK_GET(val) \
	((val >> 0x00000003) & 0x00000001)
#define BF_JRX_DL_204H_FCHK_N_INFO 0x00000104
#define BF_JRX_DL_204H_FCHK_N(val) ((val & 0x00000001) << 0x00000004)
#define BF_JRX_DL_204H_FCHK_N_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_JRX_DL_204H_ILS_MODE_INFO 0x00000106
#define BF_JRX_DL_204H_ILS_MODE(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_DL_204H_ILS_MODE_GET(val) ((val >> 0x00000006) & 0x00000001)

#define REG_JRX_DL_204H_1_ADDR 0x00000978
#define BF_JRX_DL_204H_IRQ_CLR_INFO 0x00000900
#define BF_JRX_DL_204H_IRQ_CLR(val) (val & 0x000001FF)
#define BF_JRX_DL_204H_IRQ_CLR_GET(val) (val & 0x000001FF)

#define REG_JRX_DL_204H_2_ADDR 0x00000979
#define BF_JRX_DL_204H_ETH_0_INFO 0x00000800
#define BF_JRX_DL_204H_ETH_0(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_ETH_0_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_3_ADDR 0x0000097A
#define BF_JRX_DL_204H_ETH_1_INFO 0x00000800
#define BF_JRX_DL_204H_ETH_1(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_ETH_1_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_4_ADDR 0x0000097B
#define BF_JRX_DL_204H_ETH_2_INFO 0x00000800
#define BF_JRX_DL_204H_ETH_2(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_ETH_2_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_6_ADDR 0x0000097D
#define BF_JRX_DL_204H_K_CNT_TH_INFO 0x00000404
#define BF_JRX_DL_204H_K_CNT_TH(val) ((val & 0x0000000F) << 0x00000004)
#define BF_JRX_DL_204H_K_CNT_TH_GET(val) ((val >> 0x00000004) & 0x0000000F)

#define REG_JRX_DL_204H_7_ADDR 0x0000097E
#define BF_JRX_DL_204H_I_CNT_TH_INFO 0x00000400
#define BF_JRX_DL_204H_I_CNT_TH(val) (val & 0x0000000F)
#define BF_JRX_DL_204H_I_CNT_TH_GET(val) (val & 0x0000000F)
#define BF_JRX_DL_204H_V_CNT_TH_INFO 0x00000404
#define BF_JRX_DL_204H_V_CNT_TH(val) ((val & 0x0000000F) << 0x00000004)
#define BF_JRX_DL_204H_V_CNT_TH_GET(val) ((val >> 0x00000004) & 0x0000000F)

#define REG_JRX_DL_204H_8_ADDR 0x0000097F
#define BF_JRX_DL_204H_PARITY_BYPASS_INFO 0x00000101
#define BF_JRX_DL_204H_PARITY_BYPASS(val) ((val & 0x00000001) << 0x00000001)
#define BF_JRX_DL_204H_PARITY_BYPASS_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_JRX_DL_204H_PARITY_ODD_EN_INFO 0x00000105
#define BF_JRX_DL_204H_PARITY_ODD_EN(val) ((val & 0x00000001) << 0x00000005)
#define BF_JRX_DL_204H_PARITY_ODD_EN_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_JRX_DL_204H_SYNC_N_INFO 0x00000106
#define BF_JRX_DL_204H_SYNC_N(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_DL_204H_SYNC_N_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_JRX_DL_204H_FS_LOST_INFO 0x00000107
#define BF_JRX_DL_204H_FS_LOST(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_FS_LOST_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_9_ADDR 0x00000980
#define BF_JRX_DL_204H_SH_REQD_CFG_INFO 0x00000600
#define BF_JRX_DL_204H_SH_REQD_CFG(val) (val & 0x0000003F)
#define BF_JRX_DL_204H_SH_REQD_CFG_GET(val) (val & 0x0000003F)
#define BF_JRX_DL_204H_REPLACED_BLOCKS_MODE_INFO 0x00000206
#define BF_JRX_DL_204H_REPLACED_BLOCKS_MODE(val) \
	((val & 0x00000003) << 0x00000006)
#define BF_JRX_DL_204H_REPLACED_BLOCKS_MODE_GET(val) \
	((val >> 0x00000006) & 0x00000003)

#define REG_JRX_DL_204H_10_ADDR 0x00000981
#define BF_JRX_DL_204H_NUM_BLOCKS_AFTER_ERR_INFO 0x00000200
#define BF_JRX_DL_204H_NUM_BLOCKS_AFTER_ERR(val) (val & 0x00000003)
#define BF_JRX_DL_204H_NUM_BLOCKS_AFTER_ERR_GET(val) (val & 0x00000003)
#define BF_JRX_DL_204H_NUM_BLOCKS_BEFORE_ERR_INFO 0x00000302
#define BF_JRX_DL_204H_NUM_BLOCKS_BEFORE_ERR(val) \
	((val & 0x00000007) << 0x00000002)
#define BF_JRX_DL_204H_NUM_BLOCKS_BEFORE_ERR_GET(val) \
	((val >> 0x00000002) & 0x00000007)
#define BF_JRX_DL_204H_EOF_EVENT_INFO 0x00000105
#define BF_JRX_DL_204H_EOF_EVENT(val) ((val & 0x00000001) << 0x00000005)
#define BF_JRX_DL_204H_EOF_EVENT_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_JRX_DL_204H_EOMF_EVENT_INFO 0x00000106
#define BF_JRX_DL_204H_EOMF_EVENT(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_DL_204H_EOMF_EVENT_GET(val) ((val >> 0x00000006) & 0x00000001)

#define REG_JRX_DL_204H_11_ADDR 0x00000982
#define BF_JRX_DL_204H_FCMP0_INFO 0x00000800
#define BF_JRX_DL_204H_FCMP0(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_FCMP0_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_12_ADDR 0x00000983
#define BF_JRX_DL_204H_IRQ_VEC_INFO 0x00000900
#define BF_JRX_DL_204H_IRQ_VEC(val) (val & 0x000001FF)
#define BF_JRX_DL_204H_IRQ_VEC_GET(val) (val & 0x000001FF)

#define REG_JRX_DL_204H_13_ADDR 0x00000984
#define BF_JRX_DL_204H_LINK_STATE_INFO 0x00000400
#define BF_JRX_DL_204H_LINK_STATE(val) (val & 0x0000000F)
#define BF_JRX_DL_204H_LINK_STATE_GET(val) (val & 0x0000000F)
#define BF_JRX_DL_204H_USER_DATA_INFO 0x00000104
#define BF_JRX_DL_204H_USER_DATA(val) ((val & 0x00000001) << 0x00000004)
#define BF_JRX_DL_204H_USER_DATA_GET(val) ((val >> 0x00000004) & 0x00000001)
#define BF_JRX_DL_204H_VALID_CKSUM_INFO 0x00000105
#define BF_JRX_DL_204H_VALID_CKSUM(val) ((val & 0x00000001) << 0x00000005)
#define BF_JRX_DL_204H_VALID_CKSUM_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_JRX_DL_204H_IRQ_INFO 0x00000106
#define BF_JRX_DL_204H_IRQ(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_DL_204H_IRQ_GET(val) ((val >> 0x00000006) & 0x00000001)

#define REG_JRX_DL_204H_14_ADDR 0x00000985
#define BF_JRX_DL_204H_L0_RXCFG_0_INFO 0x00000800
#define BF_JRX_DL_204H_L0_RXCFG_0(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_L0_RXCFG_0_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_15_ADDR 0x00000986
#define BF_JRX_DL_204H_L0_RXCFG_1_INFO 0x00000800
#define BF_JRX_DL_204H_L0_RXCFG_1(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_L0_RXCFG_1_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_16_ADDR 0x00000987
#define BF_JRX_DL_204H_L0_RXCFG_2_INFO 0x00000800
#define BF_JRX_DL_204H_L0_RXCFG_2(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_L0_RXCFG_2_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_17_ADDR 0x00000988
#define BF_JRX_DL_204H_L0_RXCFG_3_INFO 0x00000800
#define BF_JRX_DL_204H_L0_RXCFG_3(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_L0_RXCFG_3_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_18_ADDR 0x00000989
#define BF_JRX_DL_204H_L0_RXCFG_4_INFO 0x00000800
#define BF_JRX_DL_204H_L0_RXCFG_4(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_L0_RXCFG_4_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_19_ADDR 0x0000098A
#define BF_JRX_DL_204H_L0_RXCFG_5_INFO 0x00000800
#define BF_JRX_DL_204H_L0_RXCFG_5(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_L0_RXCFG_5_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_20_ADDR 0x0000098B
#define BF_JRX_DL_204H_L0_RXCFG_6_INFO 0x00000800
#define BF_JRX_DL_204H_L0_RXCFG_6(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_L0_RXCFG_6_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_21_ADDR 0x0000098C
#define BF_JRX_DL_204H_L0_RXCFG_7_INFO 0x00000800
#define BF_JRX_DL_204H_L0_RXCFG_7(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_L0_RXCFG_7_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_22_ADDR 0x0000098D
#define BF_JRX_DL_204H_L0_RXCFG_8_INFO 0x00000800
#define BF_JRX_DL_204H_L0_RXCFG_8(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_L0_RXCFG_8_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_23_ADDR 0x0000098E
#define BF_JRX_DL_204H_L0_RXCFG_9_INFO 0x00000800
#define BF_JRX_DL_204H_L0_RXCFG_9(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_L0_RXCFG_9_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_24_ADDR 0x0000098F
#define BF_JRX_DL_204H_L0_RXCFG_10_INFO 0x00000800
#define BF_JRX_DL_204H_L0_RXCFG_10(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_L0_RXCFG_10_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_25_ADDR 0x00000990
#define BF_JRX_DL_204H_L0_RXCFG_11_INFO 0x00000800
#define BF_JRX_DL_204H_L0_RXCFG_11(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_L0_RXCFG_11_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_26_ADDR 0x00000991
#define BF_JRX_DL_204H_L0_RXCFG_12_INFO 0x00000800
#define BF_JRX_DL_204H_L0_RXCFG_12(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_L0_RXCFG_12_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_27_ADDR 0x00000992
#define BF_JRX_DL_204H_L0_RXCFG_13_INFO 0x00000800
#define BF_JRX_DL_204H_L0_RXCFG_13(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_L0_RXCFG_13_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_28_LANE7_ADDR 0x000009D9
#define BF_JRX_DL_204H_ECNT_ENA_0_INFO 0x00000300
#define BF_JRX_DL_204H_ECNT_ENA_0(val) (val & 0x00000007)
#define BF_JRX_DL_204H_ECNT_ENA_0_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204H_ECNT_RST_0_INFO 0x00000303
#define BF_JRX_DL_204H_ECNT_RST_0(val) ((val & 0x00000007) << 0x00000003)
#define BF_JRX_DL_204H_ECNT_RST_0_GET(val) ((val >> 0x00000003) & 0x00000007)
#define BF_JRX_DL_204H_CGS_0_INFO 0x00000106
#define BF_JRX_DL_204H_CGS_0(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_DL_204H_CGS_0_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_JRX_DL_204H_CKS_0_INFO 0x00000107
#define BF_JRX_DL_204H_CKS_0(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_CKS_0_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_28_LANE6_ADDR 0x000009CF
#define BF_JRX_DL_204H_ECNT_ENA_1_INFO 0x00000300
#define BF_JRX_DL_204H_ECNT_ENA_1(val) (val & 0x00000007)
#define BF_JRX_DL_204H_ECNT_ENA_1_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204H_ECNT_RST_1_INFO 0x00000303
#define BF_JRX_DL_204H_ECNT_RST_1(val) ((val & 0x00000007) << 0x00000003)
#define BF_JRX_DL_204H_ECNT_RST_1_GET(val) ((val >> 0x00000003) & 0x00000007)
#define BF_JRX_DL_204H_CGS_1_INFO 0x00000106
#define BF_JRX_DL_204H_CGS_1(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_DL_204H_CGS_1_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_JRX_DL_204H_CKS_1_INFO 0x00000107
#define BF_JRX_DL_204H_CKS_1(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_CKS_1_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_28_LANE5_ADDR 0x000009C5
#define BF_JRX_DL_204H_ECNT_ENA_2_INFO 0x00000300
#define BF_JRX_DL_204H_ECNT_ENA_2(val) (val & 0x00000007)
#define BF_JRX_DL_204H_ECNT_ENA_2_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204H_ECNT_RST_2_INFO 0x00000303
#define BF_JRX_DL_204H_ECNT_RST_2(val) ((val & 0x00000007) << 0x00000003)
#define BF_JRX_DL_204H_ECNT_RST_2_GET(val) ((val >> 0x00000003) & 0x00000007)
#define BF_JRX_DL_204H_CGS_2_INFO 0x00000106
#define BF_JRX_DL_204H_CGS_2(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_DL_204H_CGS_2_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_JRX_DL_204H_CKS_2_INFO 0x00000107
#define BF_JRX_DL_204H_CKS_2(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_CKS_2_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_28_LANE4_ADDR 0x000009BB
#define BF_JRX_DL_204H_ECNT_ENA_3_INFO 0x00000300
#define BF_JRX_DL_204H_ECNT_ENA_3(val) (val & 0x00000007)
#define BF_JRX_DL_204H_ECNT_ENA_3_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204H_ECNT_RST_3_INFO 0x00000303
#define BF_JRX_DL_204H_ECNT_RST_3(val) ((val & 0x00000007) << 0x00000003)
#define BF_JRX_DL_204H_ECNT_RST_3_GET(val) ((val >> 0x00000003) & 0x00000007)
#define BF_JRX_DL_204H_CGS_3_INFO 0x00000106
#define BF_JRX_DL_204H_CGS_3(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_DL_204H_CGS_3_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_JRX_DL_204H_CKS_3_INFO 0x00000107
#define BF_JRX_DL_204H_CKS_3(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_CKS_3_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_28_LANE3_ADDR 0x000009B1
#define BF_JRX_DL_204H_ECNT_ENA_4_INFO 0x00000300
#define BF_JRX_DL_204H_ECNT_ENA_4(val) (val & 0x00000007)
#define BF_JRX_DL_204H_ECNT_ENA_4_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204H_ECNT_RST_4_INFO 0x00000303
#define BF_JRX_DL_204H_ECNT_RST_4(val) ((val & 0x00000007) << 0x00000003)
#define BF_JRX_DL_204H_ECNT_RST_4_GET(val) ((val >> 0x00000003) & 0x00000007)
#define BF_JRX_DL_204H_CGS_4_INFO 0x00000106
#define BF_JRX_DL_204H_CGS_4(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_DL_204H_CGS_4_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_JRX_DL_204H_CKS_4_INFO 0x00000107
#define BF_JRX_DL_204H_CKS_4(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_CKS_4_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_28_LANE2_ADDR 0x000009A7
#define BF_JRX_DL_204H_ECNT_ENA_5_INFO 0x00000300
#define BF_JRX_DL_204H_ECNT_ENA_5(val) (val & 0x00000007)
#define BF_JRX_DL_204H_ECNT_ENA_5_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204H_ECNT_RST_5_INFO 0x00000303
#define BF_JRX_DL_204H_ECNT_RST_5(val) ((val & 0x00000007) << 0x00000003)
#define BF_JRX_DL_204H_ECNT_RST_5_GET(val) ((val >> 0x00000003) & 0x00000007)
#define BF_JRX_DL_204H_CGS_5_INFO 0x00000106
#define BF_JRX_DL_204H_CGS_5(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_DL_204H_CGS_5_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_JRX_DL_204H_CKS_5_INFO 0x00000107
#define BF_JRX_DL_204H_CKS_5(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_CKS_5_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_28_LANE1_ADDR 0x0000099D
#define BF_JRX_DL_204H_ECNT_ENA_6_INFO 0x00000300
#define BF_JRX_DL_204H_ECNT_ENA_6(val) (val & 0x00000007)
#define BF_JRX_DL_204H_ECNT_ENA_6_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204H_ECNT_RST_6_INFO 0x00000303
#define BF_JRX_DL_204H_ECNT_RST_6(val) ((val & 0x00000007) << 0x00000003)
#define BF_JRX_DL_204H_ECNT_RST_6_GET(val) ((val >> 0x00000003) & 0x00000007)
#define BF_JRX_DL_204H_CGS_6_INFO 0x00000106
#define BF_JRX_DL_204H_CGS_6(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_DL_204H_CGS_6_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_JRX_DL_204H_CKS_6_INFO 0x00000107
#define BF_JRX_DL_204H_CKS_6(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_CKS_6_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_28_LANE0_ADDR 0x00000993
#define BF_JRX_DL_204H_ECNT_ENA_7_INFO 0x00000300
#define BF_JRX_DL_204H_ECNT_ENA_7(val) (val & 0x00000007)
#define BF_JRX_DL_204H_ECNT_ENA_7_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204H_ECNT_RST_7_INFO 0x00000303
#define BF_JRX_DL_204H_ECNT_RST_7(val) ((val & 0x00000007) << 0x00000003)
#define BF_JRX_DL_204H_ECNT_RST_7_GET(val) ((val >> 0x00000003) & 0x00000007)
#define BF_JRX_DL_204H_CGS_7_INFO 0x00000106
#define BF_JRX_DL_204H_CGS_7(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_DL_204H_CGS_7_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_JRX_DL_204H_CKS_7_INFO 0x00000107
#define BF_JRX_DL_204H_CKS_7(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_CKS_7_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_29_LANE7_ADDR 0x000009DA
#define BF_JRX_DL_204H_ECNT_TCH_0_INFO 0x00000300
#define BF_JRX_DL_204H_ECNT_TCH_0(val) (val & 0x00000007)
#define BF_JRX_DL_204H_ECNT_TCH_0_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204H_PARITY_0_INFO 0x00000103
#define BF_JRX_DL_204H_PARITY_0(val) ((val & 0x00000001) << 0x00000003)
#define BF_JRX_DL_204H_PARITY_0_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_JRX_DL_204H_ECNT_TCR_0_INFO 0x00000304
#define BF_JRX_DL_204H_ECNT_TCR_0(val) ((val & 0x00000007) << 0x00000004)
#define BF_JRX_DL_204H_ECNT_TCR_0_GET(val) ((val >> 0x00000004) & 0x00000007)
#define BF_JRX_DL_204H_FS_0_INFO 0x00000107
#define BF_JRX_DL_204H_FS_0(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_FS_0_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_29_LANE6_ADDR 0x000009D0
#define BF_JRX_DL_204H_ECNT_TCH_1_INFO 0x00000300
#define BF_JRX_DL_204H_ECNT_TCH_1(val) (val & 0x00000007)
#define BF_JRX_DL_204H_ECNT_TCH_1_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204H_PARITY_1_INFO 0x00000103
#define BF_JRX_DL_204H_PARITY_1(val) ((val & 0x00000001) << 0x00000003)
#define BF_JRX_DL_204H_PARITY_1_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_JRX_DL_204H_ECNT_TCR_1_INFO 0x00000304
#define BF_JRX_DL_204H_ECNT_TCR_1(val) ((val & 0x00000007) << 0x00000004)
#define BF_JRX_DL_204H_ECNT_TCR_1_GET(val) ((val >> 0x00000004) & 0x00000007)
#define BF_JRX_DL_204H_FS_1_INFO 0x00000107
#define BF_JRX_DL_204H_FS_1(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_FS_1_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_29_LANE5_ADDR 0x000009C6
#define BF_JRX_DL_204H_ECNT_TCH_2_INFO 0x00000300
#define BF_JRX_DL_204H_ECNT_TCH_2(val) (val & 0x00000007)
#define BF_JRX_DL_204H_ECNT_TCH_2_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204H_PARITY_2_INFO 0x00000103
#define BF_JRX_DL_204H_PARITY_2(val) ((val & 0x00000001) << 0x00000003)
#define BF_JRX_DL_204H_PARITY_2_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_JRX_DL_204H_ECNT_TCR_2_INFO 0x00000304
#define BF_JRX_DL_204H_ECNT_TCR_2(val) ((val & 0x00000007) << 0x00000004)
#define BF_JRX_DL_204H_ECNT_TCR_2_GET(val) ((val >> 0x00000004) & 0x00000007)
#define BF_JRX_DL_204H_FS_2_INFO 0x00000107
#define BF_JRX_DL_204H_FS_2(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_FS_2_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_29_LANE4_ADDR 0x000009BC
#define BF_JRX_DL_204H_ECNT_TCH_3_INFO 0x00000300
#define BF_JRX_DL_204H_ECNT_TCH_3(val) (val & 0x00000007)
#define BF_JRX_DL_204H_ECNT_TCH_3_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204H_PARITY_3_INFO 0x00000103
#define BF_JRX_DL_204H_PARITY_3(val) ((val & 0x00000001) << 0x00000003)
#define BF_JRX_DL_204H_PARITY_3_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_JRX_DL_204H_ECNT_TCR_3_INFO 0x00000304
#define BF_JRX_DL_204H_ECNT_TCR_3(val) ((val & 0x00000007) << 0x00000004)
#define BF_JRX_DL_204H_ECNT_TCR_3_GET(val) ((val >> 0x00000004) & 0x00000007)
#define BF_JRX_DL_204H_FS_3_INFO 0x00000107
#define BF_JRX_DL_204H_FS_3(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_FS_3_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_29_LANE3_ADDR 0x000009B2
#define BF_JRX_DL_204H_ECNT_TCH_4_INFO 0x00000300
#define BF_JRX_DL_204H_ECNT_TCH_4(val) (val & 0x00000007)
#define BF_JRX_DL_204H_ECNT_TCH_4_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204H_PARITY_4_INFO 0x00000103
#define BF_JRX_DL_204H_PARITY_4(val) ((val & 0x00000001) << 0x00000003)
#define BF_JRX_DL_204H_PARITY_4_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_JRX_DL_204H_ECNT_TCR_4_INFO 0x00000304
#define BF_JRX_DL_204H_ECNT_TCR_4(val) ((val & 0x00000007) << 0x00000004)
#define BF_JRX_DL_204H_ECNT_TCR_4_GET(val) ((val >> 0x00000004) & 0x00000007)
#define BF_JRX_DL_204H_FS_4_INFO 0x00000107
#define BF_JRX_DL_204H_FS_4(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_FS_4_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_29_LANE2_ADDR 0x000009A8
#define BF_JRX_DL_204H_ECNT_TCH_5_INFO 0x00000300
#define BF_JRX_DL_204H_ECNT_TCH_5(val) (val & 0x00000007)
#define BF_JRX_DL_204H_ECNT_TCH_5_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204H_PARITY_5_INFO 0x00000103
#define BF_JRX_DL_204H_PARITY_5(val) ((val & 0x00000001) << 0x00000003)
#define BF_JRX_DL_204H_PARITY_5_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_JRX_DL_204H_ECNT_TCR_5_INFO 0x00000304
#define BF_JRX_DL_204H_ECNT_TCR_5(val) ((val & 0x00000007) << 0x00000004)
#define BF_JRX_DL_204H_ECNT_TCR_5_GET(val) ((val >> 0x00000004) & 0x00000007)
#define BF_JRX_DL_204H_FS_5_INFO 0x00000107
#define BF_JRX_DL_204H_FS_5(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_FS_5_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_29_LANE1_ADDR 0x0000099E
#define BF_JRX_DL_204H_ECNT_TCH_6_INFO 0x00000300
#define BF_JRX_DL_204H_ECNT_TCH_6(val) (val & 0x00000007)
#define BF_JRX_DL_204H_ECNT_TCH_6_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204H_PARITY_6_INFO 0x00000103
#define BF_JRX_DL_204H_PARITY_6(val) ((val & 0x00000001) << 0x00000003)
#define BF_JRX_DL_204H_PARITY_6_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_JRX_DL_204H_ECNT_TCR_6_INFO 0x00000304
#define BF_JRX_DL_204H_ECNT_TCR_6(val) ((val & 0x00000007) << 0x00000004)
#define BF_JRX_DL_204H_ECNT_TCR_6_GET(val) ((val >> 0x00000004) & 0x00000007)
#define BF_JRX_DL_204H_FS_6_INFO 0x00000107
#define BF_JRX_DL_204H_FS_6(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_FS_6_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_29_LANE0_ADDR 0x00000994
#define BF_JRX_DL_204H_ECNT_TCH_7_INFO 0x00000300
#define BF_JRX_DL_204H_ECNT_TCH_7(val) (val & 0x00000007)
#define BF_JRX_DL_204H_ECNT_TCH_7_GET(val) (val & 0x00000007)
#define BF_JRX_DL_204H_PARITY_7_INFO 0x00000103
#define BF_JRX_DL_204H_PARITY_7(val) ((val & 0x00000001) << 0x00000003)
#define BF_JRX_DL_204H_PARITY_7_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_JRX_DL_204H_ECNT_TCR_7_INFO 0x00000304
#define BF_JRX_DL_204H_ECNT_TCR_7(val) ((val & 0x00000007) << 0x00000004)
#define BF_JRX_DL_204H_ECNT_TCR_7_GET(val) ((val >> 0x00000004) & 0x00000007)
#define BF_JRX_DL_204H_FS_7_INFO 0x00000107
#define BF_JRX_DL_204H_FS_7(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_FS_7_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_30_LANE7_ADDR 0x000009DB
#define BF_JRX_DL_204H_PARITY_ERR_CNT_0_INFO 0x00000800
#define BF_JRX_DL_204H_PARITY_ERR_CNT_0(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_PARITY_ERR_CNT_0_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_30_LANE6_ADDR 0x000009D1
#define BF_JRX_DL_204H_PARITY_ERR_CNT_1_INFO 0x00000800
#define BF_JRX_DL_204H_PARITY_ERR_CNT_1(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_PARITY_ERR_CNT_1_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_30_LANE5_ADDR 0x000009C7
#define BF_JRX_DL_204H_PARITY_ERR_CNT_2_INFO 0x00000800
#define BF_JRX_DL_204H_PARITY_ERR_CNT_2(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_PARITY_ERR_CNT_2_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_30_LANE4_ADDR 0x000009BD
#define BF_JRX_DL_204H_PARITY_ERR_CNT_3_INFO 0x00000800
#define BF_JRX_DL_204H_PARITY_ERR_CNT_3(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_PARITY_ERR_CNT_3_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_30_LANE3_ADDR 0x000009B3
#define BF_JRX_DL_204H_PARITY_ERR_CNT_4_INFO 0x00000800
#define BF_JRX_DL_204H_PARITY_ERR_CNT_4(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_PARITY_ERR_CNT_4_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_30_LANE2_ADDR 0x000009A9
#define BF_JRX_DL_204H_PARITY_ERR_CNT_5_INFO 0x00000800
#define BF_JRX_DL_204H_PARITY_ERR_CNT_5(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_PARITY_ERR_CNT_5_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_30_LANE1_ADDR 0x0000099F
#define BF_JRX_DL_204H_PARITY_ERR_CNT_6_INFO 0x00000800
#define BF_JRX_DL_204H_PARITY_ERR_CNT_6(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_PARITY_ERR_CNT_6_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_30_LANE0_ADDR 0x00000995
#define BF_JRX_DL_204H_PARITY_ERR_CNT_7_INFO 0x00000800
#define BF_JRX_DL_204H_PARITY_ERR_CNT_7(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_PARITY_ERR_CNT_7_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_31_LANE7_ADDR 0x000009DD
#define BF_JRX_DL_204H_LL_FCHK_0_INFO 0x00000800
#define BF_JRX_DL_204H_LL_FCHK_0(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_LL_FCHK_0_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_31_LANE6_ADDR 0x000009D3
#define BF_JRX_DL_204H_LL_FCHK_1_INFO 0x00000800
#define BF_JRX_DL_204H_LL_FCHK_1(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_LL_FCHK_1_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_31_LANE5_ADDR 0x000009C9
#define BF_JRX_DL_204H_LL_FCHK_2_INFO 0x00000800
#define BF_JRX_DL_204H_LL_FCHK_2(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_LL_FCHK_2_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_31_LANE4_ADDR 0x000009BF
#define BF_JRX_DL_204H_LL_FCHK_3_INFO 0x00000800
#define BF_JRX_DL_204H_LL_FCHK_3(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_LL_FCHK_3_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_31_LANE3_ADDR 0x000009B5
#define BF_JRX_DL_204H_LL_FCHK_4_INFO 0x00000800
#define BF_JRX_DL_204H_LL_FCHK_4(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_LL_FCHK_4_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_31_LANE2_ADDR 0x000009AB
#define BF_JRX_DL_204H_LL_FCHK_5_INFO 0x00000800
#define BF_JRX_DL_204H_LL_FCHK_5(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_LL_FCHK_5_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_31_LANE1_ADDR 0x000009A1
#define BF_JRX_DL_204H_LL_FCHK_6_INFO 0x00000800
#define BF_JRX_DL_204H_LL_FCHK_6(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_LL_FCHK_6_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_31_LANE0_ADDR 0x00000997
#define BF_JRX_DL_204H_LL_FCHK_7_INFO 0x00000800
#define BF_JRX_DL_204H_LL_FCHK_7(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_LL_FCHK_7_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_32_LANE7_ADDR 0x000009DE
#define BF_JRX_DL_204H_LL_FCMP_0_INFO 0x00000800
#define BF_JRX_DL_204H_LL_FCMP_0(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_LL_FCMP_0_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_32_LANE6_ADDR 0x000009D4
#define BF_JRX_DL_204H_LL_FCMP_1_INFO 0x00000800
#define BF_JRX_DL_204H_LL_FCMP_1(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_LL_FCMP_1_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_32_LANE5_ADDR 0x000009CA
#define BF_JRX_DL_204H_LL_FCMP_2_INFO 0x00000800
#define BF_JRX_DL_204H_LL_FCMP_2(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_LL_FCMP_2_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_32_LANE4_ADDR 0x000009C0
#define BF_JRX_DL_204H_LL_FCMP_3_INFO 0x00000800
#define BF_JRX_DL_204H_LL_FCMP_3(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_LL_FCMP_3_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_32_LANE3_ADDR 0x000009B6
#define BF_JRX_DL_204H_LL_FCMP_4_INFO 0x00000800
#define BF_JRX_DL_204H_LL_FCMP_4(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_LL_FCMP_4_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_32_LANE2_ADDR 0x000009AC
#define BF_JRX_DL_204H_LL_FCMP_5_INFO 0x00000800
#define BF_JRX_DL_204H_LL_FCMP_5(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_LL_FCMP_5_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_32_LANE1_ADDR 0x000009A2
#define BF_JRX_DL_204H_LL_FCMP_6_INFO 0x00000800
#define BF_JRX_DL_204H_LL_FCMP_6(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_LL_FCMP_6_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_32_LANE0_ADDR 0x00000998
#define BF_JRX_DL_204H_LL_FCMP_7_INFO 0x00000800
#define BF_JRX_DL_204H_LL_FCMP_7(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_LL_FCMP_7_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_33_LANE7_ADDR 0x000009DF
#define BF_JRX_DL_204H_LL_LID_0_INFO 0x00000500
#define BF_JRX_DL_204H_LL_LID_0(val) (val & 0x0000001F)
#define BF_JRX_DL_204H_LL_LID_0_GET(val) (val & 0x0000001F)
#define BF_JRX_DL_204H_ILS_0_INFO 0x00000105
#define BF_JRX_DL_204H_ILS_0(val) ((val & 0x00000001) << 0x00000005)
#define BF_JRX_DL_204H_ILS_0_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_JRX_DL_204H_ILD_0_INFO 0x00000106
#define BF_JRX_DL_204H_ILD_0(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_DL_204H_ILD_0_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_JRX_DL_204H_SH_0_INFO 0x00000107
#define BF_JRX_DL_204H_SH_0(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_SH_0_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_33_LANE6_ADDR 0x000009D5
#define BF_JRX_DL_204H_LL_LID_1_INFO 0x00000500
#define BF_JRX_DL_204H_LL_LID_1(val) (val & 0x0000001F)
#define BF_JRX_DL_204H_LL_LID_1_GET(val) (val & 0x0000001F)
#define BF_JRX_DL_204H_ILS_1_INFO 0x00000105
#define BF_JRX_DL_204H_ILS_1(val) ((val & 0x00000001) << 0x00000005)
#define BF_JRX_DL_204H_ILS_1_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_JRX_DL_204H_ILD_1_INFO 0x00000106
#define BF_JRX_DL_204H_ILD_1(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_DL_204H_ILD_1_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_JRX_DL_204H_SH_1_INFO 0x00000107
#define BF_JRX_DL_204H_SH_1(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_SH_1_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_33_LANE5_ADDR 0x000009CB
#define BF_JRX_DL_204H_LL_LID_2_INFO 0x00000500
#define BF_JRX_DL_204H_LL_LID_2(val) (val & 0x0000001F)
#define BF_JRX_DL_204H_LL_LID_2_GET(val) (val & 0x0000001F)
#define BF_JRX_DL_204H_ILS_2_INFO 0x00000105
#define BF_JRX_DL_204H_ILS_2(val) ((val & 0x00000001) << 0x00000005)
#define BF_JRX_DL_204H_ILS_2_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_JRX_DL_204H_ILD_2_INFO 0x00000106
#define BF_JRX_DL_204H_ILD_2(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_DL_204H_ILD_2_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_JRX_DL_204H_SH_2_INFO 0x00000107
#define BF_JRX_DL_204H_SH_2(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_SH_2_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_33_LANE4_ADDR 0x000009C1
#define BF_JRX_DL_204H_LL_LID_3_INFO 0x00000500
#define BF_JRX_DL_204H_LL_LID_3(val) (val & 0x0000001F)
#define BF_JRX_DL_204H_LL_LID_3_GET(val) (val & 0x0000001F)
#define BF_JRX_DL_204H_ILS_3_INFO 0x00000105
#define BF_JRX_DL_204H_ILS_3(val) ((val & 0x00000001) << 0x00000005)
#define BF_JRX_DL_204H_ILS_3_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_JRX_DL_204H_ILD_3_INFO 0x00000106
#define BF_JRX_DL_204H_ILD_3(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_DL_204H_ILD_3_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_JRX_DL_204H_SH_3_INFO 0x00000107
#define BF_JRX_DL_204H_SH_3(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_SH_3_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_33_LANE3_ADDR 0x000009B7
#define BF_JRX_DL_204H_LL_LID_4_INFO 0x00000500
#define BF_JRX_DL_204H_LL_LID_4(val) (val & 0x0000001F)
#define BF_JRX_DL_204H_LL_LID_4_GET(val) (val & 0x0000001F)
#define BF_JRX_DL_204H_ILS_4_INFO 0x00000105
#define BF_JRX_DL_204H_ILS_4(val) ((val & 0x00000001) << 0x00000005)
#define BF_JRX_DL_204H_ILS_4_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_JRX_DL_204H_ILD_4_INFO 0x00000106
#define BF_JRX_DL_204H_ILD_4(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_DL_204H_ILD_4_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_JRX_DL_204H_SH_4_INFO 0x00000107
#define BF_JRX_DL_204H_SH_4(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_SH_4_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_33_LANE2_ADDR 0x000009AD
#define BF_JRX_DL_204H_LL_LID_5_INFO 0x00000500
#define BF_JRX_DL_204H_LL_LID_5(val) (val & 0x0000001F)
#define BF_JRX_DL_204H_LL_LID_5_GET(val) (val & 0x0000001F)
#define BF_JRX_DL_204H_ILS_5_INFO 0x00000105
#define BF_JRX_DL_204H_ILS_5(val) ((val & 0x00000001) << 0x00000005)
#define BF_JRX_DL_204H_ILS_5_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_JRX_DL_204H_ILD_5_INFO 0x00000106
#define BF_JRX_DL_204H_ILD_5(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_DL_204H_ILD_5_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_JRX_DL_204H_SH_5_INFO 0x00000107
#define BF_JRX_DL_204H_SH_5(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_SH_5_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_33_LANE1_ADDR 0x000009A3
#define BF_JRX_DL_204H_LL_LID_6_INFO 0x00000500
#define BF_JRX_DL_204H_LL_LID_6(val) (val & 0x0000001F)
#define BF_JRX_DL_204H_LL_LID_6_GET(val) (val & 0x0000001F)
#define BF_JRX_DL_204H_ILS_6_INFO 0x00000105
#define BF_JRX_DL_204H_ILS_6(val) ((val & 0x00000001) << 0x00000005)
#define BF_JRX_DL_204H_ILS_6_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_JRX_DL_204H_ILD_6_INFO 0x00000106
#define BF_JRX_DL_204H_ILD_6(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_DL_204H_ILD_6_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_JRX_DL_204H_SH_6_INFO 0x00000107
#define BF_JRX_DL_204H_SH_6(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_SH_6_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_33_LANE0_ADDR 0x00000999
#define BF_JRX_DL_204H_LL_LID_7_INFO 0x00000500
#define BF_JRX_DL_204H_LL_LID_7(val) (val & 0x0000001F)
#define BF_JRX_DL_204H_LL_LID_7_GET(val) (val & 0x0000001F)
#define BF_JRX_DL_204H_ILS_7_INFO 0x00000105
#define BF_JRX_DL_204H_ILS_7(val) ((val & 0x00000001) << 0x00000005)
#define BF_JRX_DL_204H_ILS_7_GET(val) ((val >> 0x00000005) & 0x00000001)
#define BF_JRX_DL_204H_ILD_7_INFO 0x00000106
#define BF_JRX_DL_204H_ILD_7(val) ((val & 0x00000001) << 0x00000006)
#define BF_JRX_DL_204H_ILD_7_GET(val) ((val >> 0x00000006) & 0x00000001)
#define BF_JRX_DL_204H_SH_7_INFO 0x00000107
#define BF_JRX_DL_204H_SH_7(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_SH_7_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_34_LANE7_ADDR 0x000009E0
#define BF_JRX_DL_204H_SH_ERR_CNT_0_INFO 0x00000800
#define BF_JRX_DL_204H_SH_ERR_CNT_0(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_SH_ERR_CNT_0_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_34_LANE6_ADDR 0x000009D6
#define BF_JRX_DL_204H_SH_ERR_CNT_1_INFO 0x00000800
#define BF_JRX_DL_204H_SH_ERR_CNT_1(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_SH_ERR_CNT_1_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_34_LANE5_ADDR 0x000009CC
#define BF_JRX_DL_204H_SH_ERR_CNT_2_INFO 0x00000800
#define BF_JRX_DL_204H_SH_ERR_CNT_2(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_SH_ERR_CNT_2_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_34_LANE4_ADDR 0x000009C2
#define BF_JRX_DL_204H_SH_ERR_CNT_3_INFO 0x00000800
#define BF_JRX_DL_204H_SH_ERR_CNT_3(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_SH_ERR_CNT_3_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_34_LANE3_ADDR 0x000009B8
#define BF_JRX_DL_204H_SH_ERR_CNT_4_INFO 0x00000800
#define BF_JRX_DL_204H_SH_ERR_CNT_4(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_SH_ERR_CNT_4_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_34_LANE2_ADDR 0x000009AE
#define BF_JRX_DL_204H_SH_ERR_CNT_5_INFO 0x00000800
#define BF_JRX_DL_204H_SH_ERR_CNT_5(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_SH_ERR_CNT_5_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_34_LANE1_ADDR 0x000009A4
#define BF_JRX_DL_204H_SH_ERR_CNT_6_INFO 0x00000800
#define BF_JRX_DL_204H_SH_ERR_CNT_6(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_SH_ERR_CNT_6_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_34_LANE0_ADDR 0x0000099A
#define BF_JRX_DL_204H_SH_ERR_CNT_7_INFO 0x00000800
#define BF_JRX_DL_204H_SH_ERR_CNT_7(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_SH_ERR_CNT_7_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_35_LANE7_ADDR 0x000009E1
#define BF_JRX_DL_204H_UEK_0_INFO 0x00000107
#define BF_JRX_DL_204H_UEK_0(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_UEK_0_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_35_LANE6_ADDR 0x000009D7
#define BF_JRX_DL_204H_UEK_1_INFO 0x00000107
#define BF_JRX_DL_204H_UEK_1(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_UEK_1_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_35_LANE5_ADDR 0x000009CD
#define BF_JRX_DL_204H_UEK_2_INFO 0x00000107
#define BF_JRX_DL_204H_UEK_2(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_UEK_2_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_35_LANE4_ADDR 0x000009C3
#define BF_JRX_DL_204H_UEK_3_INFO 0x00000107
#define BF_JRX_DL_204H_UEK_3(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_UEK_3_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_35_LANE3_ADDR 0x000009B9
#define BF_JRX_DL_204H_UEK_4_INFO 0x00000107
#define BF_JRX_DL_204H_UEK_4(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_UEK_4_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_35_LANE2_ADDR 0x000009AF
#define BF_JRX_DL_204H_UEK_5_INFO 0x00000107
#define BF_JRX_DL_204H_UEK_5(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_UEK_5_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_35_LANE1_ADDR 0x000009A5
#define BF_JRX_DL_204H_UEK_6_INFO 0x00000107
#define BF_JRX_DL_204H_UEK_6(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_UEK_6_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_35_LANE0_ADDR 0x0000099B
#define BF_JRX_DL_204H_UEK_7_INFO 0x00000107
#define BF_JRX_DL_204H_UEK_7(val) ((val & 0x00000001) << 0x00000007)
#define BF_JRX_DL_204H_UEK_7_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_JRX_DL_204H_36_LANE7_ADDR 0x000009E2
#define BF_JRX_DL_204H_UEK_ERR_CNT_0_INFO 0x00000800
#define BF_JRX_DL_204H_UEK_ERR_CNT_0(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_UEK_ERR_CNT_0_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_36_LANE6_ADDR 0x000009D8
#define BF_JRX_DL_204H_UEK_ERR_CNT_1_INFO 0x00000800
#define BF_JRX_DL_204H_UEK_ERR_CNT_1(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_UEK_ERR_CNT_1_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_36_LANE5_ADDR 0x000009CE
#define BF_JRX_DL_204H_UEK_ERR_CNT_2_INFO 0x00000800
#define BF_JRX_DL_204H_UEK_ERR_CNT_2(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_UEK_ERR_CNT_2_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_36_LANE4_ADDR 0x000009C4
#define BF_JRX_DL_204H_UEK_ERR_CNT_3_INFO 0x00000800
#define BF_JRX_DL_204H_UEK_ERR_CNT_3(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_UEK_ERR_CNT_3_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_36_LANE3_ADDR 0x000009BA
#define BF_JRX_DL_204H_UEK_ERR_CNT_4_INFO 0x00000800
#define BF_JRX_DL_204H_UEK_ERR_CNT_4(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_UEK_ERR_CNT_4_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_36_LANE2_ADDR 0x000009B0
#define BF_JRX_DL_204H_UEK_ERR_CNT_5_INFO 0x00000800
#define BF_JRX_DL_204H_UEK_ERR_CNT_5(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_UEK_ERR_CNT_5_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_36_LANE1_ADDR 0x000009A6
#define BF_JRX_DL_204H_UEK_ERR_CNT_6_INFO 0x00000800
#define BF_JRX_DL_204H_UEK_ERR_CNT_6(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_UEK_ERR_CNT_6_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_36_LANE0_ADDR 0x0000099C
#define BF_JRX_DL_204H_UEK_ERR_CNT_7_INFO 0x00000800
#define BF_JRX_DL_204H_UEK_ERR_CNT_7(val) (val & 0x000000FF)
#define BF_JRX_DL_204H_UEK_ERR_CNT_7_GET(val) (val & 0x000000FF)

#define REG_JRX_DL_204H_37_ADDR 0x000009EC
#define BF_JRX_DL_204H_ENABLE_INFO 0x00000100
#define BF_JRX_DL_204H_ENABLE(val) (val & 0x00000001)
#define BF_JRX_DL_204H_ENABLE_GET(val) (val & 0x00000001)
#define BF_JRX_DL_204H_SH_ERR_CFG_INFO 0x00000601
#define BF_JRX_DL_204H_SH_ERR_CFG(val) ((val & 0x0000003F) << 0x00000001)
#define BF_JRX_DL_204H_SH_ERR_CFG_GET(val) ((val >> 0x00000001) & 0x0000003F)

#define REG_CLK_PLL_STATUS_ADDR 0x00002008
#define BF_PLL_LOCK_SLOW_INFO 0x00000100
#define BF_PLL_LOCK_SLOW(val) (val & 0x00000001)
#define BF_PLL_LOCK_SLOW_GET(val) (val & 0x00000001)
#define BF_PLL_LOCK_FAST_INFO 0x00000101
#define BF_PLL_LOCK_FAST(val) ((val & 0x00000001) << 0x00000001)
#define BF_PLL_LOCK_FAST_GET(val) ((val >> 0x00000001) & 0x00000001)

#define REG_SAMPLE_PRBS_CTRL0_ADDR 0x00002061
#define BF_UPDATE_ERROR_COUNT_INFO 0x00000100
#define BF_UPDATE_ERROR_COUNT(val) (val & 0x00000001)
#define BF_UPDATE_ERROR_COUNT_GET(val) (val & 0x00000001)
#define BF_SWAP_ENDIANNESS_INFO 0x00000101
#define BF_SWAP_ENDIANNESS(val) ((val & 0x00000001) << 0x00000001)
#define BF_SWAP_ENDIANNESS_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_CLR_ERRORS_INFO 0x00000102
#define BF_CLR_ERRORS(val) ((val & 0x00000001) << 0x00000002)
#define BF_CLR_ERRORS_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_PRBS_CHNL_SEL_INFO 0x00000303
#define BF_PRBS_CHNL_SEL(val) ((val & 0x00000007) << 0x00000003)
#define BF_PRBS_CHNL_SEL_GET(val) ((val >> 0x00000003) & 0x00000007)
#define BF_SAMPLE_PRBS_ENABLE_INFO 0x00000106
#define BF_SAMPLE_PRBS_ENABLE(val) ((val & 0x00000001) << 0x00000006)
#define BF_SAMPLE_PRBS_ENABLE_GET(val) ((val >> 0x00000006) & 0x00000001)

#define REG_SAMPLE_PRBS_CTRL1_ADDR 0x00002062
#define BF_PRBS_MODE_INFO 0x00000300
#define BF_PRBS_MODE(val) (val & 0x00000007)
#define BF_PRBS_MODE_GET(val) (val & 0x00000007)
#define BF_PRBS_INV_REAL_INFO 0x00000103
#define BF_PRBS_INV_REAL(val) ((val & 0x00000001) << 0x00000003)
#define BF_PRBS_INV_REAL_GET(val) ((val >> 0x00000003) & 0x00000001)
#define BF_PRBS_INV_IMAG_INFO 0x00000104
#define BF_PRBS_INV_IMAG(val) ((val & 0x00000001) << 0x00000004)
#define BF_PRBS_INV_IMAG_GET(val) ((val >> 0x00000004) & 0x00000001)

#define REG_SAMPLE_PRBS_STATUS0_ADDR 0x00002063
#define BF_PRBS_INVALID_DATA_FLAG_I_INFO 0x00000100
#define BF_PRBS_INVALID_DATA_FLAG_I(val) (val & 0x00000001)
#define BF_PRBS_INVALID_DATA_FLAG_I_GET(val) (val & 0x00000001)
#define BF_PRBS_INVALID_DATA_FLAG_Q_INFO 0x00000101
#define BF_PRBS_INVALID_DATA_FLAG_Q(val) ((val & 0x00000001) << 0x00000001)
#define BF_PRBS_INVALID_DATA_FLAG_Q_GET(val) ((val >> 0x00000001) & 0x00000001)
#define BF_PRBS_ERROR_FLAG_I_INFO 0x00000102
#define BF_PRBS_ERROR_FLAG_I(val) ((val & 0x00000001) << 0x00000002)
#define BF_PRBS_ERROR_FLAG_I_GET(val) ((val >> 0x00000002) & 0x00000001)
#define BF_PRBS_ERROR_FLAG_Q_INFO 0x00000103
#define BF_PRBS_ERROR_FLAG_Q(val) ((val & 0x00000001) << 0x00000003)
#define BF_PRBS_ERROR_FLAG_Q_GET(val) ((val >> 0x00000003) & 0x00000001)

#define REG_SAMPLE_PRBS_STATUS1_ADDR 0x00002064
#define BF_ERROR_COUNT_I_INFO 0x00001800
#define BF_ERROR_COUNT_I(val) (val & 0x00FFFFFF)
#define BF_ERROR_COUNT_I_GET(val) (val & 0x00FFFFFF)

#define REG_SAMPLE_PRBS_STATUS2_ADDR 0x00002065

#define REG_SAMPLE_PRBS_STATUS3_ADDR 0x00002066

#define REG_DSA_CFG0_ADDR 0x000020D0
#define BF_DSA_CTRL_INFO 0x00000800
#define BF_DSA_CTRL(val) (val & 0x000000FF)
#define BF_DSA_CTRL_GET(val) (val & 0x000000FF)

#define REG_DSA_CFG1_ADDR 0x000020D1
#define BF_DSA_CUTOVER_INFO 0x00000800
#define BF_DSA_CUTOVER(val) (val & 0x000000FF)
#define BF_DSA_CUTOVER_GET(val) (val & 0x000000FF)

#define REG_DSA_CFG2_ADDR 0x000020D2
#define BF_DSA_BOOST_INFO 0x00000500
#define BF_DSA_BOOST(val) (val & 0x0000001F)
#define BF_DSA_BOOST_GET(val) (val & 0x0000001F)
#define BF_EN_DSA_CTRL_INFO 0x00000107
#define BF_EN_DSA_CTRL(val) ((val & 0x00000001) << 0x00000007)
#define BF_EN_DSA_CTRL_GET(val) ((val >> 0x00000007) & 0x00000001)

#define REG_DP_GAIN0_ADDR 0x000020D3
#define BF_DP_GAIN_INFO 0x00000C00
#define BF_DP_GAIN(val) (val & 0x00000FFF)
#define BF_DP_GAIN_GET(val) (val & 0x00000FFF)

#define REG_DP_GAIN1_ADDR 0x000020D4
#define BF_GAIN_LOAD_STROBE_INFO 0x00000107
#define BF_GAIN_LOAD_STROBE(val) ((val & 0x00000001) << 0x00000007)
#define BF_GAIN_LOAD_STROBE_GET(val) ((val >> 0x00000007) & 0x00000001)

#endif /* __ADI_AD9081_BF_AD9081_H__ */
/*! @} */