
# no-OS
[![Build Status](https://dev.azure.com/AnalogDevices/no-OS/_apis/build/status%2Fanalogdevicesinc.no-OS?branchName=main)](https://dev.azure.com/AnalogDevices/no-OS/_build/latest?definitionId=48&branchName=main)

[Analog Devices Inc.](http://www.analog.com/en/index.html) Software drivers for systems without OS.


## Software

The majority of ADI's products are peripherals to a non-ADI digital engine (FPGA, microprocessor, or microcontroller). While there is major work underway on FPGAs (Xilinx and Intel/Altera) and microprocessors (running an operating system like Linux), the efforts on microcontrollers are fragmented due to the diverse nature of the microcontroller market. The goal of these projects (microcontroller/no-OS) is to be able to provide reference projects for lower end processors, which can't run Linux or aren't running a specific operating system, to help customers using FPGA/microcontrollers with ADI parts.

## Documentation

For more information about no-OS drivers, please visit our [wiki](https://wiki.analog.com/resources/no-os) page.

Code documentation is automatically generated using Doxygen tool, available at [no-OS Github Pages](http://analogdevicesinc.github.io/no-OS/doxygen/).

## Build

Build guide for no-OS projects:
  * [NO-OS Build Guide](https://wiki.analog.com/resources/no-os/build)

## Code Style
When writing code, please follow the [style guidelines](https://github.com/analogdevicesinc/no-OS/wiki/Code-Style-guidelines).

## Which branch should I use?

  * If you want to use the most stable code base, always use the [latest release branch]( https://github.com/analogdevicesinc/no-OS/branches/all?utf8=%E2%9C%93&query=201).

  * If you want to use the greatest and latest, check out the main branch.


## Support

Feel free to ask any question at [EngineerZone]( https://ez.analog.com/linux-device-drivers/microcontroller-no-os-drivers/f/q-a).
